#include <stdio.h>
#include "tk.h"

/* this file contains example code for interfacing GL to Tcl. The 
   functions here do app-specific initialization, inform the interpreter
   about app commands, and provide "wrapper" functions for calling
   GL from Tcl. */


extern int 
  glxtst_render_cmd(), 
  glxtst_init_cmd(), 
  glxtst_finish_cmd(), 
  glxtst_param_cmd(), 
  glxtst_init_cmd();


/* ARGSUSED */
glxtst_tcl_init(interp, w)
     Tcl_Interp *interp;
     Tk_Window w;
{
  /* Called from "glxwish" to initialize app-specific Tcl commands.
     Each app will have a different set of commands. 
   */

  Tcl_CreateCommand(interp, "gl-render", glxtst_render_cmd, NULL, NULL);
  Tcl_CreateCommand(interp, "gl-init", glxtst_init_cmd, NULL, NULL);
  Tcl_CreateCommand(interp, "gl-finish", glxtst_finish_cmd, NULL, NULL);
  Tcl_CreateCommand(interp, "gl-param", glxtst_param_cmd, NULL, NULL);
  glxtst_var_init();
}  

/* ARGSUSED */
int glxtst_render_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  /* one render  */
  glxtst_render();
  return(TCL_OK);
}


/* ARGSUSED */
int glxtst_init_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  glxtst_init();
  return(TCL_OK);
}

/* ARGSUSED */
int glxtst_finish_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  /* one render  */
  glxtst_finish();
  return(TCL_OK);
}


/* ARGSUSED */
int
glxtst_param_cmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
  /* useful for setting variables in your GL program */

  /* get */
  if (argc == 2){
    if(glxtst_param(argv[1], interp->result, 0) != 0){
      Tcl_AppendResult(interp, 
		       "bad param name \"", argv[1], "\"", (char *) NULL);
      return(TCL_ERROR);
    }

    return(TCL_OK);
  }

  /* set */
  else if (argc == 3){
    if(glxtst_param(argv[1], argv[2], 1) != 0){
      Tcl_AppendResult(interp, 
		       "bad param name \"", argv[1], "\"", (char *) NULL);
      return(TCL_ERROR);
    }
    return(TCL_OK);
  }

  else {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " param val\"", (char *) NULL);
    return(TCL_ERROR);
  }
}
