'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'/" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS glxwin cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
glxwin \- Create and manipulate glxwin widgets
.SH SYNOPSIS
\fBglxwin\fI \fIpathName\fR ?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBcursor\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf

.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP

Specifies the desired height for the window in any of the forms
acceptable to \fBTk_GetPixels\fR.  If this option is less than or
equal to zero then the window will not request any size at all.

.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP

Specifies the desired width for the window in any of the forms
acceptable to \fBTk_GetPixels\fR.  If this option is less than or
equal to zero then the window will not request any size at all.

.LP
.nf
Name:	\fBrgbMode\fR
Class:	\fBRgbMode\fR
Command-Line Switch:	\fB\-rgbmode\fR
.fi
.IP

This boolean specifies the color mode of the main GL window.  By
default, this window will be in color map (cmap) mode. Setting this
option to true specifies that the window should be in RGB mode.  This
command line switch can also be used to configure individual buffer 
windows (see BUFFER COMMANDS below).

.LP
.nf
Name:	\fBdoubleBuffer\fR
Class:	\fBDoubleBuffer\fR
Command-Line Switch:	\fB\-doublebuffer\fR
.fi
.IP

This boolean specifies whether of not the main GL window should be
double buffered.  By default, it is not. This command line switch can
also be used to configure individual buffer windows (see BUFFER
COMMANDS below).

.BE
.LP
.nf
Name:	\fBstencilSize\fR
Class:	\fBStencilSize\fR
Command-Line Switch:	\fB\-stencilsize\fR
.fi
.IP

Specifies the size (in bits) of the GL stencil buffer for the main GL
window.  If queried, the value of this option will reflect the actual
configuration of the window, not necessarily the configuration that
was requested.  By default, the value is 0, which means don't request
that the stencil size be set at all. A value of \-1 is special in that
it sets the size of the buffer to the symbolic constant GLX_NOCONFIG,
which in turn sets the buffer to be the largest size for a particular
hardware platform.  This command line switch can also be used to
configure individual buffer windows (see BUFFER COMMANDS below).

.LP
.nf
Name:	\fBaccumSize\fR
Class:	\fBAccumSize\fR
Command-Line Switch:	\fB\-accumsize\fR
.fi
.IP

Same as for \fBstencilSize\fR, but instead refers to the size of the
GL accumulation buffer for the main GL window. By default, the value
is 0, which means don't request that the accumulation buffer size be
set at all. A value of \-1 is special in that it sets the size of the
buffer to the symbolic constant GLX_NOCONFIG, which in turn sets the
buffer to be the largest size for a particular hardware platform. This
command line switch can also be used to configure individual buffer
windows (see BUFFER COMMANDS below).

.LP
.nf
Name:	\fBzbufferSize\fR
Class:	\fBZbufferSize\fR
Command-Line Switch:	\fB\-zbuffersize\fR
.fi
.IP

Same as for \fBstencilSize\fR, but instead refers to the size of the
GL Z buffer.  By default, the value is 0, which means don't request
that the zbuffer size be set at all. A value of \-1 is special in that
it sets the size of the buffer to the symbolic constant GLX_NOCONFIG,
which in turn sets the buffer to be the largest size for a particular
hardware platform.  This command line switch can also be used to
configure individual buffer windows (see BUFFER COMMANDS below).

.LP
.nf
Name:	\fBbufferSize\fR
Class:	\fBBufferSize\fR
Command-Line Switch:	\fB\-buffersize\fR
.fi
.IP

Same as for \fBstencilSize\fR, but instead refers to the size of the
main GL buffer.  A value of \-1 is special in that it sets the size of
the buffer to the symbolic constant GLX_NOCONFIG, which in turn sets
the buffer to be the largest size for a particular hardware platform.
The default value is \-1.  This command line switch can also be used
to configure individual buffer windows (see BUFFER COMMANDS below).

.LP
.nf
Name:	\fBref\fR
Class:	\fBRef\fR
Command-Line Switch:	\fB\-ref\fR
.fi
.IP

Assigns an reference name to the widget.  This reference name (or
``ref'' for short) can be used to access information about the
widget's configuration and to manipulate the widget from inside of
imbedded C code.

.BE

.SH DESCRIPTION
.PP

The \fBglxwin\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a glxwin widget.

Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the glxwin.
The \fBglxwin\fR command returns the path name of the new window.

.PP

The \fBglxwin\fR widget provides access to a window usable by the
Silicon Graphics GL library from Tk.  It uses a user-provided
description of GL window characteristics to initialize the GLX
interface and to create an X window with appropriate visual type and
depth.  The X window is linked to GL (using the GLXlink() and
GLXwinset() function calls) the first time the window is mapped.  No
GL functions are directly supported by \fBglxwin\fR. Rather, a user's
Tk script calls Tcl functions that in turn invoke GL drawing code
written in C.  Access to window events are provided by the standard Tk
event binding mechanism; the user is responsible for handling all
events.

The \fBglxwin\fR widget supports imaging in all of the planes of the
framebuffer, including the normal, overlay, underlay, and popup
planes.  These planes can be manipulated using commands such as
\fB\ .glx overlay create \fR and \fB\ .glx popup config\fR.  If windows are
created in framebuffer planes auxiliary to the main window (which
exists in the ``normal'' planes), the size of those windows
automatically tracks the size of the main window when the window is
resized.

An additional mechanism called ``refs'' provides access to a glxwin
window from C.  A ``ref'' is a functional name for a window, distinct
from and complimentary to is Tk (or structural) name.  By default,
windows have no ref.  If a widget is configured with the \fB-ref\fR
\fIrefname\fR option, \fIrefname\fR becomes uniquely associated with
that widget.  The user's imbedded C code can use the ref name as a key
to retrieve information about the window's GL and X configuration and
to choose the current render window. For example:

.DS
Display  *d;
Window   w, ow;
int zbuf_size;
char *ref = "render_window";

if(TkGLXwin_RefExists(ref)){
    d  = TkGLXwin_RefGetDisplay(ref);
    w  = TkGLXwin_RefGetWindow(ref, GLX_NORMAL);
    ow = TkGLXwin_RefGetWindow(ref, GLX_OVERLAY);
    /* do something with the windows  */

    /* find the zbuffer size */
    zbuf_size = TkGLXwin_RefGetParam(ref, GLX_NORMAL, GLX_ZSIZE);

    /* select the overlay planes */
    TkGLXwin_RefWinset(ref, GLX_OVERLAY);
}
.DE

.PP
.SH "WIDGET COMMAND"
.PP
The \fBglxwin\fR command creates a new Tcl command whose
name is the same as the path name of the glxwin's window.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command, which is the same as
the glxwin widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for glxwin widgets:

.TP

\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?  

Query or modify the configuration options of the widget.  If
no \fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.

\fIOption\fR may have any of the values accepted by the \fBglxwin\fR
command.

.TP

\fIpathName \fBwinset\fR

Establish the GL window associated with this widget as the application's
current drawing window.  When a glxwin widget is created, it becomes
the current drawing widget.  This option allows several GL windows
to be used in a single application.

.TP

\fIpathName \fBislinked\fR

Returns 1 if the X window associated with the widget has been linked to
GL, 0 if is hasn't.  No rendering should be done into a window before
the window has been linked.

.TP

\fIpathName \fBref\fR ?\fIrefname\fR?

Query or modify the ref name of the widget.  If no \fIrefname\fR is
not specified, returns the ref associated with the GLX widget.  If no ref is associated with the widget, an empty string is
returned.  If
\fIrefname\fR is given, the ref for the widget is set to be that
string.  If \fIrefname\fR is the empty string, no ref is associated
with the widget.

.TP

\fIpathName \fBinstallcolormaps\fR

Explicitly set the WM_COLORMAP_WINDOWS property on the widget's
toplevel window to include all existing windows in this widget.
Setting this property tells the window manager to install the
colormap of this window at appropriate times.  

GLXwin automatically tries to set this property when the widget
is created (and to modify it when the window is destroyed).  However,
other packages may modify the WM_COLORMAP_WINDOWS property also, 
perhaps removing the GLXwin windows from the list.
\fBinstallcolormaps\fI will put them back in as friendly a way as
possible. 

.TP

\fIpathName \fBuninstallcolormaps\fR

Remove all windows associated with this widget from the
WM_COLORMAP_WINDOWS property list on the widget's toplevel window.
This command should be used to clean up an explicitly installed 
colormap when the widget is deleted.  Normally, explicit
deinstallation isn't necessary.

.TP

\fIpathName \fIbuffername\fR \fIoption\fR ?\fIarg arg ...\fR?

Query or modify the window located in a particular set of framebuffer
planes.  \fBBuffername\fR can be either \fBnormal\fR, \fBoverlay\fR,
\fBunderlay\fR, or \fBpopup\fR.  Further options to this command
will perform operations on the selected window type.  

.PP
.SH "BUFFER COMMANDS"
.PP

\fIpathName \fIbuffername\fR ?\fBcreate\fR? \fIoption\fR \fI?value option value ...\fR?  

Create a window in one of the auxiliary planes of the GL framebuffer.
\fIOption\fR can be any valid buffer configuration option as described
below.  

.TP

\fIpathName \fIbuffername\fR ?\fBconfigure\fR? \fIoption\fR \fI?value option value ...\fR?  

Query or modify the window located in \fIbuffername\fR.  Many of the
options used to configure the normal window (using \fIpathName
configure\fR) can also be used to configure individual buffer windows.

GLXwin called GLXgetconfig() immediately to try and statisfy the
request, but the configuration may be modified by hardware limitations
and later configure calls.  After configuration is complete, the user
should confirm the configuration by requesting the size of a buffer.

.TP

\fIpathName \fIbuffername\fR \fBexists\fR

Returns 1 if \fIbuffername\fR currently exists in the configuration
for a given window, 0 if it does not.  The window itself may not
yet exist, however.

.TP

\fIpathName \fIbuffername\fR \fBid\fR

Returns the X window ID for the window in \fIbuffername\fR associated
with the widget.  If the buffer exists but the window does not (yet),
the empty string is returned.

.TP

\fIpathName \fIbuffername\fR \fBwinset\fR

Sets the current GL rendering window to be the window in
\fIbuffername\fR associated with the widget.

.SH BINDINGS
.PP
When a new glxwin is created, it has no default event bindings. The user
is responsible for handling all events, particularly Expose events.
Configure events should be caught and the results fed to the GL function
\fIviewport()\fR.

.SH KEYWORDS
glxwin, GL, widget

