
#---------------------------------------------------------------------------
#
#	Button Creation
#
#---------------------------------------------------------------------------

defwidget Button Label

defmethod Button new {name args} {

  args	text bitmap action {textfont bold} {width 12} layout symbolic \
	{relief flat}

  if { $bitmap == {} } then {
    button ${name} -text $text -font [Font slot $textfont] \
	-borderwidth 3 -width $width -command ${action} \
	-relief raised \
	-foreground [Color slot fg] \
	-background [Color slot bg,button] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled]
  } {
    set bd [expr { ($relief == "flat") ? 0 : 3 }]
    button ${name} -bitmap ${bitmap} \
	-borderwidth $bd -relief $relief -command ${action} \
	-foreground [Color slot fg] \
	-background [Color slot bg] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled]
  }
  Button instantiate $name $layout [list [list symbolic $symbolic]]

  return $name
}

set system(_relief) flat

defmethod Button _get {} {

  lindex [$self! configure -text] 4
}

defmethod Button _activate {} {
  global system

  if {[lindex [$self! config -state] 4] != "disabled"} {
    $self! config -state active
    set system(button) $self
  }
}

defmethod Button _deactivate {} {
  global system

  set system(button) ""
  if {[lindex [$self! config -state] 4] != "disabled"} {
    $self! config -state normal
  }
  set system(window) ""
}

defmethod Button _down {} {
  global system

  if {[lindex [$self! config -state] 4] != "disabled"} {
    set system(_relief) [lindex [$self! config -relief] 4]
    $self! config -relief sunken
  }
}

defmethod Button _up {} {
  global system

  $self! config -relief $system(_relief)
  if {	[lindex [$self! config -state] 4] != "disabled" &&
	$system(button) != "" } {
    $self! invoke
  }
}

bind Button <Any-Enter> {%W _activate}
bind Button <Any-Leave> {%W _deactivate}
bind Button <1> {%W _down}
bind Button <ButtonRelease-1> {%W _up}

# We can't bind the button up event to a method because Tcl/Tk doesn't like
# the destruction of a parent via Dismiss that way. Dismiss also releases
# the method code, so returns from the Dismiss handler will return into
# nowhere.
#
#bind Button <ButtonRelease-1> {
#  global tk_priv
#
#  %W! config -relief $tk_priv(relief)
#  if { ("%W" == $tk_priv(window))
#	&& ([lindex [%W! config -state] 4] != "disabled")} {
#    %W! invoke
#  }
#}

#---------------------------------------------------------------------------

defwidget Checkbutton Button

defmethod Checkbutton new {name args} {

  args	text bitmap action {textfont bold} {width 12} layout variable \
	symbolic

  set options [list \
	-relief flat \
	-command $action \
	-foreground [Color slot fg] \
	-background [Color slot bg,button] \
	-selector [Color slot fg,active] \
	-activebackground [Color slot bg,active] \
	-activeforeground [Color slot fg,active] \
	-disabledforeground [Color slot fg,disabled] \
	]

  if { $bitmap == {} } then {
    lappend options \
	-text $text -font [Font slot $textfont] \
	-anchor w -padx 3 -pady 3 \
	-borderwidth 3 -width $width
  } else {
    lappend options \
	-bitmap ${bitmap} \
	-anchor c \
	-borderwidth 0
  }

  if { $variable != {} } {
    lappend options -variable [slot-variable $name $variable]
  } 

  eval [concat [list checkbutton $name] $options]
  Checkbutton instantiate $name $layout [list [list symbolic $symbolic]]
}

bind Checkbutton <Any-Enter> {%W _activate}
bind Checkbutton <Any-Leave> {%W _deactivate}
bind Checkbutton <1> {%W _down}
bind Checkbutton <ButtonRelease-1> {%W _up}

#---------------------------------------------------------------------------

defwidget Cyclebutton Button

defmethod Cyclebutton new {name args} {

}

#---------------------------------------------------------------------------

bind Radiobutton <Any-Enter> {%W _activate}
bind Radiobutton <Any-Leave> {%W _deactivate}
bind Radiobutton <1> {%W _down}
bind Radiobutton <ButtonRelease-1> {%W _up}

