#
# simple.t  scrip which demonstrates some of the basic tclvogle commands
#
set color black
set doBuffering true
set rectsObject [g_genobj]

if {[g_isobj $rectsObject]} {
    puts stderr "Error: rectsObject is defined."
    puts stderr "There is a bug somewhere!!"
    error
}

g_makeobj $rectsObject
    g_color $color
    g_clear
    g_polyfill true
    g_pushmatrix
    # make a object of nested rectangles, decreasing in size
    # and alternating in color
    foreach p { .9 .8 .7 .6 .5 .4 .3 .2 .1 } {
	case $color {white} { set color black } {black} {set color white}
	g_color $color
	g_makepoly
	g_move 0 0
	g_rect -$p -$p $p $p
	g_closepoly
    }
    # make some repeated text that rotates around the origin
    # and gets bigger with each rotation
    # looks like bike spokes 
    foreach p { 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20
		21 22 23 24 25 26 28 29 30 31 32 33 34 35 36} {
	g_move 0 0
	case $color {white} { set color black } {black} {set color white}
	g_color $color
	g_drawstr "test of tkVogle"
	g_rotate 10 z
	g_scale 1.1 1.1
    }
    g_popmatrix
g_closeobj

if {![g_isobj $rectsObject]} {
    puts stderr "Error: rectsObject is undefined."
    puts stderr "There is a bug somewhere!!"
    error
}

g_saveobj $rectsObject /usr/tmp/save__Obj__Test
g_loadobj $rectsObject /usr/tmp/save__Obj__Test

proc paintme {w} {
    global rectsObject
    g_callobj $rectsObject
}

wm minsize . 0 0 
graphic .top -command {paintme .top} \
    -font helvetica-bold \
    -geometry 250x250 -bg white -doublebuffered $doBuffering \
    -relief raised -border 4
pack append . .top {top fill expand}
update
