/*-
 * common utility functions used by tcl command extension modules
 */
#include <tcl.h>

/*
 * Some functions for pervasive error messages in this module
 */
no_args_allowed(interp, arg0) 
Tcl_Interp *interp; char *arg0;
{
    Tcl_AppendResult(interp, 
	" ", arg0, " does not accept arguments", (char *)NULL);
    return TCL_ERROR;
}

args_should_be(interp, arg0, should)
Tcl_Interp *interp; char *arg0; char *should;
{
    Tcl_AppendResult(interp, 
	" ", arg0, ": wrong # of args: should be '", arg0, " ", should, "'", 
	(char *)NULL);
    return TCL_ERROR;
}

Tcl_GetFloat(interp, string, floatPtr)
    Tcl_Interp *interp;		/* Interpreter to use for error reporting. */
    char *string;		/* String containing a floating-point number
				 * in a form acceptable to strtod. */
    float *floatPtr;		/* Place to store converted result. */
{
    char *end;
    float f;
    extern double strtod();

    f = (float)strtod(string, &end);
    while ((*end != '\0') && isspace(*end)) {
	end++;
    }
    if ((end == string) || (*end != 0)) {
	Tcl_AppendResult(interp, "expected floating-point number but got \"",
		string, "\"", (char *) NULL);
	return TCL_ERROR;
    }
    *floatPtr = f;
    return TCL_OK;
}
