/*-
 * Copyright (c) 1993, 1994 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef EVENT_H
#define EVENT_H

#include <iostream.h>
#include <strstream.h>
#include <iomanip.h>
#include <stdlib.h>
#include "SMFTrack.h"

typedef enum {NOTYPE, NORMAL, META, NOTE, NOTEOFF, NOTEON, KEYPRESSURE,
    PARAMETER, PROGRAM, CHANNELPRESSURE, PITCHWHEEL, SYSTEMEXCLUSIVE,
    METASEQUENCENUMBER, METATEXT, METACOPYRIGHT, METASEQUENCENAME,
    METAINSTRUMENTNAME, METALYRIC, METAMARKER, METACUE, METACHANNELPREFIX,
    METAPORTNUMBER, METAENDOFTRACK, METATEMPO, METASMPTE, METATIME, METAKEY,
    METASEQUENCERSPECIFIC, METAUNKNOWN} EventType;

class Event {
	friend ostream &operator<<(ostream &os, const Event &e);
public:
	Event();
	Event(unsigned long t);
	Event(const Event &e);
	virtual Event *Dup(void) const {return new Event(*this);}

	unsigned long GetTime(void) const {return (time);}
	virtual EventType GetType(void) const {return (NOTYPE);}
	virtual char *GetTypeStr(void) const {return ("NoType");}
	virtual char *GetEventStr(void) const;
	Event *GetNextEvent(void) const {return (next_event);}
	Event *GetPrevEvent(void) const {return (prev_event);}

	void SetTime(unsigned long t) {time = t;}
	void SetNextEvent(Event *n) {next_event = n;}
	void SetPrevEvent(Event *p) {prev_event = p;}

	Event &operator=(const Event &e);
	int operator==(const Event &e) const;
	void Print(ostream &os) const;

	virtual const char *SMFRead(SMFTrack &t) {return (0);}
	virtual const char *SMFWrite(SMFTrack &t) const {return (0);}
protected:
	virtual int Equal(const Event *e) const {return (time == e->time);}
private:
	unsigned long time;
	Event *next_event;
	Event *prev_event;
};
#endif
