/*-
 * Copyright (c) 1993 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * mutil.h,v 1.6 1993/05/06 21:44:06 durian Exp
 */
#ifndef MUTIL_H
#define MUTIL_H
#if defined(i386) || defined(vax)
#	define mtohl(l) ((((l) << 24) & 0xff000000L) | (((l) << 8) & \
	    0x00ff0000L) | (((l) >> 8) & 0x0000ff00L) | (((l) >> 24) & \
	    0x000000ffL))
#	define htoml(l) ((((l) << 24) & 0xff000000L) | (((l) << 8) & \
	    0x00ff0000L) | (((l) >> 8) & 0x0000ff00L) | (((l) >> 24) & \
	    0x000000ffL))
#	define mtohs(s) ((((s) << 8) & 0xff00) | (((s) >> 8) & 0x00ff))
#	define htoms(s) ((((s) << 8) & 0xff00) | (((s) >> 8) & 0x00ff))
#else
#	define mtohl(l) l
#	define mtohs(s) s
#	define htoml(l) l
#	define htoms(s) s
#endif

typedef enum {NORMAL = 0xff, SYSEX = 0xf0, METASEQNUM = 0x00, METATEXT = 0x01,
    METACPY = 0x02, METASEQNAME = 0x03, METAINSTNAME = 0x04, METALYRIC = 0x05,
    METAMARKER = 0x06, METACUE = 0x07, METACHANPREFIX = 0x20, METAEOT = 0x2f,
    METATEMPO = 0x51, METASMPTE = 0x54, METATIME = 0x58, METAKEY = 0x59,
    METASEQSPEC = 0x7f} EVENT_TYPE;

typedef struct {
        char str[4];
        long length;
        short format;
        short num_trks;
        short division;
} HCHUNK;

typedef struct {
        char str[4];
        long pos;
        long length;
	long msize;
        unsigned char *events;
        unsigned char *event_start;
	unsigned char read_rs;
	unsigned char write_rs;
} TCHUNK;

/* hack to tell us when reading from stdin if there is anymore data */
extern int MidiEof;
extern char MidiError[];

/* function prototypes */
#ifdef __STDC__
#	define _ANSI_ARGS_(x) x
#else
#	define _ANSI_ARGS_(x) ()
#endif

extern unsigned char get_running_state _ANSI_ARGS_((TCHUNK *));
extern int get_smf_event _ANSI_ARGS_((TCHUNK *, unsigned char *, EVENT_TYPE *));
extern int put_smf_event _ANSI_ARGS_((TCHUNK *, unsigned char *, int));
extern int read_header_chunk _ANSI_ARGS_((int, HCHUNK *));
extern int read_track_chunk _ANSI_ARGS_((int, TCHUNK *));
extern int skip_track_chunk _ANSI_ARGS_((int));
extern void rewind_track _ANSI_ARGS_((TCHUNK *));
extern void reset_track _ANSI_ARGS_((TCHUNK *));
extern int write_header_chunk _ANSI_ARGS_((int, HCHUNK *));
extern int write_track_chunk _ANSI_ARGS_((int, TCHUNK *));
extern int merge_tracks _ANSI_ARGS_((TCHUNK *, TCHUNK **, int *, int, int));
extern int split_type_zero _ANSI_ARGS_((TCHUNK *));
extern int fix2var _ANSI_ARGS_((long, unsigned char *));
extern long var2fix _ANSI_ARGS_((unsigned char *, int *));
extern void free_track _ANSI_ARGS_((TCHUNK *));
extern void init_track _ANSI_ARGS_((TCHUNK *));
extern int mread _ANSI_ARGS_((int, char *, int));
extern int mwrite _ANSI_ARGS_((int, char *, int));
extern int more_memory _ANSI_ARGS_((char **, int));
#endif
