/* 
 * Copyright 1987-1991 Regents of the University of California
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */
/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* Program: tclmain.c
 *      This file contains a test program that uses the tclipc library.
 *
 * Created: K. Gillies 26 June 1992
 *
 * SCCS INFO
 *      %W% %G%
 */
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "tcl.h"
#include "tclipc.h"

#define TRUE 1
#define FALSE 0

/* Something I use to reduce length of arg lists */
typedef struct _tclInfo {
  Tcl_Interp *interp;
  Tcl_CmdBuf buffer;
} tclinfo, *tclInfo;
static tclInfo info;

/* Used to keep track of multiple senders */
#define MAXNUMSENDERS 20
typedef struct _ipcSenderInfo {
  char *handleName;
  char *program;
  Sender sender;
} ipcSenderInfo;
static ipcSenderInfo senders[MAXNUMSENDERS];

/* In file function prototypes */
static int cmdQuit _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
		int argc, char *argv[]));
static int cmdBeep _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
		int argc, char *argv[]));
static tclInfo tclInit _ANSI_ARGS_ ((void));
static evalcmd_res* tclTestCmdReceive _ANSI_ARGS_ ((Tcl_Interp *interp, 
                            cmdText cmd));

#define MYBUFSIZ        64
#if defined(__STDC__)
static volatile int quitFlag = FALSE;
#else
static int quitFlag = FALSE;
#endif

char *initCmd =
 "if [file exists [info library]/init.tcl] {source [info library]/init.tcl}";

/*
 *--------------------------------------------------------------
 *
 * xvipcInit
 *
 *      A special initialization for the test program.
 *
 * Results:
 *      TCL_ERROR or TCL_OK
 *--------------------------------------------------------------
 */
int xvipcInit(appName)
char *appName;
{
  Receiver result;
  int i;

  /* Init the interpreter */
  info = tclInit();
  /* Special listener, nothing else */
  ipcSendInit(0, 0, 0, 0, tclTestCmdReceive, NULL, NULL, NULL);
  /* Add the tclIPC commands */
  ipcInterpInit(info->interp);

  /* Create a default receiver for the test program */
  result = ipcNewReceiver(info->interp, appName, "localhost");

  /* Init the sender storage hack */
  for (i=0; i<MAXNUMSENDERS; i++) {
    senders[i].handleName = NULL;
    senders[i].program = NULL;
    senders[i].sender = (Sender)NULL;
  }
  return (result == NULL) ? TCL_ERROR : TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * xvipcAddSender
 *
 *      Create a new sender callback and store the information 
 *
 * Results:
 *
 *--------------------------------------------------------------
 */
int xvipcAddSender(index, senderName)
int index;
char *senderName;
{
  Sender newSender;

  if (index >= MAXNUMSENDERS) {
    fprintf(stderr, "Too many senders!\n");
    return -1;
  }
  newSender = ipcNewSender (info->interp, 
			    senderName,
			    ANYHOST, LOCALHOST); 
  assert (newSender != (Sender)NULL);
 
  senders[index].program = strdup(senderName);
  senders[index].handleName = strdup(info->interp->result);
  senders[index].sender = newSender;

  return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * xvipcSend
 *
 *      Send a command callback
 *
 * Results:
 *      Returns the response string
 *--------------------------------------------------------------
 */
char *xvipcSend(index, command)
int index;
char *command;
{
  Sender sender;

  sender = senders[index].sender;
  if (sender == NULL) {
    return "Out of range sender value.\n";
  }
  return (ipcRemoteSend(sender, "%s", command) == TCL_OK) ?
          info->interp->result : "Message send failed!\n";
}

/*
 *--------------------------------------------------------------
 *
 * xvipcQuit
 *
 *      Quit demo program fairly gracefully
 *
 * Results:
 *      Returns the response string
 *--------------------------------------------------------------
 */
void xvipcQuit() 
{
  ipcDestroyAll(info->interp);
 
  Tcl_DeleteInterp(info->interp);
  Tcl_DeleteCmdBuf(info->buffer);
  exit(0);
}

/*
 *--------------------------------------------------------------
 *
 * tclTestCmdReceive
 *
 *      Test cmd listener.
 *
 * Results:
 *
 *--------------------------------------------------------------
 */
static evalcmd_res* tclTestCmdReceive(interp, argp)
Tcl_Interp *interp;
cmdText argp;
{
  static evalcmd_res answer = { 0, NULL };
  extern void xviewShowString(char*, char*);

  /* Only free after the first time */
  if (answer.text != NULL) {
    free((char *)answer.text);
  }
  printf(">>Test\n");
  answer.errno = Tcl_Eval(interp, argp, 0, NULL);
  answer.text = interp->result;
  xviewShowString(argp, answer.text);
  return(&answer);
}

static tclInfo tclInit()
{
  int result;
  tclInfo info;

  info = (tclInfo)malloc(sizeof(tclinfo));
  assert(info != NULL);

  info->interp = Tcl_CreateInterp();

  /* Some standard tcl built-ins */
  Tcl_CreateCommand(info->interp, "quit", (Tcl_CmdProc *)cmdQuit,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(info->interp, "beep", (Tcl_CmdProc *)cmdBeep,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);

  info->buffer = Tcl_CreateCmdBuf();

  /* Source the tcl library */
  result = Tcl_Eval(info->interp, initCmd, 0, (char **) NULL);
  assert(result == TCL_OK);

  return info;
}

/* A formal quit command */
static int cmdQuit(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp; 
int argc;
char *argv[];
{
  quitFlag = 1;
  return TCL_OK;
}

/* A beep command */
static int cmdBeep(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
/*  extern void FakeButtonPress(char *name); */

/*  FakeButtonPress("Test"); */
  Tcl_AppendResult(interp, "OK", (char *)NULL);
  return TCL_OK;
}
