/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* File: plist.h
 *      This is public interface to the PortManager list structure.
 * Created: K. Gillies 26 June 1992
 *
 * SCCS INFO
 *      @(#)plist.h	1.1 9/11/92
 */
#ifndef _plist_h
#define _plist_h

#ifndef _TCL
#include "tcl.h"                 /* Get ANSI_ARGS */
#endif
#ifndef collection_h
#include "collection.h"
#endif

/* Make a type for the portList */
typedef Collection PortManList;

void pListInit _ANSI_ARGS_((PortManList *));

void pListPrint _ANSI_ARGS_((PortManList));

void pListAddPortToList _ANSI_ARGS_((PortManList, Port *));

void pListRemovePortFromList _ANSI_ARGS_((PortManList , Port *));

void pListScanForDeadApps _ANSI_ARGS_((PortManList));

Port *pListPortInList _ANSI_ARGS_((PortManList ports_inuse, 
				   char *name, 
				   char *host, 
				   int port));

#endif
