#!/usr/local/bin/wish -f
# XF
# create the widget hierarchy
#

# module inclusion

# initialize global variables
proc InitGlobals {} {
  global smenu
  set smenu {.frame7.menubutton1.m}
  global sendername
  set sendername {sender name}
  global recname
  set recname {receiver:}
  global receivername
  set receivername {none}
  global symbolicName
  set {symbolicName(senders)} {.frame7.menubutton1}
  set {symbolicName(item1)} {.frame7.menubutton1.m}
  set {symbolicName(root)} {.}
  set {symbolicName(outbox)} {.frame3.message6}
  set {symbolicName(sendbutton)} {.frame1.button5}
  global moduleList
  set {moduleList(main.tcl)} {}
  global currentsender
  set currentsender {none}
}

# contents of .
proc ShowWindow. {} {

  # Window manager configurations
  wm title . {Tk IPC Demo}
  wm geometry . 402x347+673+267
  wm positionfrom . user
  wm sizefrom . user
  wm maxsize . 1152 628
  wm minsize . 402 347

  # build widget .frame4
  frame .frame4
  .frame4 configure \
    -background {#40a0c0}\
    -borderwidth {2}\
    -geometry {30x37}

  # build widget .frame4.button8
  button .frame4.button8
  .frame4.button8 configure \
    -activebackground {#40a0c0}\
    -background {#40a0c0}\
    -command {createsender}\
    -font {lucidasans-12}\
    -padx {2}\
    -pady {1}\
    -text {create}

  # build widget .frame4.entry7
  entry .frame4.entry7
  .frame4.entry7 configure \
    -background {#40a0c0}\
    -borderwidth {1}\
    -exportselection {false}\
    -font {lucidasans-12}\
    -relief {sunken}\
    -scrollcommand {NoFunction}\
    -width {15}
  # bindings
  bind .frame4.entry7 <Return> {createsender} 
  bind .frame4.entry7 <Any-Key> {%W insert cursor "%A"; EntryV2C %W} 
  bind .frame4.entry7 <space> {%W insert cursor " "; EntryV2C %W} 
  bind .frame4.entry7 <Control-v> {%W insert cursor "[GetSelection]"} 
  bind .frame4.entry7 <Control-l> {EntryV2C %W} 
  bind .frame4.entry7 <Control-k> {%W delete cursor end; EntryV2C %W} 
  bind .frame4.entry7 <Control-Mod1-h> {%W delete 0 cursor; %W view cursor} 
  bind .frame4.entry7 <Control-h> {EntryBS %W} 
  bind .frame4.entry7 <Control-f> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W} 
  bind .frame4.entry7 <Control-e> {%W cursor end; EntryV2C %W} 
  bind .frame4.entry7 <Control-Mod1-d> {%W delete sel.first sel.last; EntryV2C %W} 
  bind .frame4.entry7 <Control-d> {%W delete cursor; EntryV2C %W} 
  bind .frame4.entry7 <Control-b> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W} 
  bind .frame4.entry7 <Control-a> {%W cursor 0; %W view 0} 
  bind .frame4.entry7 <Left> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W } 
  bind .frame4.entry7 <Right> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W } 
  bind .frame4.entry7 <BackSpace> {EntryBS %W} 
  bind .frame4.entry7 <Delete> {EntryBS %W} 


  .frame4.entry7 insert end {kim1}

  # build widget .frame4.label6
  label .frame4.label6
  .frame4.label6 configure \
    -anchor {e}\
    -background {#40a0c0}\
    -borderwidth {0}\
    -font {lucidasans-bold-12}\
    -padx {2}\
    -pady {1}\
    -text {new sender:}

  # pack widget .frame4
  pack append .frame4\
    .frame4.label6   {left frame center} \
    .frame4.entry7   {left frame center} \
    .frame4.button8   {top frame center} 


  # build widget .frame3
  frame .frame3
  .frame3 configure \
    -background {#40a0c0}\
    -borderwidth {2}\
    -geometry {30x150}

  # build widget .frame3.message6
  message .frame3.message6
  .frame3.message6 configure \
    -aspect {183}\
    -background {white}\
    -font {fixed}\
    -justify {left}\
    -padx {5}\
    -pady {2}\
    -relief {sunken}\
    -text {text output}

  # pack widget .frame3
  pack append .frame3\
    .frame3.message6   {top frame nw expand fill} 


  # build widget .frame1
  frame .frame1
  .frame1 configure \
    -background {#40a0c0}\
    -borderwidth {3}\
    -geometry {18x46}

  # build widget .frame1.label3
  label .frame1.label3
  .frame1.label3 configure \
    -anchor {e}\
    -background {#40a0c0}\
    -font {lucidasans-bold-12}\
    -padx {2}\
    -pady {1}\
    -text {command:}

  # build widget .frame1.entry4
  entry .frame1.entry4
  .frame1.entry4 configure \
    -background {#40a0c0}\
    -borderwidth {1}\
    -exportselection {false}\
    -font {lucidasans-12}\
    -relief {sunken}\
    -scrollcommand {NoFunction}\
    -width {22}
  # bindings
  bind .frame1.entry4 <Return> {doSend} 
  bind .frame1.entry4 <Delete> {EntryBS %W} 
  bind .frame1.entry4 <BackSpace> {EntryBS %W} 
  bind .frame1.entry4 <Right> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W } 
  bind .frame1.entry4 <Left> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W } 
  bind .frame1.entry4 <Control-a> {%W cursor 0; %W view 0} 
  bind .frame1.entry4 <Control-b> {%W cursor [expr [%W index cursor]-1]; EntryV2C %W} 
  bind .frame1.entry4 <Control-d> {%W delete cursor; EntryV2C %W} 
  bind .frame1.entry4 <Control-Mod1-d> {%W delete sel.first sel.last; EntryV2C %W} 
  bind .frame1.entry4 <Control-e> {%W cursor end; EntryV2C %W} 
  bind .frame1.entry4 <Control-f> {%W cursor [expr [%W index cursor]+1]; EntryV2C %W} 
  bind .frame1.entry4 <Control-h> {EntryBS %W} 
  bind .frame1.entry4 <Control-Mod1-h> {%W delete 0 cursor; %W view cursor} 
  bind .frame1.entry4 <Control-k> {%W delete cursor end; EntryV2C %W} 
  bind .frame1.entry4 <Control-l> {EntryV2C %W} 
  bind .frame1.entry4 <Control-v> {%W insert cursor "[GetSelection]"} 
  bind .frame1.entry4 <space> {%W insert cursor " "; EntryV2C %W} 
  bind .frame1.entry4 <Any-Key> {%W insert cursor "%A"; EntryV2C %W} 


  .frame1.entry4 insert end {new command}

  # build widget .frame1.button5
  button .frame1.button5
  .frame1.button5 configure \
    -activebackground {#40a0c0}\
    -background {#40a0c0}\
    -command {doSend}\
    -font {lucidasans-12}\
    -padx {2}\
    -pady {2}\
    -text {send}

  # pack widget .frame1
  pack append .frame1\
    .frame1.label3   {left frame center} \
    .frame1.entry4   {left frame center} \
    .frame1.button5   {right frame e} 


  # build widget .frame7
  frame .frame7
  .frame7 configure \
    -background {#40a0c0}\
    -borderwidth {2}\
    -geometry {60x37}

  # build widget .frame7.label0
  label .frame7.label0
  .frame7.label0 configure \
    -background {#40a0c0}\
    -font {lucidasans-bold-12}\
    -padx {2}\
    -pady {1}\
    -text {sender name:}

  # build widget .frame7.menubutton1
  menubutton .frame7.menubutton1
  .frame7.menubutton1 configure \
    -activebackground {#40a0c0}\
    -background {#40a0c0}\
    -font {lucidasans-12}\
    -menu {.frame7.menubutton1.m}\
    -relief {raised}\
    -text {none}\
    -textvariable {currentsender}

  # build widget .frame7.menubutton1.m
  menu .frame7.menubutton1.m
  .frame7.menubutton1.m configure \
    -activebackground {#40a0c0}\
    -background {#40a0c0}\
    -font {lucidasans-12}

  # pack widget .frame7
  pack append .frame7\
    .frame7.label0   {left frame e} \
    .frame7.menubutton1   {left frame w padx 19} 


  # build widget .frame0
  frame .frame0
  .frame0 configure \
    -background {#40a0c0}\
    -borderwidth {2}\
    -geometry {30x30}

  # build widget .frame0.message1
  message .frame0.message1
  .frame0.message1 configure \
    -aspect {1500}\
    -background {#40a0c0}\
    -font {lucidasans-bold-12}\
    -justify {right}\
    -padx {5}\
    -pady {2}\
    -text {receiver:}

  # build widget .frame0.label2
  label .frame0.label2
  .frame0.label2 configure \
    -anchor {w}\
    -background {#40a0c0}\
    -font {lucidasans-12}\
    -padx {2}\
    -pady {1}\
    -text {none}\
    -textvariable {receivername}

  # pack widget .frame0
  pack append .frame0\
    .frame0.message1   {left frame w fillx} \
    .frame0.label2   {left frame w} 

  # bindings
  bind . <Button-3> {.menu0 post %X %Y} 
  bind . <ButtonRelease-3> {.menu0 invoke active; .menu0 unpost} 
  bind . <B3-Motion> {MenuPopupHandle .menu0 %W %X %Y} 


  # pack widget .
  pack append .\
    .frame0   {top frame w fillx} \
    .frame7   {top frame center fillx} \
    .frame4   {top frame center fillx} \
    .frame1   {top frame n fillx} \
    .frame3   {top frame center expand fill} 

  if {[string length [info commands .XFEdit]] > 0} {
    XFEditSetShowWindows
    XFSmlMiscBindWidgetTree .frame0
  }
}


# Procedures


if {[string length [info procs MenuPopupAdd]] == 0} {
proc MenuPopupAdd { xfW xfButton xfMenu} {
  if {[catch "bind $xfW \"<ButtonPress-$xfButton>\"                 \"$xfMenu post %X %Y\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
  # we need these to counteract the effects of passive grabs :-(
  if {[catch "bind $xfW \"<ButtonRelease-$xfButton>\"                 \"$xfMenu invoke active; $xfMenu unpost\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
  if {[catch "bind $xfW \"<B$xfButton-Motion>\"                 \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult] != 0} {
    XFError "Could not bind popup menu to widget.\nI got:\n$xfResult"
    return
  }
}
}


if {[string length [info procs EntryBS]] == 0} {
proc EntryBS { xfW} {
  set xfX [expr {[$xfW index cursor]-1}]

  if {$xfX != -1} {
    $xfW delete $xfX
  }
  EntryV2C $xfW
}
}


if {[string length [info procs EntryV2C]] == 0} {
proc EntryV2C { xfW} {
  set xfLeftExtent [$xfW index @0]
  set xfRightExtent [$xfW index @[winfo width $xfW]]
  set xfCursorPos [$xfW index cursor]
  set xfEntryLen [expr "$xfRightExtent-$xfLeftExtent"]

  if {$xfCursorPos > $xfLeftExtent} {
    if {$xfCursorPos > $xfRightExtent} {
      #handle cursor too far to the right
      $xfW view [expr "$xfCursorPos-$xfEntryLen+1"]
    }
  } { 
    #handle cursor too far to the left
    $xfW view [expr "$xfCursorPos-1"]
  }
}
}


if {[string length [info procs SymbolicName]] == 0} {
proc SymbolicName { {xfName ""}} {
  global symbolicName

  if {[string length $xfName] > 0} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {[catch "set \"$xfArrayName\"" xfValue] == 0} {
      return $xfValue
    } {
      XFError "Unknown symbolic name:\n$xfName"
    }
  }
  return ""
}
}

proc ipcDemoInit {} {
  global smenu 

  setsender "none"
  $smenu delete 0
}

proc tkerror { err} {
#    global errorInfo
#    puts stdout "$errorInfo"
}


if {[string length [info procs NoFunction]] == 0} {
proc NoFunction { args} {

}
}

proc setsender { sendername} {
  global currentsender

  set currentsender $sendername
}


if {[string length [info procs MenuPopupHandle]] == 0} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {
 if {[winfo ismapped $xfMenu]} {
   set xfPopMinX [winfo rootx $xfMenu]
   set xfPopMaxX [expr "$xfPopMinX + [winfo width $xfMenu]"]
   if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
     $xfMenu activate @[expr "$xfY - [winfo rooty $xfMenu]"]
   } {
     $xfMenu activate none}
   }
}
}


if {[string length [info procs GetSelection]] == 0} {
proc GetSelection {} {
  set xfSelection ""
  catch "selection get" xfSelection
  return $xfSelection
}
}

proc ipcError { errormsg} {
  .frame3.message6 configure -text $errormsg
}

proc createsender {} {
  set sendername [.frame4.entry7 get]
  if { [catch {set newhandle [sender new $sendername]} error] != 0} {
    ipcError $error
    return
  }
  $smenu add command -label $sendername -command "setsender $sendername"
  setsender $sendername
}


# initialize global variables
# remove this call if there are problems at startup
InitGlobals


# stuff to display and remove toplevel windows
# call the procedures to create the toplevels.
ShowWindow.

source demo.tcl

# eof
#
