extern "C" {
#include "tcl.h"
#include <string.h>
#include <stdio.h>
#include <malloc.h>
}
#include "Tcl_Object.h"

// tcltest.C: 
// Example class for interfacing funtionality of C++ with a 
// user interface from tcl-tk
//

// First some plain-C functions need to be declared, which will
// embed my C++ member functions:
extern Tcl_CmdProc c_defaults, c_clear, c_print, c_create, c_close;

static int num_windows = 0;

//
// 
class Tcltest : public Tcl_Object {

private:
// this examle contains two visible attributes:
	int   an_int;
	char *a_string;
// and one attribute the is linked to the tcl-Var "sibling_list":
	char *sibling_list;


protected:
	char * get_window_name(){
		char buf [40];
		sprintf(buf, "test window #%d\0", ++num_windows);
		return(strdup(buf));
	};

public:
	Tcltest (){
		init_interp();
		set_mode(NON_MODAL);
		sibling_list = NULL;
		clear();
   		CreateCommand ("c_defaults", c_defaults);
   		CreateCommand ("c_clear", c_clear);
   		CreateCommand ("c_print", c_print);
   		CreateCommand ("c_create", c_create);
   		CreateCommand ("c_close", c_close);
		Tcl_LinkVar(interp, "sibling_list", 
			    (char *)&sibling_list, TCL_LINK_STRING);
	};

virtual	~Tcltest (){};

// Now we specify the file where the interpreter will find
// its script:
	char *get_filename(){
		return("./tcltest.tcl");
	};
		
// The following member functions can be called from tcl:
	void defaults (){
		an_int = 314;
		a_string="This is a string\0";
		to_tcl();
	};
	
	void clear (){
		an_int = 0;
		a_string="\0";
		to_tcl();
	};
	
	void print (){
		to_cpp();
		printf ("Tcl_Object '%s' has values:\n\
an_int = %d and a_string = '%s'.\n", 
		window_name, an_int, a_string);
	};

	void create (){
		Tcltest *sibling;
		char *buf;
		int buf_size;

		sibling = new Tcltest();
	        buf_size = strlen(sibling->window_name)+ 3+ 
			   (sibling_list ? strlen(sibling_list):0);
		buf = (char *)malloc(buf_size);
		if (sibling_list != NULL) {
		    sprintf (buf, "%s %c%s%c", 
				sibling_list, 34, sibling->window_name, 34);
		} else {
		    sprintf (buf, "%c%s%c", 34, sibling->window_name, 34);
		}
		sibling_list=buf;

		if (argc>1){
			if      (!strcmp(argv[1],"non_modal"))
				sibling->set_mode(NON_MODAL);
			else if (!strcmp(argv[1],"waiting"))
				sibling->set_mode(WAITING);
			else if (!strcmp(argv[1],"modal"))
				sibling->set_mode(MODAL);
		} else {
			sibling->set_mode(mode);
		};
		sibling->execute();
		printf("execute of %s returned to %s\n", 
			sibling->window_name, window_name);
	}

// Two functions manage the data transfer C++ <--> tcl:

	void to_tcl() {
		Tcl_SetIntVar("an_int", an_int);
		Tcl_SetStrVar("a_string", a_string);
	};

	void to_cpp() {
		an_int  = Tcl_GetIntVar("an_int");
		a_string = Tcl_GetStrVar("a_string");
	};
		
};

// These macro calls actually define the plain-C embedding:
// CAUTION: whitespace between the parentheses can cause errors!

_CMD_Embedding(Tcltest,c_defaults,defaults);
_CMD_Embedding(Tcltest,c_clear,clear);
_CMD_Embedding(Tcltest,c_print,print);
_CMD_Embedding(Tcltest,c_create,create);
_CMD_Embedding(Tcltest,c_close,close);

/*
 *----------------------------------------------------------------------
 *
 * main -- 
 *
 *----------------------------------------------------------------------
 */

int
main(int argc, char *argv[])
{
    Tcltest *testobj;

// chain args to the tcl interpreter (this really seems to be necessary
// although I'm not quite sure why:

    set_gargs(argc, argv);

// I guess this is what a main() is supposed to do:
    testobj = new Tcltest();
    testobj->execute();

    return(0);
}
