#************************************************************************
#*									*
#*	Copyright 1993 by Motorola Mobile Data Division,		*
#*			  Bothell, WA					*
#*	All rights reserved.						*
#*									*
#************************************************************************
#
append RCSid {$Header: /sea/ntu/tools/src/bin/tcl/SVipc/tests/RCS/shm.tcl,v 1.1 1993/04/09 02:03:04 kelsey Exp $} "\n"
#
# File: 
# Facility: 
# Description:
#
#

close [open /tmp/IPC-test w]
set key [ftok /tmp/IPC-test %]
set shmid [shmget $key 1024 create]
set ipcs [exec ipcs -ma]
shmstat $shmid shm_data
set shmok 0
for {set i 30} {$i < [llength $ipcs]} {incr i 15} {
  if [lindex $ipcs $i]==$shmid {
    if [lindex $ipcs [expr $i+1]]!=$key {
      puts stderr "Shared memory segment id doesn't match key."
    }
    set shmok 1
  }
}
if !$shmok {puts stderr "Shared memory segment not found in system!"}
set shmaddr [shmat $shmid]
setlong $shmaddr 1
setshort [expr $shmaddr+4] 2
setchar [expr $shmaddr+6] 3
setstr [expr $shmaddr+7] {Hello, world}
getlong $shmaddr 1 long
if $long!=1 {puts stderr "Get/set long error."}
getshort [expr $shmaddr+4] 1 short
if $short!=2 {puts stderr "Get/set short error."}
getchar [expr $shmaddr+6] 1 char
if $char!=3 {puts stderr "Get/set char error."}
getstr [expr $shmaddr+7] str
if [string compare $str {Hello, world}] {puts stderr "Get/set str error."}
shmdt $shmaddr
shmrmid $shmid
