/************************************************************************
 *									*
 *	Copyright 1992 by Motorola Mobile Data Division,		*
 *			  Bothell, WA					*
 *									*
 *	Motorola hereby grants permission to use, copy, modify and	*
 *	distribute  this software and its documentation for any		*
 *	purpose and without fee, provided that you retain this		*
 *	copyright notice in all copies.  Motorola makes no		*
 *	representations about the suitability of this software for any	*
 *	purpose.  Motorola provides this software ``as is'' without	*
 *	express or implied warranty.					*
 *									*
 ************************************************************************/
#ifndef lint
static char RCSid[] = "$Header: /sea/ntu/tools/src/bin/tcl/SVipc/RCS/svipcInit.c,v 1.6 1993/11/13 00:35:34 kelsey Exp $";
#endif /* lint */

/*
 * File: SVipc/svipcInit.c
 * Facility: Tcl C Routines
 * Author: Joe Kelsey
 * Description:
 *	System V IPC services for TCL.
 *
 * Global Functions:
 *	Svipc_FtokCmd
 *	Svipc_Init
 *
 * $Log: svipcInit.c,v $
 * Revision 1.6  1993/11/13  00:35:34  kelsey
 * Compose svipc_version from SVIPC_VERSION and SVIPC_PATCHLEVEL so that it
 * conforms to the distribution numbering (e.g., 2.1.0.)
 *
 * Revision 1.5  1993/10/01  23:04:20  kelsey
 * Add version and patchlevel variables.
 * Change link and unlink to linkvar and unlinkvar.
 *
 * Revision 1.4  1993/08/18  21:34:41  kelsey
 * Use Svipc_ prefix instead of Tcl_.
 * Define SVIPC_VERSION variable.
 * Add link and unlink commands.
 *
 * Revision 1.3  1993/04/08  21:34:07  kelsey
 * Remove shm prefix from get and set commands.
 *
 * Revision 1.2  1993/04/02  22:16:45  kelsey
 * Change copyright notice.
 * Add message queue functions.
 * Remove unused semaphore funcitons.
 *
 * Revision 1.1  1992/06/02  14:09:34  kelsey
 * Initial revision
 *
 */

#include <sys/types.h>
#include <sys/ipc.h>

#include <stdio.h>

#include <tcl.h>
#include "svipc.h"
#include "patchlevel.h"

/* In svicLink.c  */
extern Tcl_CmdProc Svipc_LinkCmd;
extern Tcl_CmdProc Svipc_UnlinkCmd;

/* In svipcInit.c  */
extern Tcl_CmdProc Svipc_FtokCmd;

/* In svipcMsg.c  */
extern Tcl_CmdProc Svipc_MsggetCmd;
extern Tcl_CmdProc Svipc_MsgrcvCmd;
extern Tcl_CmdProc Svipc_MsgrmidCmd;
extern Tcl_CmdProc Svipc_MsgsetCmd;
extern Tcl_CmdProc Svipc_MsgsndCmd;
extern Tcl_CmdProc Svipc_MsgstatCmd;

/* In svipcSem.c  */
extern Tcl_CmdProc Svipc_SemgetCmd;
extern Tcl_CmdProc Svipc_SemopCmd;
extern Tcl_CmdProc Svipc_SemrmidCmd;
extern Tcl_CmdProc Svipc_SemsetCmd;
extern Tcl_CmdProc Svipc_SemstatCmd;
extern Tcl_CmdProc Svipc_SemvalCmd;

/* In svipcShm.c  */
extern Tcl_CmdProc Svipc_ShmatCmd;
extern Tcl_CmdProc Svipc_ShmdtCmd;
extern Tcl_CmdProc Svipc_ShmgetCmd;
extern Tcl_CmdProc Svipc_ShmgetcharCmd;
extern Tcl_CmdProc Svipc_ShmgetlongCmd;
extern Tcl_CmdProc Svipc_ShmreadCmd;
extern Tcl_CmdProc Svipc_ShmgetshortCmd;
extern Tcl_CmdProc Svipc_ShmgetstrCmd;
extern Tcl_CmdProc Svipc_ShmgetstrnCmd;
extern Tcl_CmdProc Svipc_ShmrmidCmd;
extern Tcl_CmdProc Svipc_ShmsetCmd;
extern Tcl_CmdProc Svipc_ShmsetcharCmd;
extern Tcl_CmdProc Svipc_ShmsetlongCmd;
extern Tcl_CmdProc Svipc_ShmsetshortCmd;
extern Tcl_CmdProc Svipc_ShmsetstrCmd;
extern Tcl_CmdProc Svipc_ShmsetstrnCmd;
extern Tcl_CmdProc Svipc_ShmstatCmd;
extern Tcl_CmdProc Svipc_ShmwriteCmd;


/*
 * Function: Svipc_FtokCmd
 * Description:
 *	Tcl interface to ftok.
 *
 * Parameters:
 * Type		Name		Description
 * ----------------------------------------------------------------------
 * ClientData	clientData	Global command data (not used).
 * Tcl_Interp * interp		Tcl interpreter.
 * int		argc		Number of command arguments (3).
 * char **	argv		Vector of command arguments.
 *				[ ftok file id ]
 *
 * Return type: int
 * Side Effects:
 *	Sets interp->result.
 */
/* ARGSUSED */
int
Svipc_FtokCmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp *interp;
     int argc;
     char ** argv;

/* Detail Design:

 */

{
  key_t key;
  char rstr[20];

  if (argc != 3)
    {
      Tcl_AppendResult (interp, "usage: ", argv[0], " file id", (char *)0);
      return TCL_ERROR;
    }

  if ((key = ftok (argv[1], *argv[2])) == -1)
    {
      Tcl_AppendResult (interp, "cannot get IPC key for file \"", argv[1],
			"\" and key '", argv[2], "': ",
			Tcl_PosixError (interp), (char *)0);
      return TCL_ERROR;
    }

  (void) sprintf (interp->result, "%d", key);
  return TCL_OK;
}

/*
 * Function: Svipc_Init
 * Description:
 *	Initialize the System V IPC commands.
 *
 * Parameters:
 * Type		Name		Description
 * ----------------------------------------------------------------------
 * Tcl_Interp *	interp		Interpreter to add commands to.
 *
 * Return type: void
 * Side Effects:
 */

int
Svipc_Init (interp)
     Tcl_Interp * interp;

/* Detail Design:

 */

{
  char buffer[16];

  (void) sprintf (buffer, "%s.%d", SVIPC_VERSION, SVIPC_PATCHLEVEL);
  Tcl_SetVar (interp, "svipc_version", buffer, TCL_GLOBAL_ONLY);

  /* In svipcLink.c  */
  Tcl_CreateCommand (interp, "linkvar", Svipc_LinkCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "unlinkvar", Svipc_UnlinkCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);

  /* In svipcInit.c  */
  Tcl_CreateCommand (interp, "ftok", Svipc_FtokCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  
  /* In svipcMsg.c  */
  Tcl_CreateCommand (interp, "msgget", Svipc_MsggetCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "msgrcv", Svipc_MsgrcvCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "msgrmid", Svipc_MsgrmidCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "msgset", Svipc_MsgsetCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "msgsnd", Svipc_MsgsndCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "msgstat", Svipc_MsgstatCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);

  /* In svipcSem.c  */
  Tcl_CreateCommand (interp, "semget", Svipc_SemgetCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "semop", Svipc_SemopCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "semrmid", Svipc_SemrmidCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "semset", Svipc_SemsetCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "semstat", Svipc_SemstatCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "semval", Svipc_SemvalCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);

  /* In svipcShm.c  */
  Tcl_CreateCommand (interp, "shmat", Svipc_ShmatCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "shmdt", Svipc_ShmdtCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "shmget", Svipc_ShmgetCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "getchar", Svipc_ShmgetcharCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "getlong", Svipc_ShmgetlongCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "getshort", Svipc_ShmgetshortCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "getstr", Svipc_ShmgetstrCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "getstrn", Svipc_ShmgetstrnCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "shmread", Svipc_ShmreadCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "shmrmid", Svipc_ShmrmidCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "shmset", Svipc_ShmsetCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "setchar", Svipc_ShmsetcharCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "setlong", Svipc_ShmsetlongCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "setshort", Svipc_ShmsetshortCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "setstr", Svipc_ShmsetstrCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "setstrn", Svipc_ShmsetstrnCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "shmstat", Svipc_ShmstatCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);
  Tcl_CreateCommand (interp, "shmwrite", Svipc_ShmwriteCmd, (ClientData)0,
		     (Tcl_CmdDeleteProc *)0);

  return TCL_OK;
}
