/* ppm.h - header file for libppm portable pixmap library
*/

#ifndef _PPM_H_
#define _PPM_H_

#define RPPM_FORMAT ('P'*256+'6')
#define PPM_FORMAT ('P'*256+'3')
#define RPGM_FORMAT ('P'*256+'5')
#define PGM_FORMAT ('P'*256+'2')

typedef struct { 
   unsigned char r, g, b;
} pixel;

extern int readppminit _ANSI_ARGS_((FILE* file, 
				    int* colsP, 
				    int* rowsP, 
				    int* maxvalP, 
				    int* formatP));

extern int readppmrow _ANSI_ARGS_((FILE* file, 
				   pixel* pixelrow, 
				   int cols,
				   int maxval,
				   int format));

extern int writeppminit _ANSI_ARGS_((FILE* file, 
				    int cols, 
				    int rows, 
				    int maxval, 
				    int format));

extern int writeppmrow _ANSI_ARGS_((FILE* file, 
				    pixel* pixelrow, 
				    int cols,
				    int maxval,
				    int format));

#endif /*_PPM_H_*/




