/*
 * Tcl command to transfer the contents of one photo window to another.
 *
 * photocopy to from ?dest-x dest-y src-x src-y width height?
 *
 * Copyright 1993 The Australian National University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, provided that the above copyright
 * notice appears in all copies.  This software is provided without any
 * warranty, express or implied. The Australian National University
 * makes no representations about the suitability of this software for
 * any purpose.
 *
 * Author: Paul Mackerras (paulus@cs.anu.edu.au)
 *
 * $Header: /home/paulus/CaVis/othersrc/tk3.3/RCS/photocopy.c,v 1.3 1993/10/20 05:40:07 paulus Exp $
 */
#include "tcl.h"
#include "tkPhoto.h"

int
PhotoCopyCmd(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    PhotoHandle to, from;
    int destx, desty, srcx, srcy, bw, bh;
    PhotoImage block;

    if( argc < 3 || argc > 9 ){
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			 " to from ?dest-x dest-y src-x src-y width height\"",
			 (char *) NULL);
	return TCL_ERROR;
    }
    if( (to = FindPhoto(argv[1])) == NULL ){
	Tcl_AppendResult(interp, "unknown photo window \"", argv[1], "\"",
			 (char *) NULL);
	return TCL_ERROR;
    }
    if( (from = FindPhoto(argv[2])) == NULL ){
	Tcl_AppendResult(interp, "unknown photo window \"", argv[2], "\"",
			 (char *) NULL);
	return TCL_ERROR;
    }
    if( !PhotoGetImage(from, &block) ){
	Tcl_AppendResult(interp, "image data not available from photo \"",
			 argv[2], "\"", (char *) NULL);
	return TCL_ERROR;
    }

    destx = desty = 0;
    srcx = srcy = 0;
    if( argc > 3 && Tcl_GetInt(interp, argv[3], &destx) != TCL_OK
       || argc > 4 && Tcl_GetInt(interp, argv[4], &desty) != TCL_OK
       || argc > 5 && Tcl_GetInt(interp, argv[5], &srcx) != TCL_OK
       || argc > 6 && Tcl_GetInt(interp, argv[6], &srcy) != TCL_OK )
	return TCL_ERROR;

    bw = block.width - srcx;
    bh = block.height - srcy;
    if( argc > 7 && Tcl_GetInt(interp, argv[7], &bw) != TCL_OK
       || argc > 8 && Tcl_GetInt(interp, argv[8], &bh) != TCL_OK )
	return TCL_ERROR;

    if( srcx < 0 || bw < 0 || srcx + bw > block.width
       || srcy < 0 || bh < 0 || srcy + bh > block.height ){
	Tcl_AppendResult(interp, "source block is not contained within image",
			 (char *) NULL);
	return TCL_ERROR;
    }

    block.ptr += srcx * block.pixel_size + srcy * block.pitch;
    block.width = bw;
    block.height = bh;
    PhotoPutBlock(to, &block, destx, desty, bw, bh);

    return TCL_OK;
}

