# mkEntry2 -
#
# Create a top-level window that displays a bunch of entries with
# scrollbars.
#
# Arguments:
#    w -	Name to use for new top-level window.
#
# modified by k.furukawa, apr.1993. for 16bit kanji font

proc mkEntry2 {{w .e2}} {
    catch {destroy $w}
    toplevel $w
    dpos $w
    wm title $w "Entry Demonstration"
    wm iconname $w "Entries"
    message $w.msg -font k14 -aspect 200 \
	    -text "ˣĤΰۤʤ륨ȥ꤬СդɽƤޤݥȡåפʸ뤳ȤǤޤʸ򤷤ơȥݣĥ򲡤ȡõ뤳ȤǤޤХåڡǥ꡼ȥȥݣȥ֤ˤʸĤľäȥݣץ֤ˤñäȥݣեϥȥΤõޤĹ᤮ư٤ˤ٤ƤɽǤʤȥˤĤƤϡСȤꥹȥܥåޥܥ󣲤ǥɥå뤳ȤˤäĴ٤뤳ȤǤޤʬƣϣˡǥܥ򥯥åƲ"

    frame $w.frame -borderwidth 10
    pack append $w.frame \
	[entry $w.frame.e1 -relief sunken] {top fillx} \
	[scrollbar $w.frame.s1 -relief sunken -orient horiz -command \
	    "$w.frame.e1 view"] {top fillx} \
	[frame $w.frame.f1 -geometry 20x10] {top} \
	[entry $w.frame.e2 -relief sunken] {top fillx} \
	[scrollbar $w.frame.s2 -relief sunken -orient horiz -command \
	    "$w.frame.e2 view"] {top fillx} \
	[frame $w.frame.f2 -geometry 20x10] {top} \
	[entry $w.frame.e3 -relief sunken] {top fillx} \
	[scrollbar $w.frame.s3 -relief sunken -orient horiz -command \
	    "$w.frame.e3 view"] {top fillx}
    $w.frame.e1 config -scroll "$w.frame.s1 set" -font k14
    $w.frame.e1 insert 0 "ǽʸ"
    $w.frame.e2 config -scroll "$w.frame.s2 set" -font k14
    $w.frame.e2 insert end "ΥȥˤĹʸäƤơ"
    $w.frame.e2 insert end "٤˥ɥɽǤʤۤĹ"
    $w.frame.e2 insert end "ºݺǸޤǸ뤿ˤϥ󤫥"
    $w.frame.e2 insert end "ɬפޤ"
    $w.frame.e3 config -scroll "$w.frame.s3 set" -font k14

    button $w.ok -text OK -command "destroy $w"
    pack append $w $w.msg {top fill} $w.frame {top expand fill} \
	$w.ok {bottom fill}
}
