###############################################################################
#
# Oratcl-2.0
# Makefile for Oratcl with standard Tcl
#
# Tom Poindexter 

###############################################################################
#
# set the following defines as needed: 
#

#------------------------------------------------------------------------------
# define where Tcl source and libraries are located, relative to oratcl

TCL_DIR=../tcl7.3

#------------------------------------------------------------------------------
# define where Tk source and libraries are located, relative to oratcl

TK_DIR=../tk3.6

#------------------------------------------------------------------------------
# define name for Oratcl tcl executable, could be "otclsh", "oratclsh", etc.
# I just use standard Tcl's "tclsh"

TCL_EXEC=tclsh

#------------------------------------------------------------------------------
# define name for Oratcl wish executable, could be "owish", "orawish", etc.
# I just use standard Tcl's "wish"

WISH_EXEC=wish

#------------------------------------------------------------------------------
# include compile and link flags gleaned from Tcl and Tk Makefiles
# tclflags.mk is created by the target "get-tcl-flags:" (see below)
# the following flags should be set in tclflags.mk:
#
# from Tcl's Makefile:
# MATH_LIBS		# math libs needed to link tclsh
# AC_FLAGS		# compile time flags, for tcl.h, tclUnix.h
# PROTO_FLAGS		# use ansi function prototypes or not
# MEM_DEBUG_FLAGS	# use memory debug (ckalloc/ckfree)
# CFLAGS		# other cc flags, e.g. -O or -g
#
# and from Tk's Makefile
# X11_INCLUDES		# where X11 includes are, if not /usr/include
# X11_LIB_SWITCHES	# what X11 libs and associated network libs, if any
# LIBS			# all libs needed to link wish

# Tk's Makefile uses TCL_BIN_DIR to find libtcl.a, use our TCL_DIR
TCL_BIN_DIR=$(TCL_DIR)

include tclflags.mk


#------------------------------------------------------------------------------
# define where Oracle libraries are located

ORA=/u/oracle/rdbms/lib
#ORA=/usr/oracle/lib

# uncomment one set of the next two defines!

# use next two lines for version 6
#ORAVER=VERSION6
#OCILIB=$(ORA)/libocic.a $(ORA)/osntab.o $(ORA)/libsqlnet.a $(ORA)/libora.a

# use next two lines for version 7
#ORAVER=VERSION7
#OCILIB=$(ORA)/libocic.a $(ORA)/osntab.o $(ORA)/libsqlnet.a $(ORA)/libora.a \
#   $(ORA)/libcore.a $(ORA)/libnlsrtl.a $(ORA)/libcv6.a $(ORA)/libnetwork.a


#------------------------------------------------------------------------------
# where to copy the final executable and man page, probably the same
# place that Tcl put it's files and name the man page

BIN_DIR=/usr/local/bin
MAN_DIR=/usr/local/man/mann
MAN_PAGE=oratcl.n

#------------------------------------------------------------------------------
# define ranlib command for systems that need it; touch otherwise

RANLIB=ranlib
#RANLIB=touch

#------------------------------------------------------------------------------
# how to install

INSTALL=cp
#INSTALL=install -c
#INSTALL=ln -s

#
# end of defines
#
###############################################################################


# define all the compile flags
TCL_CFLAGS=$(AC_FLAGS) $(GENERIC_FLAGS) $(PROTO_FLAGS) $(MEM_DEBUG_FLAGS) \
	   $(CFLAGS)

all:	$(TCL_EXEC) $(WISH_EXEC) $(MAN_PAGE)

tclAppInit.c:	$(TCL_DIR)/tclAppInit.c
	sed -f orainit.sed <$(TCL_DIR)/tclAppInit.c >tclAppInit.c

tkAppInit.c:	$(TK_DIR)/tkAppInit.c
	sed -f orainit.sed <$(TK_DIR)/tkAppInit.c >tkAppInit.c

tclAppInit.o:	tclAppInit.c
	cc -c -I$(TCL_DIR) $(TCL_CFLAGS) tclAppInit.c

tkAppInit.o:	tkAppInit.c
	cc -c -I$(TK_DIR) -I$(TCL_DIR) $(X11_INCLUDES) $(TCL_CFLAGS) tkAppInit.c

oratcl.o:	oratcl.c libOratcl.a
	cc -c -I$(TCL_DIR) -D$(ORAVER) $(TCL_CFLAGS) oratcl.c
	ar cr libOratcl.a oratcl.o
	-$(RANLIB) libOratcl.a
	touch oratcl.o

libOratcl.a:	$(OCILIB)
	-mkdir libtmp
	-cd libtmp; rm -f *.o *.a
	cp $(OCILIB) libtmp
	cd libtmp; for L in lib*.a ; do ar x $$L; done
	cd libtmp; rm -f *.a
	cd libtmp; ar cr ../libOratcl.a [a-n]*.o
	cd libtmp; rm -f [a-n]*.o
	cd libtmp; ar cr ../libOratcl.a *.o
	-cd libtmp; rm -f *.o *.a

$(TCL_EXEC):	libOratcl.a oratcl.o tclAppInit.o
	cc tclAppInit.o -L$(TCL_DIR) \
	   -ltcl libOratcl.a $(MATH_LIBS) -o $(TCL_EXEC)

$(WISH_EXEC):	libOratcl.a oratcl.o tkAppInit.o
	cc tkAppInit.o -L$(TCL_DIR) -L$(TK_DIR) \
	   -ltk -ltcl libOratcl.a $(LIBS) -o $(WISH_EXEC)

$(MAN_PAGE):	oratcl.man
	nroff -man oratcl.man >$(MAN_PAGE)

get-tcl-flags:
	egrep '^MATH_LIBS'         $(TCL_DIR)/Makefile    >tclflags.mk
	egrep '^AC_FLAGS'          $(TCL_DIR)/Makefile   >>tclflags.mk
	egrep '^PROTO_FLAGS'       $(TCL_DIR)/Makefile   >>tclflags.mk
	egrep '^MEM_DEBUG_FLAGS'   $(TCL_DIR)/Makefile   >>tclflags.mk
	egrep '^CFLAGS'            $(TCL_DIR)/Makefile   >>tclflags.mk
	egrep '^X11_INCLUDES'      $(TK_DIR)/Makefile    >>tclflags.mk
	egrep '^X11_LIB_SWITCHES'  $(TK_DIR)/Makefile    >>tclflags.mk
	egrep '^LIBS'              $(TK_DIR)/Makefile | \
	    sed -e 's@libtk.a@$(TK_DIR)/libtk.a@p'       >>tclflags.mk
	@echo "tclflags.mk made.  check that the following are defined:"
	@echo "MATH_LIBS  AC_FLAGS  PROTO_FLAGS  MEM_DEBUG_FLAGS  CFLAGS "
	@echo "X11_INCLUDES  X11_LIB_SWITCHES  LIBS"
	@echo
	@echo "tclflags.mk:"
	@cat   tclflags.mk
	@echo
	@echo  'if the flags are suitable, type "make" to build'

install:	$(TCL_EXEC) $(WISH_EXEC) $(MAN_PAGE)
	$(INSTALL) `pwd`/$(TCL_EXEC)  $(BIN_DIR)/$(TCL_EXEC)
	$(INSTALL) `pwd`/$(WISH_EXEC) $(BIN_DIR)/$(WISH_EXEC)
	$(INSTALL) `pwd`/$(MAN_PAGE)  $(MAN_DIR)/$(MAN_PAGE)

install-wosql:
	echo "wosql requires Extended Tcl, see Makefile.TclX"

tests:	$(TCL_EXEC)
	./$(TCL_EXEC) oratcl.test

clean:
	rm -f $(TCL_EXEC) $(WISH_EXEC) $(MAN_PAGE) oratcl.o libOratcl.a \
	      tclAppInit.c tkAppInit.c tclAppInit.o tkAppInit.o
	-rm -f libtmp/*.o libtmp/*.a
	cp tclflags.mk.orig tclflags.mk

###############################################################################
# end of Makefile
###############################################################################
