
proc run body {
    if {[catch [list uplevel $body]] == 1} {
	global errorInfo
	puts stderr $errorInfo
    }
}

proc vtime {msg t_var body} {
    upvar $t_var t
    puts "### $msg"
    puts [set t [time [list uplevel $body]]]
    set t [lindex $t 0]
}

run {
    if {$argc != 2} {
	puts stderr "usage: $argv0 x y"
	exit 1
    }
    vtime "Testing tcl" t {
	set lx [lindex $argv 0]
	set ly [lindex $argv 1]
	for {set y 0} {$y < $ly} {incr y} {
	    for {set x 0} {$x < $lx} {incr x} {
		set m($y,$x) 0
	    }
	}
	set sum 0
	for {set y 0} {$y < $ly} {incr y} {
	    for {set x 0} {$x < $lx} {incr x} {
		set sum [expr $sum + $m($y,$x)]
	    }
	}
	puts "Sum: $sum"
    }
    set n [expr $lx * $ly]
    puts "approximately [expr 1.0 * $t / $n] usecs/array elt"
    puts "   or [expr 1.0e3 * $n / $t] K-elts/sec"
}
