#!./wish -f

proc flistbox {name args} {
	frame $name
	pack append [winfo parent $name] \
		$name { top fill expand }

	frame $name.f
	scrollbar $name.hs \
			-orient horizontal \
			-command "$name set_list xview"
	pack append $name \
		$name.f   { top fill expand } \
		$name.hs  { top fillx }

	listbox $name.f.l \
			-yscrollcommand "$name set_scroll $name.f.vs" \
			-xscrollcommand "$name set_scroll $name.hs"
	scrollbar $name.f.vs \
			-command "$name set_list yview"
	pack append $name.f \
		$name.f.l   { left fill expand } \
		$name.f.vs  { left filly }

	subcmd add $name set_list {which index} {$majorCommand.f.l $which $index}

	subcmd add $name set_scroll {which total window first last} {
		if {$window >= $total} {
			pack unpack $which
		} else {
			if {$which == "$majorCommand.f.vs"} {
				pack after $majorCommand.f.l \
					$majorCommand.f.vs { left filly }
			} else {
				pack after $majorCommand.f \
					$majorCommand.hs { top fillx }
			}
			$which set $total $window $first $last
		}
	}

	subcmd add $name get index {
		return [$majorCommand.f.l get $index]
	}

	subcmd add $name delete {first {last ""}} {
		if {$last != ""} {
			return [$majorCommand.f.l delete $first $last]
		} else {
			return [$majorCommand.f.l delete $first]
		}
	}

	subcmd add $name insert {index args} {
		return [eval "$majorCommand.f.l insert $index $args"]
	}

	subcmd add $name curselection {} {
		return [$majorCommand.f.l curselection]
	}

	subcmd add $name size {} { return [$majorCommand.f.l size] }

	subcmd add $name path child {
		case $child in {
		list	{ return "$majorCommand.f.l" }
		vs	{ return "$majorCommand.f.vs" }
		hs	{ return "$majorCommand.hs" }
		}
	}
}

wm minsize . 1 1

flistbox .f
frame .cmd
pack append . \
	.f	{ top fill expand } \
	.cmd	{ top fillx }

button .cmd.add  -text Add  -command { .f insert end [exec date] }
button .cmd.list -text List -command {
		set s [.f size]
		for {set i 0} {$i < $s} {incr i} {
			puts stdout "$i: [.f get $i]"
		}
	}
button .cmd.del  -text Delete -command {
		set sel [.f curselection]
		set ll  [llength $sel]
		if {$ll == 0} return
		if {$ll == 1} {
			.f delete [lindex $sel 0]
		} else {
			.f delete [lindex $sel 0] [lindex $sel [expr $ll-1]]
		}
	}
pack append .cmd \
	.cmd.add	{ left fillx expand } \
	.cmd.list	{ left fillx expand } \
	.cmd.del	{ left fillx expand }
