/*
 * ------------------------------------------------------------------------
 *  APPLICATION:  [incr Tcl]
 *      PURPOSE:  object-oriented extensions to Tcl
 *
 *  This segment handles "methods" which are procedures defined within
 *  the scope of a class.  In a class definition for [incr Tcl], the
 *  term "method" is used for a procedure that has access to object-
 *  specific data, while the term "proc" is used for a procedure that
 *  has access only to common class data.  Here the term "method" is
 *  used more generically to apply to both.
 *
 * ------------------------------------------------------------------------
 *  AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
 *           AT&T Bell Laboratories   E-mail: michael.mclennan@att.com
 *
 *    SCCS:  @(#)itcl_methods.h	1.7 (10/14/93)
 * ========================================================================
 *                 Copyright (c) 1993  AT&T Bell Laboratories
 * ========================================================================
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that the copyright notice and warranty disclaimer appear in
 * supporting documentation, and that the names of AT&T Bell Laboratories
 * any of their entities not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.
 * 
 * AT&T disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness.  In no event
 * shall AT&T be liable for any special, indirect or consequential
 * damages or any damages whatsoever resulting from loss of use, data or
 * profits, whether in an action of contract, negligence or other
 * tortuous action, arising out of or in connection with the use or
 * performance of this software.
 * ========================================================================
 */
#ifndef ITCL_METHODS_H
#define ITCL_METHODS_H

#include "tcl.h"
#include "tclInt.h"

typedef int (Itcl_MethodProc) _ANSI_ARGS_((ClientData cdata, Tcl_Interp *interp,
	int argc, char **argv));

/*
 *  METHOD INFO
 */
struct Itcl_Class;
typedef struct Itcl_Method {
	char *name;                 /* method name */
	struct Itcl_Class *cdefn;   /* class containing this method */
	Arg *arglist;               /* list of arg names and initial values */
	int type;                   /* method type (ITCL_*_METHOD) */
	union {
		char *body;                  /* body (TCL statements) */
		Itcl_MethodProc *builtin;    /* body (built-in C code) */
		struct Itcl_Method *actual;  /* reference to inherited method */
	} values;
	int invoked;                /* see object construction/destruction */
} Itcl_Method;

#define ITCL_TCL_METHOD        1
#define ITCL_BUILTIN_METHOD    2
#define ITCL_INHERITED_METHOD  3

/*
 *  FORWARD DECLARATIONS
 */
extern Itcl_Method* Itcl_CreateMethod _ANSI_ARGS_((struct Itcl_Class *cdefn,
	char* name, char* arglist, char* body));
extern Itcl_Method* Itcl_CreateBiMethod _ANSI_ARGS_((struct Itcl_Class *cdefn,
	char* name, Itcl_MethodProc *proc));
extern Itcl_Method* Itcl_CreateRefMethod _ANSI_ARGS_((struct Itcl_Class *cdefn,
	Itcl_Method *mdefn));
extern void Itcl_DeleteMethod _ANSI_ARGS_((Itcl_Method *mdefn));

extern Arg* Itcl_CreateArg _ANSI_ARGS_ ((char* name, char* init));
extern char* Itcl_ArgList _ANSI_ARGS_ ((Arg* arg));

extern int Itcl_ExecMethod _ANSI_ARGS_((ClientData cdata, Tcl_Interp *interp,
    int argc, char **argv));
extern int Itcl_ExecProc _ANSI_ARGS_((ClientData cdata, Tcl_Interp *interp,
    int argc, char **argv));

extern int Itcl_UnknownCmd _ANSI_ARGS_((ClientData cdata, Tcl_Interp *interp,
    int argc, char **argv));
extern int Itcl_PreviousCmd _ANSI_ARGS_((ClientData cdata, Tcl_Interp *interp,
    int argc, char **argv));
extern int Itcl_VirtualCmd _ANSI_ARGS_((ClientData cdata, Tcl_Interp *interp,
    int argc, char **argv));
extern int Itcl_UplevelCmd _ANSI_ARGS_((ClientData cdata, Tcl_Interp *interp,
    int argc, char **argv));

#endif
