/*
 * dpnetworkInit.c --
 *
 *	Initialize an interpreter with Tcl-DP.
 *	This mostly just makes a bunch of calls to Tcl_CreateCommand to
 *	create tcl commands for the various modules.
 */


#include "dputil.h"
#include "dpnetwork.h"
#include "dproto.h"


/*
 *--------------------------------------------------------------
 *
 * Tdp_networkInit --
 *
 *	Initialize an interpreter with the network extensions to tcl.
 *
 * Results:
 *	None
 *
 * Side effects:
 *	network related commands are bound to the interpreter.
 *
 *--------------------------------------------------------------
 */
int
Tdp_networkInit (interp)
    Tcl_Interp *interp;		/* tcl interpreter */
{
    Tcl_CreateCommand (interp, "dp_address", Tdp_AddressCmd,
		       (ClientData) NULL, (void (*) ()) NULL);

    Tdp_Tcp_Init(interp);
    Tdp_RPCInit(interp);
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tdp_Init --
 *
 *	Initialize the full Tcl-DP package.
 *
 * Results:
 *	None
 *
 * Side effects:
 *	network related commands are bound to the interpreter.
 *
 *--------------------------------------------------------------
 */
int
Tdp_Init (interp)
     Tcl_Interp *interp;
{
  Tdp_utilInit (interp);
  Tdp_networkInit (interp);
  return TCL_OK;
}
