'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/menu.man,v 1.4 91/10/31 14:12:19 ouster Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS htext cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
htext \- Create and manipulate hypertext widgets
.SH SYNOPSIS
\fBhtext\fI \fIpathName \fR[\fIoptions\fR]
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR
\fBfont\fR	\fBforeground\fR	\fBgeometry\fR
\fBrelief\fR	\fBtext\fR	\fBxScrollCommand\fR
\fByScrollCommand\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBfileName\fR
Class:	\fBFileName\fR
Command-Line Switch:	\fB\-filename\fR
.fi
.IP
Specifies the  name of the file to be read into the hypertext 
widget. See \fBFile Format\fR for a description of what a hypertext file
should look like.
.LP
.nf
Name:	\fBspecialChar\fR
Class:	\fBSpecialChar\fR
Command-Line Switch:	\fB\-specialchar\fR
.fi
.IP
Specifies the numeric value of the Tcl command delimiter characters.
These characters marks blocks of Tcl commands inside of hypertext files.
The default is characters is the \fIpercent sign\fR.
.LP
.nf
Name:	\fBlineSpacing\fR
Class:	\fBLineSpacing\fR
Command-Line Switch:	\fB\-linespacing\fR
.fi
.IP
Specifies the number of pixels spacing between each line
of text.  The default is 1.
.LP
.nf
Name:	\fBxScrollUnits\fR
Class:	\fBScrollUnits\fR
Command-Line Switch:	\fB\-xscrollunits\fR
.fi
.IP
Specifies the number of pixels to move in a single horizontal scroll.
The default is 10.
.LP
.nf
Name:	\fByScrollUnits\fR
Class:	\fBScrollUnits\fR
Command-Line Switch:	\fB\-yscrollunits\fR
.fi
.IP
Specifies the number of pixels to move in a single vertical scroll.
The default is 10.
.BE
.SH INTRODUCTION
.PP
The \fBhtext\fR command creates a new window (given by the 
\fIpathName\fR argument) and makes it into a hypertext widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the hypertext such as its colors and font.
The \fBhtext\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
At its simplest, the hypertext widget is a non-editable text widget;
it reads a file of text and displays it in a window.  However there 
are two important differences.  Tcl commands can be embedded into 
a hypertext file.  Normally the characters are read and stored as text 
to be displayed, but characters between double percent 
signs "%%" are immediately passed to Tcl for evaluation.  Secondly,
any Tk widget or hierarchy or Tk widgets can be made to appear within 
the current line of the text in the window. 
.PP
Widgets are placed using the hypertext \fBappend\fP command. The widget
must be a child of the hypertext window and must already exist.
The \fBappend\fP command places the widget at the current point
in the hypertext document as the text is read and parsed.
Once a widget has been appended it cannot be moved to a different
position within the text.  Widgets can be resized or justified
differently, but they remain at the same position within the text.
Any Tk widget or widget tree can be appended.  The widgets behave 
as they normally would.  For example, the Tk \fBbind\fP command may 
be used to bind X events to them.  
.SH FILE FORMAT
.PP
A hypertext file is generally ASCII text.  The characters enclosed
by two special characters (by default, percent signs '%%') are
interpreted and executed as Tcl commands.  The special character 
may be specified by the \fI-specialchar\fP option. In the following example
of a hypertext file,  a Tk button widget is appended to the text between 
the words "\fCa\fP" and "\fCwhich\fP".  The \fIpathName\fR of the 
hypertext widget is "\fC.ht\fP".
.DS L
\fCThis will be displayed as normal text. 
But this will become a %% 
  button .ht.button -text "button" -fg red
  .ht append .ht.button 
%% which can invoke a Tcl command.\fR
.DE
.LP
.SH "VARIABLES"
.PP
As a convenience, global Tcl variables \fBthis\fR, \fBthisLine\fR, 
and \fBthisFile\fR are available when a hypertext file is parsed.  
.TP
\fBthis\fR 
\fIpathName\fP of the hypertext widget.
.TP
\fBthisFile\fR 
Name of the file current hypertext file.  This is the empty string when
the \fI\-text\fP option is used.
.TP
\fBthisLine\fR 
The current line number.  
.PP
This information might 
be used to construct hyper links between different files and/or lines.
.LP
.SH "WIDGET COMMAND"
.PP
The \fBhypertext\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option child \fR[\fIarg\fR]
.DE
\fIOption\fR, \fIchild\fR, and \fIarg\fR
determine the exact behavior of the command.
.PP
In all cases, \fIchild\fP is the name of the child Tk widget which
has been appended to the hypertext widget. The child widget may be
specified by either its \fIpathName\fP or \fIname\fP.
The following widget commands are available for hypertext widgets:
.TP
\fIpathName \fBappend \fIchild\fR
Append the Tk widget \fIchild\fP at the current position. The hypertext
widget must be the parent of \fIchild\fP and \fIchild\fP must already
exist.
.TP
\fIpathName \fBgotoline \fIlineNumber\fR
Go to the line \fIlineNumber\fP. \fILineNumber\fP must be a valid
line number.   If no argument is given, the current line number is returned.
.TP
\fIpathName \fBchildconfigure \fIchild\fR
Configures the positioning of the child widget. The following
options are available.
.RS
.TP
\fB\-anchor \fIvalue\fR
Justify the vertical position of the child widget in relation to the 
line of text. The only meaningful values are "n", "s", and "center". 
By default, the child widget is centered along the line of text.
.TP
\fB\-width \fIvalue\fR
Change the width of the child widget.  If \fIvalue\fP is greater
than 0, the widget is resized to that width.  By default, widgets are
allowed to expand to their requested widths. 
.TP
\fB\-height \fIvalue\fR
Change the height of the child widget.  If \fIvalue\fP is greater
than 0, the widget is resized to that height.  By default, widgets are
allowed to expand to their requested heights. 
.TP
\fB\-padx \fIvalue\fR
Pad the left and right sides of the child widget by \fIvalue\fP pixels.
.TP
\fB\-pady \fIvalue\fR
Pad the top and bottom sides of the child widget by \fIvalue\fP pixels.
.RE
.TP
\fIpathName \fBxview \fI?position?\fR
If a position argument is provided, move the viewport horizontally to the 
new X position.  The current X position is always returned.
.TP
\fIpathName \fByview \fI?position?\fR
If a position argument is provided, move the viewport vertically to the 
new Y position.  The current Y position is always returned.
.TP
\fIpathName \fBmap \fIchild\fR
Map the widget \fIchild\fP.
.TP
\fIpathName \fBunmap \fIchild\fR
Unmap the widget \fIchild\fP.
.SH KEYWORDS
hypertext, widget
