'\"
'\" Copyright 1992 The Australian National University.
'\"
'\" Permission to use, copy, modify, and distribute this documentation
'\" is hereby granted, provided that the above copyright
'\" notice appears in all copies.  This software is provided without any
'\" warranty, express or implied. The Australian National University
'\" makes no representations about the suitability of this software for
'\" any purpose.
'\"
'\" Author: Paul Mackerras (paulus@cs.anu.edu.au)
'\"
'\" SCCS info: @(#)FindPhoto.man	1.2	last modified: 5/6/92
.\" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'	# BS - start boxed text
'	# ^y = starting y location
'	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'	# VS - start vertical sidebar
'	# ^Y = starting y location
'	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'	# Special macro to handle page bottom:  finish off current
'	# box/sidebar if in box/sidebar mode, then invoked standard
'	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS FindPhoto tk
.BS
.SH NAME
FindPhoto, PhotoPutBlock, PhotoBlank, PhotoExpand, PhotoGetSize, PhotoSetSize \- manipulate the image displayed in a photo widget.
.SH SYNOPSIS
.nf
\fB#include <tk.h>
#include <photo.h>\fR
.sp
PhotoHandle
\fBFindPhoto\fR(\fIwindow_path\fR)
.sp
void
\fBPhotoPutBlock\fR(\fIhandle, block, x, y, width, height\fR)
.sp
void
\fBPhotoBlank\fR(\fIhandle\fR)
.sp
void
\fBPhotoExpand\fR(\fIhandle, width, height\fR)
.sp
void
\fBPhotoGetSize\fR(\fIhandle, widthp, heightp\fR)
.sp
void
\fBPhotoSetSize\fR(\fIhandle, width, height\fR)
.SH ARGUMENTS
.AS PhotoHandle window_path
.AP char *window_path in
Window pathname of the desired photo widget.
.AP PhotoHandle handle in
Opaque handle to identify the photo widget to be affected.
.AP PhotoImage *block in
Specifies the address and dimensions of the image data to be displayed.
.AP int x in
Specifies the X coordinate where the top-left corner of the block is
to be placed within the image.
.AP int y in
Specifies the Y coordinate where the top-left corner of the block is
to be placed within the image.
.AP int width in
Specifies the width of the image area to be affected (for
\fBPhotoPutBlock\fR) or the desired image width (for
\fBPhotoExpand\fR and \fBPhotoSetSize\fR).
.AP int height in
Specifies the height of the image area to be affected (for
\fBPhotoPutBlock\fR) or the desired image height (for
\fBPhotoExpand\fR and \fBPhotoSetSize\fR).
.AP int *widthp out
Pointer to location in which to store the image width.
.AP int *heightp out
Pointer to location in which to store the image height.
.BE

.SH DESCRIPTION
.PP
\fBFindPhoto\fR returns an opaque handle which is used to identify a
particular photo widget to the other procedures.  The parameter is the
window path name used when creating the photo widget (using the
\fBphoto\fR Tcl command).  The widget must be created before
\fBFindPhoto\fR is called.
.PP
\fBPhotoPutBlock\fR is used to supply blocks of image data to be
displayed.  The call affects an area of the image of size
\fIwidth\fR x \fIheight\fR pixels, with its top-left corner at
coordinates (\fIx\fR,\fIy\fR).  (All of \fIwidth\fR, \fIheight\fR,
\fIx\fR, and \fIy\fR must be non-negative.)
If part of this area lies outside the
current bounds of the image, the image will be expanded to include the
area, unless the user has specified an explicit image size with the
\fB\-imageSize\fR widget configuration option (see photo(1)); in that
case the area is silently clipped to the image boundaries.
.PP
The \fIblock\fR parameter is a pointer to a
\fBPhotoImage\fR structure, defined as follows:
.DS
.ta 3c,6c
\fBtypedef struct\fR {
    \fBunsigned char\fR *\fIptr\fR;	/* points to image data */
    \fBint\fR	\fIwidth\fR;	/* horiz # pixels in block */
    \fBint\fR	\fIheight\fR;	/* vert # pixels in block */
    \fBint\fR	\fIpitch\fR;	/* # bytes stored per line */
    \fBint\fR	\fIpixel_size\fR;	/* # bytes per pixel */
    \fBint\fR	\fIcomp_off[3]\fR;	/* offset to R,G,B components */
} \fBPhotoImage;\fR
.DE
.LP
The \fIptr\fR field points to the first pixel (top-left corner).
The \fIwidth\fR and \fIheight\fR fields specify the dimensions of the
block of pixels.  The \fIpixel_size\fR field specifies the address
difference between two horizontally adjacent pixels.  Normally it is 3
or 4, but it can have any value.  The \fIpitch\fR field specifies the
address difference between two vertically adjacent pixels.  The
\fIcomp_off\fR array contains the offsets from the address of a pixel
to the addresses of the bytes containing the red, green and blue
components.  These are normally 0, 1 and 2, but can have other values,
e.g., for images which are stored as separate red, green and blue
images.
.PP
The value given for the \fIwidth\fR and \fIheight\fR parameters to
\fBPhotoPutBlock\fR do not have to correspond to the values specified
in \fIblock\fR.  If they are smaller, \fBPhotoPutBlock\fR extracts a
sub-block from the image data supplied.  If they are larger, the data
given are replicated (in a tiled fashion) to fill the specified area.
These rules operate independently in the horizontal and vertical
directions.
.PP
\fBPhotoBlank\fR clears the entire image stored in the
photo widget to the blank color (usually black).
.PP
\fBPhotoExpand\fR requests that the widget's image be expanded to be
at least \fIwidth\fR x \fIheight\fR pixels in size.  This has no effect
if the user has specified an explicit image size.  If the image data
are being supplied in many small blocks, it is more efficient to use
\fBPhotoExpand\fR or \fBPhotoSetSize\fR at the beginning rather than
allowing the image to expand in many small increments as image blocks
are supplied.
.PP
\fBPhotoSetSize\fR specifies the size of the image.  The size given
overrides any previous size.  This call is equivalent to specifying
the size with the \fB\-imageSize\fR widget configuration option.  If
both \fIwidth\fR and \fIheight\fR are zero, the user-specified size is
countermanded, and the image size will be determined as specified in
photo(1).
.PP
\fBPhotoGetSize\fR returns the dimensions of the widget's image in
*\fIwidthp\fR and *\fIheightp\fR.

.SH KEYWORDS
photo widget, image
