# ----------------------------------------------------------------------
#  PURPOSE:  Electrical outlet supplying power for Appliances.
#
#   AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
#            AT&T Bell Laboratories   E-mail: aluxpo!mmc@att.com
#
#     SCCS:  @(#)Outlet.tcl	1.1 (7/22/93)
# ----------------------------------------------------------------------
#            Copyright (c) 1993  AT&T  All Rights Reserved
# ======================================================================

itcl_class Outlet {
	constructor {config} {}
	method config {config} {}

	destructor {
		if {$usage > 0} bill
	}

	method use {power} {
		set usage [expr $usage+$power]
	}

	method sendBill {} {
		if {[catch "open /tmp/bill w" fout] != 0} {
			error "cannot create bill in /tmp"
		} else {
			set amount [format "$%.2f" [expr $usage*$rate]]
			puts $fout "----------------------------------------"
			puts $fout "/////////// MEGA-POWER, INC. ///////////"
			puts $fout "----------------------------------------"
			puts $fout "   Customer: $owner"
			puts $fout "     Outlet: $this"
			puts $fout "      Usage: $usage kilowatt-hours"
			puts $fout "                                        "
			puts $fout " Amount Due: $amount"
			puts $fout "----------------------------------------"
			close $fout
			exec mail $owner < /tmp/bill
			set usage 0
		}
	}

	proc bill {{customer *}} {
		foreach outlet [itcl_info objects -class Outlet] {
			set owner [$outlet info public owner -value]
			if {[string match $customer $owner]} {
				$outlet sendBill
			}
		}
	}

	proc rate {{newval ""}} {
		if {$newval == ""} {
			return $rate
		}
		set rate $newval
	}

	public owner {}
	protected usage 0

	common rate 0.05
}
