/* exp_tty.h - tty support definitions */
/* Definitions for handling termio inclusion are localized here */
/*
 * Written by Rob Savoye <rob@cygnus.com>. Mon Feb 22 11:16:53 RMT 1993
 */

#ifndef __EXP_TTY_H__
#define __EXP_TTY_H__

#include "exp_conf.h"

/*
 * Set up some macros to isolate tty differences
 */

#if defined(HAVE_TERMIO) && !defined(HAVE_TERMIOS)
#  include <termio.h>
#  define TERMINAL termio
/***
#  define TCGETS	TCGETA
#  define TCSETS	TCSETA
#  define TCSETSW	TCSETAW
#  define TCSETSF	TCSETAF
***/
#endif

#if defined(HAVE_SGTTYB) && !defined(HAVE_TERMIOS)
#  undef HAVE_TERMIO
#  undef POSIX
#  define TCGETS	TIOCGETP
#  define TCSETS	TIOCSETP
#  define TCSETSW	TIOCSETN
#  define TERMINAL sgttyb
#  ifdef HAVE_SYS_FCNTL_H
#    include <sys/fcntl.h>
#  else
#    include <fcntl.h>
#  endif
#  include <sgtty.h>
#  include <sys/ioctl.h>
#endif

#if defined(HAVE_TERMIOS)
#  undef HAVE_TERMIO
#  undef HAVE_SGTTYB
#  include <termios.h>
#  define TERMINAL termios
#  if !defined(TCGETS) || !defined(TCSETS)
#    define TCGETS	TCGETA
#    define TCSETS	TCSETA
#    define TCSETSW	TCSETAW
#    define TCSETSF	TCSETAF
#  endif
#endif

/* This section was written by: Don Libes, NIST, 2/6/90

Design and implementation of this program was paid for by U.S. tax
dollars.  Therefore it is public domain.  However, the author and NIST
would appreciate credit if this program or parts of it are used.
*/
typedef struct TERMINAL exp_tty;
extern exp_tty exp_tty_original;

extern int exp_dev_tty;
extern int ioctled_devtty;

void exp_init_tty();
void tty_raw();
void tty_set();
void tty_echo();
int tty_raw_noecho();

#endif	/* __EXP_TTY_H__ */
