#!/bin/sh
#
# Program: xfemacs
#
# This file is an automatically created shell script
# for starting the application named: xfemacs.tcl
#
# adapt the following variables to fit your
# local site
#
# WHIS_CMD is the wish interpreter to use
WISH_CMD=wish
#
# XF_LOAD_PATH is the path were the tcl modules
# for this application are located
if test "$XF_LOAD_PATH" = ""; then
  XF_LOAD_PATH=.:/usr/local/lib
else
  XF_LOAD_PATH=$XF_LOAD_PATH:.:/usr/local/lib
fi
#
#
ARGC=$#
COMMANDLINE=
while [ $ARGC -gt 0 ]; do
  C=$1
  shift
  ARGC=`expr $ARGC - 1`
  case $C in
    -xfloadpath)
      if [ $ARGC -gt 0 ]; then
        C=$1
        shift
        ARGC=`expr $ARGC - 1`
        XF_LOAD_PATH=$C:$XF_LOAD_PATH
      else
        echo "xfemacs.tcl: expected path for -xfloadpath"
        exit 2
      fi;;
    *)
      COMMANDLINE=$COMMANDLINE" "$C;;
  esac
done
#
export XF_LOAD_PATH
for p in `echo $XF_LOAD_PATH|awk 'BEGIN{RS=":"}
{print $0}'`; do
  if test -f $p/xfemacs.tcl; then 
    exec $WISH_CMD -name xfemacs -file $p/xfemacs.tcl $COMMANDLINE
  fi
done
echo "Could not find: xfemacs.tcl"
# eof

