proc filechooser::mk {w width height args} {
frame $w 
frame $w.f 
entry $w.f.e -width $width -relief sunken -bg lightblue 
button $w.f.q -text quit -command "destroy $w.f"
button $w.f.c -text cancel -command "destroy $w"
button $w.f.b -text OK -command "filechoo::ok $w"
label $w.lb -width $width -text [pwd]
pack append $w.f $w.f.e "top pady $width" $w.f.b {right pady 10} $w.f.c {right padx 10 pady 10}  


frame $w.l 
scrollbar $w.l.scroll -command "$w.l.list yview"
listbox $w.l.list -yscroll "$w.l.scroll set" -relief raised -geometry ${width}x${height} 

pack append $w.l $w.l.list {left padx 10}  $w.l.scroll {left filly}

pack append $w $w.f {top fill} $w.lb {top frame w fill} $w.l {top fill pady 10}
bind $w.l.list <Control-c> {destroy .}
bind $w.l.list <Control-q> {destroy .}
foreach i [exec ls -a ] { $w.l.list insert end $i }
}

proc filechoo::ok {w} {
puts stdout "[$w.f.e get]"
}


proc filechoo::listcmd {w file} {
	$w.f.e delete 0 end
	$w.f.e insert end $file
	$w.lb configure -text [pwd]
	}

proc filechoo::browse {w dir file} {
    global env
    if {[string compare $dir "."] != 0} {set file $dir/$file}
    if [file isdirectory $file] {
	cd $file
	$w.lb configure -text [pwd]
        $w.l.list delete 0 end
        foreach i [exec ls -a .] { $w.l.list insert end $i }
    } else {
	if [file isfile $file] {
		 filechoo::listcmd $w $file 
	} else {
	    puts stdout "\"$file\" isn't a directory or regular file"
	}
    }
}
