#include "gui.h"
#include "cup.h"
#include "help.h"

int menu_handler(client* data, kit* tk, int argc, char** argv) {

if (argc < 2) return ERROR;

canvas* cnv = (canvas*) data;
char* s = argv[1];

if ( ! strcmp(s,"refill") ) { 
	cup c(tk,cnv);
	c.fill();
	}
else if ( !strcmp(s,"money back") ) {
	cout << " sorry no refunds" << endl;
	cup c(tk,cnv);
	}

return OK;
}


int coffee_handler(client* data, kit* tk, int, char**) {

canvas* cnv = (canvas*) data;

cup c(tk,cnv);
c.fill();
	
return OK;
}



gui::gui(kit* tk) {
 
    f = new frame(".screen");

    menubar* bar = new menubar(f,".bar");
    canvas* c = new canvas(f,".canvas","-bg black");
    c->configure("-height 400 -width 200");

    c->rectangle(20,150,180,250,"-fill lightblue");

    button* s = new button(c,".s","-bg blue -fg white");
    s->text("25ct");

    c->window(140,40,s);

    s->handler(coffee_handler,c);

    f->pack(bar)->pack(c)->pack(".quit");

    menubutton* b = new menubutton(bar,".b1");
    b->text("commands");

    menu* m = new menu(b,".m");
    m->handler(menu_handler,c);
    b->menu(m);

    m->entry("refill");
    m->entry("money back");
    m->entry("quit","quitting","-command { destroy . }");

    button* help = new button(bar,".help");
    help->text("help");
    help->handler(open_help,0,"help.ht");

    bar->pack(b)->pack(help,"{ left fillx filly }");
}
