#include <hush/hush.h>

#ifndef HCLONLY

static int x, y;
extern Tk_Window MainWindow;

/*
 *----------------------------------------------------------------------
 *
 * Tk_BellCmd --
 *
 *    This procedure is invoked to process the "bell" Tcl command.
 *    See the user documentation for details on what it does.
 *
 * Results:
 *    A standard Tcl result.
 *
 * Side effects:
 *    None.
 *
 *----------------------------------------------------------------------
 */
      /* ARGSUSED */
int
Tk_BellCmd( //clientData, interp, argc, argv)
    ClientData clientData, // Main Window
    Tcl_Interp *interp, //              
    int argc, //            
    char **argv )          
{
    Tk_Window tkwin = (Tk_Window) clientData;
    int percent;

    if (argc == 1) {
      percent = 50;
    } else if (argc == 2) {
      if ((Tcl_GetInt(interp, argv[1], &percent) != TCL_OK)
          || (percent < -100) || (percent > 100)) {
          Tcl_ResetResult(interp);
          Tcl_AppendResult(interp, "bad volume percentage value \"",
                           argv[1], "\"", (char *) NULL);
          return TCL_ERROR;
      }
    } else {
      Tcl_AppendResult(interp, "wrong # args: should be \"",
                       argv[0], " ?volumePercent?\"", (char *) NULL);
      return TCL_ERROR;
    }

    XBell(Tk_Display(tkwin), percent);
    return TCL_OK;
}



int
Tk_DotCmd(
    ClientData dummy,			/* Not used. */
    Tcl_Interp *interp,			/* Current interpreter. */
    int argc,				/* Number of arguments. */
    char **argv)			/* Argument strings. */
{
    int x, y;

    if (argc != 3) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" x y\"", (char *) NULL);
	return TCL_ERROR;
    }
    x = strtol(argv[1], (char **) NULL, 0);
    y = strtol(argv[2], (char **) NULL, 0);
    Tk_MakeWindowExist(MainWindow);
    XDrawPoint(Tk_Display(MainWindow), Tk_WindowId(MainWindow),
	    DefaultGCOfScreen(Tk_Screen(MainWindow)), x, y);
    return TCL_OK;
}

	/* ARGSUSED */
int
Tk_MovetoCmd(
    ClientData dummy,			/* Not used. */
    Tcl_Interp *interp,			/* Current interpreter. */
    int argc,				/* Number of arguments. */
    char **argv)			/* Argument strings. */
{
    if (argc != 3) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" x y\"", (char *) NULL);
	return TCL_ERROR;
    }
    x = strtol(argv[1], (char **) NULL, 0);
    y = strtol(argv[2], (char **) NULL, 0);
    return TCL_OK;
}
	/* ARGSUSED */
int
Tk_LinetoCmd(
    ClientData dummy,			/* Not used. */
    Tcl_Interp *interp,			/* Current interpreter. */
    int argc,				/* Number of arguments. */
    char **argv)			/* Argument strings. */
{
    int newX, newY;

    if (argc != 3) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" x y\"", (char *) NULL);
	return TCL_ERROR;
    }
    newX = strtol(argv[1], (char **) NULL, 0);
    newY = strtol(argv[2], (char **) NULL, 0);
    Tk_MakeWindowExist(MainWindow);
    XDrawLine(Tk_Display(MainWindow), Tk_WindowId(MainWindow),
	    DefaultGCOfScreen(Tk_Screen(MainWindow)), x, y, newX, newY);
    x = newX;
    y = newY;
    return TCL_OK;
}


/*
 * SET_CLASS -- add setclass command
 */

       /* ARGSUSED */
int
SetClassCmd(
    ClientData dummy, 
    Tcl_Interp *interp,
    int argc,
    char **argv)
{
    if (argc != 3) {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                       " window classname\"", (char *) NULL);
      return TCL_ERROR;
    }
    Tk_SetClass(Tk_NameToWindow(interp,argv[1],Tk_MainWindow(interp)), argv[2]);

    return TCL_OK;
}

void init_tk( kit* tk ) {

tk->action("bell",Tk_BellCmd, (clientdata) MainWindow );
tk->action("dot",Tk_DotCmd, (clientdata) MainWindow );
tk->action("moveto",Tk_MovetoCmd, (clientdata) MainWindow );
tk->action("lineto",Tk_LinetoCmd, (clientdata) MainWindow );

tk->action("setclass", SetClassCmd, (clientdata) MainWindow);

}

#endif /* HCLONLY */
