


filehandler(1)           USER COMMANDS             filehandler(1)



_________________________________________________________________

NAME
     filehandler - to handle file descriptor conditions

SYNOPSIS
     filehandler _f_i_l_e_I_d ?_m_o_d_e _c_o_m_m_a_n_d?
_________________________________________________________________

DESCRIPTION
     The Tcl/Tk filehander command allows one to specify a Tcl/Tk
     _c_o_m_m_a_n_d which will be evaluated whenever the file descriptor
     represented by _f_i_l_e_I_d is readable, writable, and/or  has  an
     exceptional condition pending.

     A _f_i_l_e_I_d is an identifier which represents a  file  descrip-
     tor.   It  is identical to the identifier manipulated by the
     Tcl-DP  (Tcl  Distributed  Programming)  network  connection
     management   commands  (connect,  shutdown,  send,  receive,
     etc.).  _f_i_l_e_I_d's are also manipulated  by  the  open,  read,
     write,  gets,  puts,  and  close file management commands of
     Tcl.

     The _m_o_d_e argument indicates the situations when the  _c_o_m_m_a_n_d
     will be evaluated.  It may be any combination of the follow-
     ing values:

          r    Eval _c_o_m_m_a_n_d whenever there is  data  to  be  read
               from  the  _f_i_l_e_I_d.   The _c_o_m_m_a_n_d is evaluated with
               two arguments appended: r to indicate that data is
               readable  on  the file descriptor, and the _f_i_l_e_I_d,
               which represents the file descriptor that is read-
               able.   The _c_o_m_m_a_n_d should read at least some data
               from the _f_i_l_e_I_d,  or  otherwise  _c_o_m_m_a_n_d  will  be
               called continuously.

          w    Eval _c_o_m_m_a_n_d whenever data can be written  to  the
               _f_i_l_e_I_d without blocking.  The _c_o_m_m_a_n_d is evaluated
               with two arguments appended: w  to  indicate  that
               the  file  descriptor is writable, and the _f_i_l_e_I_d,
               which represents the writable file descriptor.

          e    Eval _c_o_m_m_a_n_d whenever there is an exceptional con-
               dition  pending  on  the  _f_i_l_e_I_d.   The _c_o_m_m_a_n_d is
               evaluated with two arguments appended: e to  indi-
               cate  exception,  and the _f_i_l_e_I_d, which represents
               the file descriptor with  the  exceptional  condi-
               tion.

     If the _m_o_d_e and _c_o_m_m_a_n_d arguments are  not  specified,  then
     any  previously  specified  _c_o_m_m_a_n_d  for the given _f_i_l_e_I_d is
     deleted.  Specifying a new  _c_o_m_m_a_n_d  using  the  filehandler



Sun Release 4.1           Last change:                          1






filehandler(1)           USER COMMANDS             filehandler(1)



     command  will  also  delete any previously specified _c_o_m_m_a_n_d
     for a _f_i_l_e_I_d.

SEE ALSO
     Tcl-DP, select(2)

AUTHOR
     Pekka Nikander, Telecom Finland (Pekka.Nikander@ajk.tele.fi)
     Extended by Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
     Further enhancements by Brian Smith (bsmith@cs.berkeley.edu)
     and Steve Yen (syen@cs.berkeley.edu)












































Sun Release 4.1           Last change:                          2



