/*
 * COPYRIGHT (C) DWH
 * Modified by SG
 * Compile directions: 
 * cc machineIdleTime.c -lrpcsvc -Bstatic -o machineIdleTime
 */
#include <stdio.h>
#include <utmp.h>		/* Look at these two include files if you */
#include <rpcsvc/rusers.h>	/* want some more information of what the */
				/* structures used in this program 	  */
				/* actually do  (located in /usr/include) */
main(argc, argv)
int argc;
char *argv[];
{
    char host_name[120];	/* the machine to look on, eg. fsb, fsc, etc*/
    char line_name[120];	/* the line to look at eg console, tty1, etc*/
    int  idletime;
    struct utmpidlearr up;	/* where rusers puts the information	*/
    int numb_users;		/* the number of users logged on */

    if (argc >= 2) 
        strcpy (host_name,argv[1]);
    else 
        strcpy (host_name, "localhost");

    if (argc >= 3) 
        strcpy (line_name,argv[2]);
    else 
        strcpy (line_name, "console");
    rusers(host_name, &up);
    
    if (up.uia_cnt <= 0) 
	idletime = -1;
    else
	idletime = get_idle (up.uia_cnt, up.uia_arr, line_name); 
    printf ("%d\n", idletime);
    exit (0);
}

/* Print the statics of each user */
int
get_idle (numb_users, ip, line_name)
register int numb_users;
struct utmpidle **ip;		/* this actually contains info for each user */
char *line_name;
{
    while( --numb_users >= 0 )  {	/* For each user, ... 	*/
        if ( strcmp ( (*ip)->ui_utmp.ut_line, line_name) == 0)  
	    return ((*ip)->ui_idle);
        ip++;
    }
    return (-1);
}
    
