/* global.h - global definitions
***************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.
******************************************************************************


Written by: Don Libes, NIST, 2/6/90
Modified by: Mark Weissman 9/92

Design and implementation of this program was paid for by U.S. tax
dollars.  Therefore it is public domain.  However, the author and NIST
would appreciate credit if this program or parts of it are used.
*/

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

/* MDW: Mon Jun 22 14:38:47 1992 */
#ifndef mS_PER_SEC
#define mS_PER_SEC      (1000L)
#endif
#ifndef uS_PER_mS
#define uS_PER_mS       (1000L)
#endif
#ifndef uS_PER_SEC
#define uS_PER_SEC      (1000000L)
#endif
#ifndef NS_PER_mS
#define NS_PER_mS	(NS_PER_SEC/mS_PER_SEC)
#endif

#ifndef TIME_INFINITY
#define TIME_INFINITY	-1.0
#endif
/* MDW: Mon Jun 22 14:38:47 1992 */

extern char *sys_errlist[];
int errno;	/* some but not all systems require this */

/* if you get errors from the compiler here, add -DNOSTDLIB to Makefile */
#ifdef NOSTDLIB
	char* malloc();
	char* realloc();
#ifndef _TCLINT
	void exit();
#endif
#else
#include <stdlib.h>
#endif

/* yes, I have a weak mind */
#define streq(x,y)	(0 == strcmp((x),(y)))

#ifdef NO_MEMCPY
#define memcpy(x,y,len) bcopy(y,x,len)
#endif

#ifndef TERM
#  ifdef POSIX
#    define TERM termios
#  endif
#endif

#ifndef TERM
#  ifdef SYSV3
#    ifdef HPUX
#      define TERM termio
#    else
#      define TERM termios
#    endif
#  else
#      define TERM sgttyb
#  endif
#endif

typedef struct TERM exp_tty;

char *cook();
char *printify();
#define dprintify(x)	((is_debugging || debugfile)?printify(x):0)
/* in circumstances where "debuglog(printify(...))" is written, call */
/* dprintify instead.  This will avoid doing any formatting that would */
/* occur before debuglog got control and decided not to do anything */
/* because (is_debugging || debugfile) was false. */

void Log();
void errorlog();
void exp_debuglog();
void nflog();
void nferrorlog();
void tty_raw();
void tty_echo();
void tty_set();
void flush_streams();
void bye();

#ifdef _TCL
extern Tcl_Interp *interp;
#endif

extern FILE *cmdfile;
extern FILE *debugfile;
extern FILE *logfile;

extern int logfile_all;
extern int loguser;

extern int is_debugging;	/* useful to know for avoid debug calls */

/* yet more TCL return codes */
/* Tcl does not safely provide a way to define the values of these, so */
/* use ridiculously numbers for safety */
#define TCL_CONTINUE_EXPECT	-101	/* continue expect command itself */
#define TCL_RETURN_TCL		-102	/* converted by interact, interpeter */
					/* from "return -tcl" into TCL_RETURN */
typedef void (**VoidFuncArray)();	/* MDW: Mon Jun 22 15:30:03 1992 */
