#!/usr/tcl/bin/wish -f
# Program: tcltest
# Tcl version: 6.7 (Tcl/Tk/XF)
# Tk version: 3.2
# XF version: 2.2
#


# module inclusion
global env
global xfLoadPath
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) /usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):/usr/local/lib/
  } {
    set xfLoadPath /usr/local/lib/
  }
} {
  set xfLoadPath /usr/local/lib/
}

global argc
global argv
global tkVersion
global xfLoadInfo
global xfLoadPath
set xfLoadInfo 0
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfstartup} {
      incr counter 1
      source [lindex $argv $counter]
    }
    {-xfbindfile} {
      incr counter 1
      set env(XF_BIND_FILE) "[lindex $argv $counter]"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfmodelmono} {
      if {$tkVersion >= 3.0} {
        tk colormodel . monochrome
      }
    }
    {-xfmodelcolor} {
      if {$tkVersion >= 3.0} {
        tk colormodel . color
      }
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . ""
  wm sizefrom . user
  wm geometry . 306x112
  wm maxsize . 1152 900
  wm minsize . 0 0


  # build widget .frame5
  frame .frame5 \
    -borderwidth {2}\
    -relief {raised}

  # build widget .frame5.frame1
  frame .frame5.frame1 \
    -borderwidth {2}

  # build widget .frame5.frame1.entry2
  entry .frame5.frame1.entry2 \
    -borderwidth {1}\
    -insertborderwidth {1}\
    -relief {sunken}\
    -textvariable {var2}

  # build widget .frame5.frame1.label3
  label .frame5.frame1.label3 \
    -borderwidth {1}\
    -text {var2}

  # pack widget .frame5.frame1
  pack append .frame5.frame1 \
    .frame5.frame1.label3 {left frame sw} \
    .frame5.frame1.entry2 {left frame center expand fillx} 

  # build widget .frame5.frame4
  frame .frame5.frame4 \
    -borderwidth {2}

  # build widget .frame5.frame4.entry2
  entry .frame5.frame4.entry2 \
    -borderwidth {1}\
    -insertborderwidth {1}\
    -relief {sunken}\
    -textvariable {var1}

  # build widget .frame5.frame4.label3
  label .frame5.frame4.label3 \
    -borderwidth {1}\
    -text {var1}

  # pack widget .frame5.frame4
  pack append .frame5.frame4 \
    .frame5.frame4.label3 {left frame sw} \
    .frame5.frame4.entry2 {left frame center expand fillx} 

  # pack widget .frame5
  pack append .frame5 \
    .frame5.frame4 {top frame center expand fillx} \
    .frame5.frame1 {top frame center expand fillx} 

  # build widget .frame6
  frame .frame6 \
    -borderwidth {2}\
    -relief {raised}

  # build widget .frame6.menubutton0
  menubutton .frame6.menubutton0 \
    -borderwidth {1}\
    -menu {.frame6.menubutton0.m}\
    -text {Create-Options}

  # build widget .frame6.menubutton0.m
  menu .frame6.menubutton0.m \
    -borderwidth {1}
  .frame6.menubutton0.m add radiobutton\
    -label {Non modal}\
    -value {non_modal}\
    -variable {mode}
  .frame6.menubutton0.m add radiobutton\
    -label {Waiting}\
    -value {waiting}\
    -variable {mode}
  .frame6.menubutton0.m add radiobutton\
    -label {Modal}\
    -value {modal}\
    -variable {mode}

  # build widget .frame6.menubutton5
  menubutton .frame6.menubutton5 \
    -borderwidth {1}\
    -menu {.frame6.menubutton5.m}\
    -text {Window}\
    -underline {0}

  # build widget .frame6.menubutton5.m
  menu .frame6.menubutton5.m \
    -borderwidth {1}
  .frame6.menubutton5.m add command\
    -command {new_win $mode}\
    -label {New}
  .frame6.menubutton5.m add command\
    -command {close_win}\
    -label {Close}\
    -underline {0}
  .frame6.menubutton5.m add command\
    -command {exit 0}\
    -label {Quit}\
    -underline {0}

  # pack widget .frame6
  pack append .frame6 \
    .frame6.menubutton5 {left frame w} \
    .frame6.menubutton0 {left frame w} 

  # build widget .frame7
  frame .frame7 \
    -borderwidth {2}\
    -relief {raised}

  # build widget .frame7.button1
  button .frame7.button1 \
    -borderwidth {1}\
    -command {print $var1 $var2}\
    -text {Print}

  # build widget .frame7.button6
  button .frame7.button6 \
    -borderwidth {1}\
    -command {defaults}\
    -text {Defaults}

  # build widget .frame7.button7
  button .frame7.button7 \
    -borderwidth {1}\
    -command {eval $var1}\
    -text {Exec $var1}

  # build widget .frame7.button8
  button .frame7.button8 \
    -borderwidth {1}\
    -command {donnot}\
    -text {Don't press}

  # pack widget .frame7
  pack append .frame7 \
    .frame7.button6 {left frame center padx 10 pady 10 expand} \
    .frame7.button1 {left frame center padx 10 pady 8 expand} \
    .frame7.button8 {left frame center padx 10 pady 10 expand} \
    .frame7.button7 {left frame center padx 10 pady 10 expand} 

  # pack widget .
  pack append . \
    .frame6 {top frame w expand fill} \
    .frame5 {top frame center expand fill} \
    .frame7 {top frame center fill} 

  if {"[info procs XFEdit]" != ""} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .xfPackingToplevel
  }

  global tkVersion
  if {$tkVersion >= 3.0} {
    tk_menuBar .frame6 .frame6.menubutton5
  } {
    tk_menus . .frame6.menubutton5
  }

  .frame5.frame1.entry2 insert end {}
  .frame5.frame4.entry2 insert end {}


}


# User defined procedures


# Internal procedures


# Procedure: Alias
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: MenuPopupAdd
if {"[info procs MenuPopupAdd]" == ""} {
proc MenuPopupAdd { xfW xfButton xfMenu {xfModifier ""} {xfCanvasTag ""}} {
# xf ignore me 7
# the popup menu handling is from (I already gave up with popup handling :-):
#
# Copyright 1991,1992 by James Noble.
# Everyone is granted permission to copy, modify and redistribute.
# This notice must be preserved on all copies or derivates.
#
##########
# Procedure: MenuPopupAdd
# Description: attach a popup menu to widget
# Arguments: xfW - the widget
#            xfButton - the button we use
#            xfMenu - the menu to attach
#            {xfModifier} - a optional modifier
#            {xfCanvasTag} - a canvas tagOrId
# Returns: none
# Sideeffects: none
##########

  if {"$xfModifier" != ""} {
    set xfPressModifier "$xfModifier-"
    set xfMoveModifier "$xfModifier-"
    set xfReleaseModifier "Any-"
  } {
    set xfPressModifier ""
    set xfMoveModifier ""
    set xfReleaseModifier ""
  }

  if {"$xfCanvasTag" == ""} {
    if {[catch "bind $xfW \"<${xfPressModifier}ButtonPress-$xfButton>\"                   \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "bind $xfW \"<${xfMoveModifier}B$xfButton-Motion>\"                   \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "bind $xfW \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"                   \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  } {
    if {[catch "$xfW bind $xfCanvasTag \"<${xfPressModifier}ButtonPress-$xfButton>\"                   \"$xfMenu post %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    if {[catch "$xfW bind $xfCanvasTag \"<${xfMoveModifier}B$xfButton-Motion>\"                   \"MenuPopupHandle $xfMenu %W %X %Y\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
    # we need these to counteract the effects of passive grabs :-(
    if {[catch "$xfW bind $xfCanvasTag \"<${xfReleaseModifier}ButtonRelease-$xfButton>\"                   \"$xfMenu invoke active; $xfMenu unpost\"" xfResult]} {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "$xfResult"
      } {
        puts stdout "$xfResult"
      }
      return
    }
  }
}
}


# Procedure: MenuPopupHandle
if {"[info procs MenuPopupHandle]" == ""} {
proc MenuPopupHandle { xfMenu xfW xfX xfY} {
# xf ignore me 7
##########
# Procedure: MenuPopupHandle
# Description: handle the popup menus
# Arguments: xfMenu - the menu to attach
#            xfW - the widget
#            xfX - the root x coordinate
#            xfY - the root x coordinate
# Returns: none
# Sideeffects: none
##########

  if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
    set xfPopMinX [winfo rootx $xfMenu]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfMenu]]
    if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
      $xfMenu activate @[expr $xfY-[winfo rooty $xfMenu]]
    } {
      $xfMenu activate none
    }
  }
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}



# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      set list [split $line ":"]
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        set xfAppDefaults($widname:[string tolower $name]) $value
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {xfClasses {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env

  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      append xfFileList [split $env(XUSERFILESEARCHPATH) :]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      append xfFileList [split $env(XAPPLRESDIR) :]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      append xfFileList [split $env(XFILESEARCHPATH) :]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter [array names xfAppDefaults] {
    if {[string match "${xfWidgetPath}*" $xfCounter]} {
      set widname [string range $xfCounter 0 [expr [string first : $xfCounter]-1]]
      set name [string range $xfCounter [expr [string first : $xfCounter]+1] end]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"]} {
            catch "$widget configure -[string tolower $name] $xfAppDefaults($xfCounter)" 
          }
        }
      }
    }
  }
}


# prepare auto loading
global auto_path
global tk_library
global xfLoadPath
set auto_path "[split $xfLoadPath :] $tk_library [info library]"

# initialize global variables
proc InitGlobals {} {
  global {VARIA}
  set {VARIA} {}
  global {mode}
  set {mode} {non_modal}
  global {var1}
  set {var1} {}
  global {var2}
  set {var2} {}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(tcltest.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(tcltest.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {.}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals
# display/remove toplevel windows.
ShowWindow.
# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# parse and apply application defaults.
XFLocalLoadAppDefs Tcltest
XFLocalSetAppDefs

# eof
#

