class PRINT_CMD
	-- command to print values of a TCL_OBJ

inherit 
    TCL_COMMAND;

creation
    make

feature
    model :TCL_OBJ;
	-- object on which to execute this command.

    make (a_model :TCL_OBJ) is
	do
	    model := a_model
	end;

    execute is
	-- print variable values as well as arguments passed from tcl.
	local
	    args : ARRAY [STRING];
	    i : INTEGER;
	do
	    model.from_tcl;
	    io.putstring("var1 = ");
	    io.putstring(model.var1);
	    io.putstring("%Nvar2 = ");
	    io.putstring(model.var2);
	    io.new_line;
	    from 
		args := current_tcl_args;
		i := args.lower;
	    until
		i > args.upper
	    loop
		io.putstring("Arg = ");
		io.putstring(args.item(i));
		io.new_line;
		i := i+1;
	    end;
	end; -- execute;

end -- class PRINT_CMD
