/*
 * This is a collection of procedures designed to be compiled as a shared
 * library and used to test the dynamic loading operation of the load
 * command.
 * 
 * Tcl and Tk are Copyright (c) 1990-1993 The Regents of the University of
 * California.  All rights reserved.
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include <tcl.h>
#include <tk.h>
#include <sys/time.h>

extern void      Tcl_AppendResult _ANSI_ARGS_(VARARGS);
extern Tk_Window Tk_MainWindow _ANSI_ARGS_((Tcl_Interp *interp));
extern void	 Tcl_CreateCommand _ANSI_ARGS_((Tcl_Interp *interp,
						char *cmdName, 
						Tcl_CmdProc *proc,
						ClientData clientData,
						Tcl_CmdDeleteProc *deleteProc));

/*
 * This TCL command returns a random number.
 */
int
  RandNumCmd(junk,interp,argc,argv)
ClientData junk;
Tcl_Interp *interp;
int        argc;
char       **argv;
{
  int num;

  if (argc != 2) {
    Tcl_AppendResult(interp, "Wrong # args: should be \"", argv[0], 
		     "num\"", (char *) NULL);
    return TCL_ERROR;
  }
  num = rand()%atoi(argv[1]); 
  interp->result = (char *) malloc(100);
  sprintf(interp->result, "%d", num);
  return TCL_OK;
}

/*
 * This tcl command sets all of the applications windows' cursors to
 * the state indicated (wait or normal).
 */
int
    SetCursorCmd(junk, interp, argc, argv)
ClientData junk;
Tcl_Interp *interp;
int argc;
char **argv;
{
    int wait_mode;
    Tk_Window mainWindow;
    static Window busyWindow = (Window) -1;
    
    mainWindow = Tk_MainWindow(interp);

    if (argc != 2) {
	Tcl_AppendResult(interp, "Wrong # args: should be \"", argv[0],
			 " wait|normal\"", (char *) NULL);
	return TCL_ERROR;
    }
    if (!strcmp(argv[1], "wait")) {
      printf("Wait mode is for waiting.\n");
	wait_mode = 1;
    } else {
	wait_mode = 0;
    }
    if (busyWindow == (Window) -1) {
	XSetWindowAttributes attr;
	unsigned long valuemask;

	printf("Making new busyWindow\n");
	valuemask = CWDontPropagate | CWCursor;
	attr.do_not_propagate_mask = (ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	attr.cursor = XCreateFontCursor(Tk_Display(mainWindow), XC_watch);
	busyWindow = XCreateWindow(Tk_Display(mainWindow), 
				 Tk_WindowId(mainWindow), 0, 0,
				 3000, 3000, (unsigned int) 0, 
				 CopyFromParent, InputOnly,
				 CopyFromParent, valuemask, &attr);
    }
    if (wait_mode) {
	XMapRaised(Tk_Display(mainWindow), busyWindow);
    } else {
	XUnmapWindow(Tk_Display(mainWindow), busyWindow);
    }
    XFlush(Tk_Display(mainWindow));
    
    return TCL_OK;
}


int
  testlib_Install(Tcl_Interp *interp)
{
  /* Seed the random number generator */
  /* This is where you would do things like seed your random number
   * generator or any other kind of initialization.  But since this is
   * a basic test, I'll skip the seeding, since it might force those on
   * some platforms to have to make changes here, and I would prefer to
   * avoid that.
   */
  /*  srand(time()); */
  Tcl_CreateCommand(interp, "rand", RandNumCmd, 
		    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  Tcl_CreateCommand(interp, "set_cursor", SetCursorCmd, 
		    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  return TCL_OK;
}

