#
#------------------------------------------------------------------------------
#  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
#
#  Permission to use, copy, modify, and distribute this software and its
#  documentation for any purpose and without fee is hereby granted, provided
#  that the "Terms and Conditions of Distribution", given in the documentation
#  to this software, are applicable and the above copyright message appears in
#  each copy.
#
#------------------------------------------------------------------------------
#
#
#  13.12.1993   hp      1st version
#
#  Simple Tcl script for displaying a window containing a message and two 
#  pushbuttons, "yes" and "no". If the user selects "yes" the script returns
#  an exit code of zero, otherwise inequal zero.
#

wm geometry . 600x300
wm title . "Please press Yes or No"
frame .f -bd 2
button .f.yes -text "Yes" -command "exit 0" -width 20
button .f.no -text "No" -command "exit 1" -width 20
text .text -relief sunken -bd 2
pack .f -side bottom -fill x -expand true
pack .text -side top -fill both -expand true
pack .f.yes -side left
pack .f.no -side right
foreach arg $argv {
  .text insert end $arg
  .text insert end "\n"
}
.text configure -state disabled
tkwait visibility .
grab set -global .
