#
#------------------------------------------------------------------------------
#  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
#
#  Permission to use, copy, modify, and distribute this software and its
#  documentation for any purpose and without fee is hereby granted, provided
#  that the "Terms and Conditions of Distribution", given in the documentation
#  to this software, are applicable and the above copyright message appears in
#  each copy.
#
#------------------------------------------------------------------------------
#
#
#  13.12.1993   hp      1st version
#
#  Simple script for Tcl to edit a list.
#




#  check the arguments  #

if {$argc < 1} {
  puts stdout "Syntax is: $argv0 Message ?Message ....? ?-dir ListEntry ....?
  exit 1
}
set message $argv
set listOfDirs ""
set index 0
foreach arg $argv {
  if {$arg == "-dir"} {
    set listOfDirs [lreplace $argv 0 $index]
    set message [lreplace $argv $index [llength $argv]]
    break
  }
  incr index
}


#  create the window  #

wm title . List
wm geometry . 600x400
frame .f1 -bd 2
frame .f2 -bd 2
frame .f3 -bd 8
frame .f4 -bd 8
scrollbar .f1.v -orient vertical -bd 2 -command ".f1.t yview"
text .f1.t -width 80 -height 6 -relief sunken -bd 2 \
	   -yscrollcommand ".f1.v set"
scrollbar .f2.v -orient vertical -bd 2 -command ".f2.l yview"
scrollbar .f2.h -orient horizontal -bd 2 -command ".f2.l xview"
listbox .f2.l -relief sunken -geometry 80x10 -bd 2 \
	      -yscrollcommand ".f2.v set" \
	      -xscrollcommand ".f2.h set"
tk_listboxSingleSelect .f2.l
label .f3.l -text "Edit" -relief raised -bd 2
entry .f3.e -relief sunken -bd 2 -width 60
button .f4.ok -text "Ok"
button .f4.insert -text "Insert"
button .f4.delete -text "Delete"
pack .f1 .f2 .f3 .f4 -side top -fill x
pack .f1.v .f1.t -side left -fill y
pack .f2.h -side bottom -fill x
pack .f2.v .f2.l -side left -fill y
pack .f3.l -side left
pack .f3.e -side right
pack .f4.ok .f4.insert .f4.delete -side left


#  configure the text and listbox widgets  #

foreach line $message {
  .f1.t insert end $line
  .f1.t insert end "\n"
}
.f1.t configure -state disabled
foreach dir $listOfDirs {
  .f2.l insert end $dir
}


#  set up bindings for the buttons, the entry and the listbox  #

bind .f2.l <ButtonPress-1> {
  .f2.l select clear;
  set index [.f2.l nearest %y];
  if {$index != ""} {
    set currentSelection $index;
    .f2.l select from $index;
    .f2.l select to $index
  }
}
bind .f2.l <ButtonRelease-1> {
  .f3.e delete 0 end;
  set curSel [.f2.l curselection];
  if {$curSel != ""} {
    .f3.e insert 0 [.f2.l get $curSel]
  }
}
.f4.insert configure -command {
  set entry [.f3.e get]
  if {$entry != ""} {
    if {[catch {.f2.l insert $currentSelection $entry}] != 0} {
      .f2.l insert end $entry
    }
  }
}
.f4.delete configure -command {
  set curSel [.f2.l curselection]
  if {$curSel != ""} {
    .f2.l delete $curSel $curSel
  }
}
.f4.ok configure -command {
  set output ""
  for {set i 0} {$i < [.f2.l size]} {incr i} {
    if {$output == ""} then {
      set output "[.f2.l get $i]"
    } else {
	set output "$output [.f2.l get $i]"
      }
  }
  puts stdout $output
  exit 0
}
