/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  This file contains all Xt/Motif related stuff of
 *  the sample application for demonstrating the use of the CTAXT interface
 *
 *  13.12.1993   hp      1st version
 *  14.01.1994   hp      corrected forward-references for functions
 *                       activateNoButton() and activateYesButton()
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/Form.h>
#include <Xm/MainW.h>
#include <ctaxt.h>




/*  
 *  module globals
 */

static Display *display;
static Window  window;
static Widget appMainShell,dialogBox;
static int openDialog = 0;




/*
 *  function prototypes
 */

int centreRectangle _ANSI_ARGS_((Display *display,Window tkParent));
static
void activateButton _ANSI_ARGS_((Widget button,
				 XtPointer clientData,
				 XtPointer callbackArg));
static
void activateYesButton _ANSI_ARGS_((Widget button,
				    XtPointer clientData,
				    XtPointer callbackArg));
static
void activateNoButton _ANSI_ARGS_((Widget button,
				   XtPointer clientData,
				   XtPointer callbackArg));




/*
 *  callback function for the button, simply invokes centreRectangle()
 */

static void     
activateButton (button,clientData,callbackArg)
  Widget button;
  XtPointer clientData,callbackArg;
{
  centreRectangle (display,window);
}


/*
 *  callback function for the no-button, simply destroys the dialog shell
 */

static void     
activateNoButton (button,clientData,callbackArg)
  Widget button;
  XtPointer clientData,callbackArg;
{
  XtDestroyWidget (dialogBox);
  openDialog = 0;
}


/*
 *  callback function for the yes-button, corrects the command binding in
 *  the Tcl interpreter and destroys the dialog shell
 */

static void     
activateYesButton (button,clientData,callbackArg)
  Widget button;
  XtPointer clientData,callbackArg;
{
  Tcl_Interp *interp = (Tcl_Interp *) clientData;


  Tcl_Eval (interp,
	    ".canvas bind rectangle <1> { set mouseX %x; set mouseY %y }");
  XtDestroyWidget (dialogBox);
  openDialog = 0;
}


/*
 *  function for creating the main gui of the sample application
 */

int
createApplicationWorld (d,mainWin,topWin,tkParent1,tkParent2,tkParent3,entry)
  Display **d;
  Window *mainWin,*topWin,*tkParent1,*tkParent2,*tkParent3;
  Widget *entry;
{
  XtAppContext appContext;
  Widget mainShell,main,topShell;
  Widget form,form1,form2,form3,button;
  int screen;


  /*  Register the default language procedure  */

  XtSetLanguageProc (NULL,(XtLanguageProc) NULL,NULL);

  /*  Initialize the Xt Intrinsics  */

  appMainShell = XtAppInitialize (&appContext,
				  "CTAXTexample",
				  NULL, 
				  0,
				  0,
				  NULL, 
				  NULL, 
				  NULL, 
				  0);
  display = XtDisplay (appMainShell);
  screen = XDefaultScreen (display);
  XtVaSetValues(appMainShell,
		XtNx,0,
		XtNy,0,
		XtNwidth,DisplayWidth (display,screen),
		XtNheight,DisplayHeight (display,screen),
		NULL);

  /*  create the main window  */

  mainShell = XtVaCreatePopupShell ("mainShell",
				    topLevelShellWidgetClass,appMainShell,
				    XmNx,109,
				    XmNy,31,
				    XmNwidth,662,
				    XmNheight,420,
				    XmNshellUnitType,XmPIXELS,
				    XmNtitle,"CTAXT - Sample Application",
				    XmNiconName,"CTAXT",
				    NULL);
  main = XtVaCreateManagedWidget ("main",
				  xmMainWindowWidgetClass,mainShell,
				  XmNheight,420,
				  XmNwidth,662,
				  XmNunitType,XmPIXELS,
				  NULL);

  /*  create the different forms and the pushbutton and entryfield for the 
      main window  */

  form = XtVaCreateManagedWidget ("form",
				  xmFormWidgetClass,
				  main,
				  NULL);
  *entry = XtVaCreateManagedWidget ("entry",
				    xmTextFieldWidgetClass,
				    form,
				    XmNheight,50,
				    XmNwidth,210,
				    XmNy,350,
				    XmNx,430,
				    NULL);
  button = XtVaCreateManagedWidget ("button",
				    xmPushButtonWidgetClass,
				    form,
				    XtVaTypedArg,XmNlabelString,
				    XmRString,"Centre Rectangle",
				    strlen("Centre Rectangle")+1,
				    XmNheight,50,
				    XmNwidth,140,
				    XmNy,350,
				    XmNx,20,
				    NULL);
  XtAddCallback (button,
		 XmNactivateCallback,
		 activateButton,
		 (XtPointer) NULL);
  form2 = XtVaCreateManagedWidget ("form2",
				   xmFormWidgetClass, 
				   form,
				   XmNbottomWidget,button,
				   XmNtopAttachment,XmATTACH_NONE,
				   XmNrightAttachment,XmATTACH_FORM,
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNbottomAttachment,XmATTACH_WIDGET,
				   XmNheight,200,
				   XmNwidth,662,
				   XmNy,150,
				   XmNx,0,
				   XmNborderWidth,2,
				   XmNresizePolicy,XmRESIZE_NONE,
				   NULL);
  form1 = XtVaCreateManagedWidget ("form1",
				   xmFormWidgetClass, 
				   form,
				   XmNtopAttachment,XmATTACH_FORM,
				   XmNrightAttachment,XmATTACH_FORM,
				   XmNleftAttachment,XmATTACH_FORM,
				   XmNbottomWidget,form2,
				   XmNbottomAttachment,XmATTACH_WIDGET,
				   XmNheight,100,
				   XmNwidth,100,
				   XmNy,20,
				   XmNx,20,
				   XmNborderWidth,2,
				   XmNresizePolicy,XmRESIZE_NONE,
				   NULL);
  XmMainWindowSetAreas (mainShell,(Widget) NULL,(Widget) NULL,
			(Widget) NULL,(Widget) NULL,form);

  /*  display the main window  */

  XtPopup (mainShell,XtGrabNone);

  /*  create the toplevel window  */

  topShell = XtVaCreatePopupShell ("topShell",
				   topLevelShellWidgetClass,appMainShell,
				   XmNheight,220,
				   XmNwidth,380,
				   XmNy,120,
				   XmNx,130,
				   NULL);

  /*  create the form for the toplevel window  */

  form3 = XtVaCreateManagedWidget ("form3",
				   xmFormWidgetClass,topShell,
				   XmNheight,216,
				   XmNwidth,376,
				   XmNy,0,
				   XmNx,0,
				   XmNborderWidth,2,
				   XmNunitType,XmPIXELS,
				   XmNresizePolicy,XmRESIZE_NONE,
				   NULL);


  /*  display the toplevel window  */

  XtPopup (topShell,XtGrabNone);


  /*  get the X window ids  */

  *d = display;
  *mainWin = XtWindow (mainShell);
  *topWin = XtWindow (topShell);
  *tkParent1 = XtWindow (form1);
  *tkParent2 = XtWindow (form2);
  *tkParent3 = XtWindow (form3);


  /*  needed by the  pushbutton activate callback  */

  window = *tkParent3;


  return (0);
}


/*
 *  function for displaying a yes/no box with a message
 */

int
yesNoBox (interp)
  Tcl_Interp *interp;
{
  Widget form,text,yes,no;


  /*
   *  Since the exclusive grab to the Xt dialog box can't prevent the user
   *  from controlling Tk widgets, check, if there is already a dialog box
   *  on the screen!
   */

  if (openDialog) {
    return (0);
  }
  openDialog = 1;

  /*  create the dialog window as a toplevel window  */

  dialogBox = XtVaCreatePopupShell ("dialogBox",
				    topLevelShellWidgetClass,appMainShell,
				    XmNheight,270,
				    XmNwidth,535,
				    XmNy,163,
				    XmNx,94,
				    NULL);

  /*  create the form for the dialog box window  */

  form = XtVaCreateManagedWidget ("form",
				  xmFormWidgetClass,dialogBox,
				  XmNheight,270,
				  XmNwidth,535,
				  XmNy,200,
				  XmNx,0,
				  XmNunitType,XmPIXELS,
				  XmNresizePolicy,XmRESIZE_NONE,
				  NULL);

  /*  create the text widget  */

  text = XtVaCreateManagedWidget ("text",
				  xmTextWidgetClass,form,
				  XmNvalue,interp->result,
				  XmNheight,190,
				  XmNwidth,520,
				  XmNy,10,
				  XmNx,10,
				  NULL);

  /*  create the yes-button  */

  yes = XtVaCreateManagedWidget ("yes",
				 xmPushButtonWidgetClass,form,
				 XtVaTypedArg,XmNlabelString,
				 XmRString,"Yes",
				 strlen("Yes")+1,
				 XmNheight,50,
				 XmNwidth,110,
				 XmNy,210,
				 XmNx,20,
				 NULL);
  XtAddCallback (yes,
		 XmNactivateCallback,
		 activateYesButton,
		 (XtPointer) interp);

  /*  create the no button  */

  no = XtVaCreateManagedWidget ("no",
				xmPushButtonWidgetClass,form,
				XtVaTypedArg,XmNlabelString,
				XmRString,"No",
				strlen("No")+1,
				XmNheight,50,
				XmNwidth,110,
				XmNy,210,
				XmNx,400,
				NULL);
  XtAddCallback (no,
		 XmNactivateCallback,
		 activateNoButton,
		 (XtPointer) NULL);

  /*  display the dialog window  */

  XtPopup (dialogBox,XtGrabExclusive);

  return (0);
}
