/*
        Private Colortables for Tcl/Tk 
        Rainer Kliese, 1993,94
        All rights reserved
        There is not warranty or guarantee
        for anything!!!!
        Use it at YOUR OWN RISK !!!!!
*/

// -------------- Comment : 
// All function names and object definitions 
// are starting with TkPC
// which means : Tk Private Colormaps
// ----------------------------------------------
// -------------- m_color.new.c -----------------
// Private Colortable for Tcl/Tk
// No Changes to the source-code of Tcl or Tk 
// These Package is planned as an additional Package

 
//  Headerdatei mit Vorabdeklarationen von Callbacks und Actions 
//  ist c++.h 

#include "allg.h"
#include "c++.h"
#include "tkConfig.h"
#include "tkInt.h"

extern "C" { 
             int TkPC_NewColormap(ClientData clientData,
               Tcl_Interp *interp, int argc, char *argv[]);
             int TkPC_DestroyColormap(ClientData clientData,
               Tcl_Interp *interp, int argc, char *argv[]);
             void TkPC_init_color_package();
             Tk_Window tkpcwindow; 
             int TkPC_class(Visual *visual); 
             extern Tcl_HashTable* TkPC_sorry_nameTable();
             extern Tcl_HashTable* TkPC_sorry_valueTable();

             extern Status TkPC_XFreeColors(Display*, Colormap, unsigned long*,  int, unsigned long);
             extern Status TkPC_XAllocColor(Display *, Colormap, XColor *);
             extern Status TkPC_XAllocNamedColor(Display *, Colormap, char *, XColor *, XColor *);

             extern Status (*TkPC_XFreeColorsDummyPtr)(Display*, Colormap, unsigned long*, int, unsigned long);
             extern Status (*TkPC_XAllocColorDummyPtr)(Display *, Colormap, XColor *);
             extern Status (*TkPC_XAllocNamedColorDummyPtr)(Display *, Colormap, _Xconst char *, XColor *, XColor *);
             typedef struct TkColor {
                 XColor color;               /* Information about this color. */
                 unsigned int magic;         /* Used for quick integrity check on this
                                              * structure.   Must always have the
                                              * value COLOR_MAGIC. */
                 Screen *screen;             /* Screen where this color is valid.  Used
                                              * to delete it. */
                 Colormap colormap;          /* Colormap from which this entry was
                                              * allocated. */
                 Visual *visual;             /* Visual associated with colormap. */
                 int refCount;               /* Number of uses of this structure. */
                 Tcl_HashTable *tablePtr;    /* Hash table that indexes this structure
                                              * (needed when deleting structure). */
                 Tcl_HashEntry *hashPtr;     /* Pointer to hash table entry for this
                                              * structure. (for use in deleting entry). */
             } TkColor;

}

Tcl_HashTable CHashTable;


// ***********************************
// Internal Informations over the used 
// Server and his Capabilities 
// ***********************************
struct TkPC_CmapInfoStructure {
	int screen;        // This is the default screen
	Display *display;  // This is the default display
	Colormap cmap;     // This is the default Colormap
        Tk_Window main;    // This is TkWindow of . 
        Window root;    // This is TkWindow of the root Window 
        Visual *visual;  // Default Visual of this Screen 
        char visual_name[64];
        int depth;         // This is the default depth
        int max_depth;     // This is max_depth for the default visual
        Visual *pseudo_visual; // If != 0 this types are availeble for
        Visual *gray_visual;   // maxdepth
        Visual *direct_visual; //    "
        Visual *true_visual;   //    "
        Visual *scolor_visual; //    "
        Visual *sgray_visual;  //    "
} *tkc;

// ******************************************
// definitionen for class TkPC_object
// ******************************************
// ---------------------------------------------------
// alpha - version of TkPC_object
#include "m_color.new.h"

TkPC_object::TkPC_object(unsigned long *p, Colormap cm, int max, int off)
{
       i_pixels = new unsigned long[max];
       for( int i = 0 ; i < max; i++)
         i_pixels[i] = p[i];
       i_cmap = cm;
       i_max_color = max;
       i_off_color = off;
}

// max : i_pixels [0 <-> off <-> max]
// Number of workentries is max - off !!
void TkPC_object::change_work(unsigned long *p, int max)
{
   int i;
   unsigned long *tmp = new unsigned long[max];
   for( i = 0 ; i < i_off_color; i++)
         tmp[i] = i_pixels[i];
   for( i = i_off_color; i < max; i++)
         tmp[i] = p[i-i_off_color];
   i_max_color = max;
   free(i_pixels);
   i_pixels = tmp;
}

void TkPC_object::change_base(unsigned long *p, int off)
{
   int di = off - i_off_color;
   int i;
   i_max_color += di;
   unsigned long *tmp = new unsigned long[i_max_color];
   for( i = 0 ; i < off; i++)
         tmp[i] = p[i];
   for( i = off; i < i_max_color; i++)
         tmp[i] = i_pixels[i-di];
   i_off_color = off;
   free(i_pixels);
   i_pixels = tmp;
}

TkPC_object::~TkPC_object()
{
       delete []i_pixels;
       i_max_color = 0;
       i_off_color = 0;
       i_cmap = 0;
}

// **************************************************************
// END OF OBJECT DEFINITION
// **************************************************************

extern void TkPC_repair_pixel_order(TkPC_object*, Display*, int, unsigned long*);
extern int TkPC_query_other_colors(Tcl_Interp *interp);
extern void TkPC_get_the_rest(Tcl_Interp *interp, TkPC_object *fp, int *argcRest, unsigned long **restExt);


/* Inititialize Tk Private Colorpackage */
void TkPC_init_color_package()
{
   int i = 0;
   int klasse = 0;

   TkPC_XAllocColorDummyPtr = TkPC_XAllocColor;
   TkPC_XAllocNamedColorDummyPtr = TkPC_XAllocNamedColor;
   TkPC_XFreeColorsDummyPtr = TkPC_XFreeColors;

   Tcl_InitHashTable( &(CHashTable), TCL_STRING_KEYS );
   Tk_Window w = tkpcwindow;
   tkc = new struct TkPC_CmapInfoStructure;
   tkc->main = w;
   tkc->display = Tk_Display(w);
   tkc->screen = DefaultScreen( tkc->display );
   tkc->cmap = DefaultColormap( tkc->display, tkc->screen ) ;
   tkc->root = RootWindowOfScreen(Tk_Screen(tkc->main));
   tkc->visual = XDefaultVisual(tkc->display, tkc->screen);
   klasse =  TkPC_class(tkc->visual);
   tkc->depth = XDefaultDepth( tkc->display, tkc->screen ) ;
   if ( tkc->depth == 1 ) {
      strcpy( tkc->visual_name,"MonoChrom");
   } else if ( klasse == PseudoColor ) {
      strcpy( tkc->visual_name,"PseudoColor");
   } else if ( klasse == GrayScale ) {
      strcpy( tkc->visual_name,"GrayScale");
   } else if ( klasse == DirectColor ) {
      strcpy( tkc->visual_name,"DirectColor");
   } else if ( klasse == TrueColor ) {
      strcpy( tkc->visual_name,"TrueColor");
   } else if ( klasse == StaticColor ) {
      strcpy( tkc->visual_name,"StaticColor");
   } else if ( klasse == StaticGray ) {
      strcpy( tkc->visual_name,"StaticGray");
   } else {
      strcpy( tkc->visual_name,"Unkown VisualClass");
   }

   XVisualInfo vinfo_ret;
   for (i = 48; i > 0; i-=1) {
       if( XMatchVisualInfo(tkc->display, tkc->screen, i, klasse, & vinfo_ret) ) {
         tkc->max_depth = i; i = 0;
       }
   }
   Status result;
   klasse = PseudoColor; 
   result = XMatchVisualInfo(tkc->display, tkc->screen, tkc->max_depth, klasse, & vinfo_ret);
   if ( result )  tkc->pseudo_visual = vinfo_ret.visual;
   else tkc->pseudo_visual = 0;

   klasse = GrayScale; 
   result = XMatchVisualInfo(tkc->display, tkc->screen, tkc->max_depth, klasse, & vinfo_ret);
   if ( result ) tkc->gray_visual = vinfo_ret.visual;
   else tkc->gray_visual = 0;

   klasse = DirectColor; 
   result = XMatchVisualInfo(tkc->display, tkc->screen, tkc->max_depth, klasse, & vinfo_ret);
   if ( result ) tkc->direct_visual = vinfo_ret.visual;
   else tkc->direct_visual = 0;

   klasse = TrueColor; 
   result = XMatchVisualInfo(tkc->display, tkc->screen, tkc->max_depth, klasse, & vinfo_ret);
   if ( result ) tkc->true_visual = vinfo_ret.visual;
   else tkc->true_visual = 0;

   klasse = StaticColor; 
   result = XMatchVisualInfo(tkc->display, tkc->screen, tkc->max_depth, klasse, & vinfo_ret);
   if ( result ) tkc->scolor_visual = vinfo_ret.visual;
   else tkc->scolor_visual = 0;

   klasse = StaticGray; 
   result = XMatchVisualInfo(tkc->display, tkc->screen, tkc->max_depth, klasse, & vinfo_ret);
   if ( result ) tkc->sgray_visual = vinfo_ret.visual;
   else tkc->sgray_visual = 0;

   int isNew = 0;
   Tcl_HashEntry* entry = Tcl_CreateHashEntry(&CHashTable, "default", &isNew);
   if( isNew == 1 ) { // entry does not exist yet -- which is normal here
       TkPC_object *p = Create_TkPC_object_default();
       if (p == 0) {
          Tcl_DeleteHashEntry(entry);
          return ;   
          }
       Tcl_SetHashValue(entry, p);
   } 
}

// *****************************************************
//                 TkPC_NewColormapCB
// *****************************************************
// Task:
// lookup Hashtable for colormap name
// Create or Configure Colormap
int TkPC_NewColormap(ClientData clientData,
               Tcl_Interp *interp, int argc, char *argv[])
{
    int isNew = 0;
    TkPC_object *p = 0;
    Tcl_HashEntry *entry;
    Tcl_HashSearch search;

    if(argc < 2) {
        goto usage;
    }
    // argv[0] : tcl-comando name [Cmap]
    // argv[1] : command 
    // argv[2] : 1st. argument
    // argv[3] : 2nd. argument
    // argv[4] : 2nd. argument
    // usage description:
    // Cmap list
    // Cmap query_tk
    // Cmap query_base cmap
    // Cmap query_work cmap
    // Cmap alloc_work cmap worklist
    // Cmap free_work cmap
    // Cmap store_base worklist
    // Cmap store_work worklist
    // Cmap modeinfo
    // Cmap create cmap mode(default or private)
    // Cmap free (not recommendet to use, will be obsolete in future)

    if ( strcmp(argv[1],"test") == 0 ) {
       // In this version we try to find out, what pixels are 
       // allocated by Tk
       TkPC_query_other_colors(interp);
    } else if( argc == 2 ) { // which means return a list of allraedy defined Maps
       if ( strcmp(argv[1],"list") == 0 ) {
          for( entry = Tcl_FirstHashEntry(&CHashTable, &search); entry != NULL; entry = Tcl_NextHashEntry(&search)) {
            Tcl_AppendElement(interp, Tcl_GetHashKey(&CHashTable,entry));
          }
       } else if ( strcmp(argv[1],"query_tk") == 0) {
          if( TkPC_query_Tk_colors(interp) == 0) goto usage;
       } else if ( strcmp(argv[1],"modeinfo") == 0) {
          char dm[256];

          sprintf(dm,"Depth :%d", tkc->depth);
          Tcl_AppendElement(interp, dm); 
          sprintf(dm,"MaxDepth :%d", tkc->max_depth);
          Tcl_AppendElement(interp, dm); 
          sprintf(dm,"Default Visualtype :%s", tkc->visual_name);
          Tcl_AppendElement(interp, dm); 
          sprintf(dm,"Supportet Visualtypes :");
          if( tkc->pseudo_visual != 0 ) strcat(dm, "pseudo, ");
          if( tkc->direct_visual != 0 ) strcat(dm, "direct, ");
          if( tkc->true_visual != 0 ) strcat(dm, "true, ");
          if( tkc->gray_visual != 0 ) strcat(dm, "gray, ");
          if( tkc->scolor_visual != 0 ) strcat(dm, "static_color, ");
          if( tkc->sgray_visual != 0 ) strcat(dm, "static_gray");
          Tcl_AppendElement(interp, dm); 
       } else { // wrong usage off command Cmap
          goto usage;
       }
    } else if ( argc == 3 ) {
       if ( strcmp(argv[1],"query_base") == 0 ) {
          if ( TkPC_query_base(interp, argv[2]) == 0 ) goto usage;
       } else if ( strcmp(argv[1],"query_work") == 0 ) {
          if ( TkPC_query_work(interp, argv[2]) == 0 ) goto usage;
       } else if ( strcmp(argv[1],"free_work") == 0 ) {
          if ( TkPC_free_work(interp, argv[2]) == 0 ) goto usage;
       } else {
          goto usage;
       } 
    } else if ( argc == 4 ) {
       if ( strcmp(argv[1],"alloc_work") == 0 ) {
          if ( TkPC_alloc_work(interp, argv[2], argv[3]) == 0 ) goto usage;
       } else if ( strcmp(argv[1],"store_work") == 0 ) {
          if ( TkPC_store_work(interp, argv[2], argv[3]) == 0 ) goto usage;
       } else if ( strcmp(argv[1],"store_base") == 0 ) {
          if ( TkPC_store_base(interp, argv[2], argv[3]) == 0 ) goto usage;
       } else if ( strcmp(argv[1],"connect") == 0 ) { // which means connect widget with cmap
         if( (p = TkPC_Find(argv[3])) == 0 ) goto usage_nocmap;
         if ( connect_widget_with_cmap(interp, p, argv[2]) == 0 ) {
            goto usage_nowidget;
         }

       } else if ( strcmp(argv[1],"create") == 0 ) { // which mean create Cmap or
                                                     // change type
         entry = Tcl_CreateHashEntry(&CHashTable, argv[2], &isNew);
         if( isNew == 1 ) { // entry does not exist yet
            p = Create_TkPC_object(interp,argv[3]);
            if (p == 0) {
               Tcl_DeleteHashEntry(entry);
               goto usage_mode; 
            }
            Tcl_SetHashValue(entry, p);
         } else {
            p = (TkPC_object *) Tcl_GetHashValue(entry);
         }
         p->name(argv[2]);
       } else {
         goto usage;
       }
    } else if ( argc == 5 ) {
       if ( strcmp(argv[1],"free") == 0 ) { // Free Cmap Entries
           if( (p = TkPC_Find(argv[2])) == 0 ) goto usage_nocmap;
           free_cmap_entries(p, argv[3], argv[4]);
       } else { // wrong usage off command Cmap
          goto usage;
       }
    } else if ( strcmp(argv[1],"test") == 0 ) {
       // In this version we try to find out, what pixels are 
       // allocated by Tk
       TkPC_query_Tk_colors(interp);
    } else {
        goto usage;
    }

// Make the interpreter happy
    argv += argc;
    return TCL_OK;
usage: 
    Tcl_AppendResult(interp, 
      "wrong number of arguments, should be:\n", 
      "usage description:\n",
      "Cmap list\n",
      "Cmap query_tk\n",
      "Cmap query_base cmap\n",
      "Cmap alloc_work cmap worklist\n",
      "Cmap free_work cmap\n",
      "Cmap store_base cmap worklist\n",
      "Cmap store_work cmap worklist\n",
      "Cmap modeinfo\n",
      "Cmap create cmap mode(default or private)\n",
      "Cmap free cmap off max(not recommendet to use, will be obsolete in future)\n",
      "Cmap connect widget cmap", (char *) 0 ) ;
    argv += argc;
    return TCL_ERROR;
usage_mode: 
    Tcl_AppendResult(interp, 
      "wrong mode, ", argv[2], " should be:\n", 
      "default, stdmap, private, best, truecolor \n", (char *) 0 ) ;
    argv += argc;
    return TCL_ERROR;
usage_nowidget: 
    Tcl_AppendResult(interp, 
      "unkown widget, ", argv[3], (char *) 0 ) ;
    argv += argc;
    return TCL_ERROR;
usage_nocmap: 
    Tcl_AppendResult(interp, 
      "unkown cmap, ", argv[2], (char *) 0 ) ;
    argv += argc;
    return TCL_ERROR;
}

// *****************************************************
//                 TkPC_DestroyColormapCB
// *****************************************************
// Task:
// lookup Hashtable for colormap name
// Delete Colormap and Hashtable Entry
int TkPC_DestroyColormap(ClientData clientData,
               Tcl_Interp *interp, int argc, char *argv[])
{
    if(argc < 2) {
       Tcl_SetResult(interp,"wrong # args, should be: TkColorDestroy CmapName", TCL_STATIC);
       return TCL_ERROR;
    }
    // argv[0] : tcl-comando name
    // argv[1] : CmapName : To be destroyed
    Tcl_HashEntry *entry = 0;
    entry = Tcl_FindHashEntry(&CHashTable, argv[1]);
    if( entry != 0 && strcmp(argv[1],"default") != 0 ) { // Found Colormap
       // Check now all Widgets in the complete Application and 
       // if they use Colormap <$argv[1]> substitute with 
       // default Colormap
       TkPC_object* p = (TkPC_object *) Tcl_GetHashValue(entry);
       TkPC_object* def = TkPC_Find("default");
       if ( def == NULL ) {
          // TkPC not initialized
          Tcl_SetResult(interp,"TkPC Package not initialized now!!\n Repair your Wish Interpreter", TCL_STATIC);
          return TCL_ERROR;
       }
       TkPC_substituteCMAP(interp, p->cmap() , def->cmap());
       Tcl_DeleteHashEntry(entry);
       delete p;
    } else {
       Tcl_SetResult(interp,"You try to delete a non existing Colormap", TCL_STATIC);
       return TCL_ERROR;

    }
// Make the interpreter happy
    argv += argc;
    return TCL_OK;
}

// Search a cmap by widgetname, attention:
// Calling Procedure has to provide enough Memory for cmapname
// Return-Value: == 0 : Failed
//               != 0 : OK
int TkPC_CmapName_by_WidgetName(Tcl_Interp *interp, char *widgetname, char *cmapname)
{
   Tk_Window tkwin = Tk_NameToWindow(interp, widgetname, tkc->main);
   if(tkwin == NULL) { 
      strcpy(cmapname,"");
      return 0; 
   }
   Colormap cmap = Tk_Colormap(tkwin); 
   TkPC_object *p;
   Tcl_HashEntry *entry;
   Tcl_HashSearch search;
   char *name;
   for ( entry = Tcl_FirstHashEntry(&CHashTable, &search); entry != 0; entry = Tcl_NextHashEntry(&search) ) {
       p = (TkPC_object *) Tcl_GetHashValue(entry);
       if( cmap == p->cmap() ) {
          strcpy(cmapname, Tcl_GetHashKey(&CHashTable, entry) );
          return 1;
       }
   } // end of for

   strcpy(cmapname,"");
   return 0;
}

// TkPC_Colormap: returns the Colormap which is connectet with name or NULL
Colormap TkPC_Colormap(char *name)
{
   TkPC_object *p;
   Tcl_HashEntry *entry = 0;
   entry = Tcl_FindHashEntry(&CHashTable, name);
   if( entry != 0 ) {  // Found Colormap
       p = (TkPC_object*) Tcl_GetHashValue(entry);
       return p->cmap(); 
   } 
   return 0;
}


// Search a TkPC_object by name
TkPC_object* TkPC_Find(char *name)
{
    Tcl_HashEntry *entry = 0;
    entry = Tcl_FindHashEntry(&CHashTable, name);
    if( entry != 0 )  // Found Colormap
       return (TkPC_object*) Tcl_GetHashValue(entry);
    else
       return NULL;
}

// Check now all Widgets in the complete Application and 
// if they use Colormap <org> substitute with 
// Colormap <subst>
void TkPC_substituteCMAP(Tcl_Interp *interp, Colormap org, Colormap subst)
{
   Tk_Window tkwin = Tk_NameToWindow(interp, ".", tkc->main);
   if(tkwin == NULL) { 
      return; 
   }
   if( Tk_Colormap(tkwin) == org ) 
       Tk_SetWindowColormap( tkwin, subst);
   Tcl_HashEntry *hPtr;
   Tcl_HashSearch search;
   for ( hPtr = Tcl_FirstHashEntry(&((TkWindow *) tkwin)->mainPtr->nameTable, &search); hPtr != 0; hPtr = Tcl_NextHashEntry(&search) ) {
       if( Tk_Colormap(Tcl_GetHashValue(hPtr)) == org ) {
          Tk_SetWindowColormap( (Tk_Window) Tcl_GetHashValue(hPtr), subst);
       }
   } // end of for
}

TkPC_object* Create_TkPC_object(Tcl_Interp* interp , char *ctype)
{
    TkPC_object *p = 0;
    if ( strcmp(ctype,"default") == 0 ) {
         p = Create_TkPC_object_default();
    } else if ( strcmp(ctype,"private") == 0 ) {
         p = Create_TkPC_object_private();
    } else if ( strcmp(ctype,"stdcmap") == 0 ) {

    } else if ( strcmp(ctype,"notdef1") == 0 ) {

    } else if ( strcmp(ctype,"notdef2") == 0 ) {

    } 
    return p;
}

void free_cmap_entries(TkPC_object *ft, char *off, char *max)
{
   int nlimit = 256; // This restricts the compatabilty of this feature on 8-Bit PseudoColortables
   Display* display = tkc->display;       
   unsigned long *pixels = ft->pixels();
   int off_color = strtol(off, (char **) NULL, 0);
   int max_color = strtol(max, (char **) NULL, 0);  // The values  between 0 - off_color are common 
   if ( off_color > nlimit ) { off_color = nlimit; }  
   if ( max_color > nlimit ) { max_color = nlimit; }
   if( max_color > off_color ) {
      if( strcmp(ft->type(), "default") == 0 ) 
        XFreeColors( display, ft->cmap(), &pixels[off_color], (unsigned int) max_color-off_color, (unsigned long) NULL);
      else 
        XFreeColors( display, ft->cmap(), &pixels[off_color], (unsigned int) max_color-off_color, (unsigned long) 0);
   }
} // end of free private map

TkPC_object* Create_TkPC_object_default()
{
   Colormap cmap = tkc->cmap;
   int screen = tkc->screen;
   unsigned long pixels[2];

   int off_color = 0;
   int max_color = 0;   
   TkPC_object *pco =  new  TkPC_object(pixels, cmap, max_color, off_color);
   pco->type("default");
   return(pco);
} // end of create default map


// ************************************************************
// ************************************************************
// Private Map of Colors
// ************************************************************
// ************************************************************
TkPC_object* Create_TkPC_object_private()
{
   Colormap cmap;
   unsigned long pixels[2];
   int offcolor = 0;
   int maxcolor = 0;  // The values  between 0 - off_color are common 
   cmap = XCreateColormap( tkc->display, tkc->root, tkc->visual, AllocNone); 

   TkPC_object *pco =  new  TkPC_object(pixels, cmap, 2, 0);
   pco->type("private");
   pco->maxcolor(maxcolor);
   pco->offcolor(offcolor);
   return(pco);
} // end of create private map



// *******************************************************************
// *******************************************************************
// Connect the widget tk_path with an given Colormap
// and connect also all Subwidgets with this Colormap
// *******************************************************************
// *******************************************************************
int connect_widget_with_cmap(Tcl_Interp *interp, TkPC_object *ft, char *tk_path) 
{
   Tk_Window tkwin = Tk_NameToWindow(interp, tk_path, tkc->main);
   if(tkwin == NULL) { 
      return 0; 
   }
   Tk_SetWindowColormap( tkwin, ft->cmap() );
   Tcl_HashEntry *hPtr;
   Tcl_HashSearch search;
   char *name;
   int l = strlen(tk_path);
   for ( hPtr = Tcl_FirstHashEntry(&((TkWindow *) tkwin)->mainPtr->nameTable, &search); hPtr != 0; hPtr = Tcl_NextHashEntry(&search) ) {
       l = strlen(tk_path);
       name =  Tcl_GetHashKey( &((TkWindow *) tkwin)->mainPtr->nameTable, hPtr);
       if( strncmp( name, tk_path, l) == 0 ) {
           Tk_SetWindowColormap( (Tk_Window) Tcl_GetHashValue(hPtr), ft->cmap() );
           Tk_SetColorModel( (Tk_Window) Tcl_GetHashValue(hPtr) , TK_COLOR);
       }
   } // end of for
   return 1;
}



int TkPC_query_Tk_colors(Tcl_Interp *interp)
{
    XColor *p;
    TkColor *tkColPtr;
    Tcl_HashEntry *hPtr;
    Tcl_HashSearch search;
    char *line;
    char *sargv[4];
    sargv[0] = new char[32];
    sargv[1] = new char[32];
    sargv[2] = new char[32];
    sargv[3] = new char[32];

    Tcl_HashTable* valueTablePtr = TkPC_sorry_valueTable();

    for ( hPtr = Tcl_FirstHashEntry(valueTablePtr, &search); hPtr != 0; hPtr = Tcl_NextHashEntry(&search) ) {
        tkColPtr = (TkColor *) Tcl_GetHashValue(hPtr);
        p = & (tkColPtr->color);
        sprintf(sargv[0],"%d", p->pixel);
        sprintf(sargv[1],"%d", p->red);
        sprintf(sargv[2],"%d", p->green);
        sprintf(sargv[3],"%d", p->blue);
        line = Tcl_Merge(4, (char **) sargv);
        Tcl_AppendElement(interp, line);
        free(line);
    } // end of for

    Tcl_HashTable* nameTablePtr = TkPC_sorry_nameTable();
    for ( hPtr = Tcl_FirstHashEntry(nameTablePtr, &search); hPtr != 0; hPtr = Tcl_NextHashEntry(&search) ) {
        tkColPtr = (TkColor *) Tcl_GetHashValue(hPtr);
        p = & (tkColPtr->color);
        sprintf(sargv[0],"%d", p->pixel);
        sprintf(sargv[1],"%d", p->red);
        sprintf(sargv[2],"%d", p->green);
        sprintf(sargv[3],"%d", p->blue);
        line = Tcl_Merge(4, (char **) sargv);
        Tcl_AppendElement(interp, line);
        free(line);
    } // end of for


    delete [](sargv[0]);
    delete [](sargv[1]);
    delete [](sargv[2]);
    delete [](sargv[3]);
    return 1;
}
 
int TkPC_query_other_colors(Tcl_Interp *interp)
{

}

// ***************************************************************
// Returns the current off_color index of map CmapName
int TkPC_query_base(Tcl_Interp *interp, char *CmapName)
{
   XColor p;
   TkPC_object *fp;
   fp = TkPC_Find(CmapName);
   if( fp == 0 ) return 0;
   int i = 0;
   char *line;
   char *sargv[4];
   sargv[0] = new char[32];
   sargv[1] = new char[32];
   sargv[2] = new char[32];
   sargv[3] = new char[32];
   
   for(i = 0; i < fp->offcolor(); i++) {
        p.pixel = fp->pixels(i);
        XQueryColor(tkc->display, fp->cmap(), &p);
        sprintf(sargv[0],"%d", p.pixel);
        sprintf(sargv[1],"%d", p.red);
        sprintf(sargv[2],"%d", p.green);
        sprintf(sargv[3],"%d", p.blue);
        line = Tcl_Merge((int)4, (char **) sargv);
        Tcl_AppendElement(interp, line);
        free(line);
   }
   delete [](sargv[0]);
   delete [](sargv[1]);
   delete [](sargv[2]);
   delete [](sargv[3]);
   return 1;
}

// ***************************************************************
// try to allocated ColormapCells descripted by VarName 
// and returns the realy allocated Number of Cells
int TkPC_query_work(Tcl_Interp *interp, char *CmapName)
{

   XColor p;
   TkPC_object *fp = TkPC_Find(CmapName);
   if( fp == 0 ) return 0;
   int i = 0;
   char *line;
   char *sargv[4];
   sargv[0] = new char[32];
   sargv[1] = new char[32];
   sargv[2] = new char[32];
   sargv[3] = new char[32];

   int max = fp->maxcolor();
   for(i = fp->offcolor(); i < max; i++) {
        p.pixel = fp->pixels(i);
        XQueryColor(tkc->display, fp->cmap(), &p);
        sprintf(sargv[0],"%d", p.pixel);
        sprintf(sargv[1],"%d", p.red);
        sprintf(sargv[2],"%d", p.green);
        sprintf(sargv[3],"%d", p.blue);
        line = Tcl_Merge(4, sargv );
        Tcl_AppendElement(interp, line);
        free(line);
   }
   delete [](sargv[0]);
   delete [](sargv[1]);
   delete [](sargv[2]);
   delete [](sargv[3]);
   return 1;
}

// ***************************************************************
// try to allocated ColormapCells descripted by VarName 
// and returns the realy allocated Number of Cells
int TkPC_alloc_work(Tcl_Interp *interp, char *CmapName, char *VarName)
{

   TkPC_object *fp;
   fp = TkPC_Find(CmapName);
   if ( fp == 0 ) return 0;
   Colormap cmap = fp->cmap();
   Display* display = tkc->display;       
   int screen = tkc->screen;
   XColor colors[256]; // This restricts the compatabilty of this feature on 8-Bit PseudoColortables

   Colormap cmap_default = tkc->cmap;
   int listArgc;
   char **listArgv;
   int pixArgc;
   char **pixArgv;
   char *var;
   
   var = Tcl_GetVar(interp,VarName,TCL_LEAVE_ERR_MSG);
   if ( Tcl_SplitList(interp, var, &listArgc, &listArgv) != TCL_OK) return 0;
   int i;
   unsigned long p;
   unsigned short r, g, b;
   int off_color = fp->offcolor();
   int max_color = fp->maxcolor();  // The values  between 0 - off_color are common 
   // If workspace is allready allocated by TkPC, give it free
   if ( max_color > off_color ) {
      XFreeColors( display, cmap, fp->pixels()+off_color, (unsigned int) max_color-off_color, (unsigned long)NULL);
   }
   int l = fp->offcolor();
   unsigned long *pixels = new unsigned long[listArgc+l];
   for ( i = 0 ; i < listArgc; i++ ) {
     if ( Tcl_SplitList(interp, listArgv[i], &pixArgc, &pixArgv) != TCL_OK) return 0;
     if( pixArgc = 0 ) { return 0; }
     p = strtoul(pixArgv[0], (char **) NULL, 0);
     r = strtoul(pixArgv[1], (char **) NULL, 0);
     g = strtoul(pixArgv[2], (char **) NULL, 0);
     b = strtoul(pixArgv[3], (char **) NULL, 0);
     colors[l].flags = DoRed | DoGreen | DoBlue;
     colors[l].red = r; colors[l].green = g; colors[l].blue = b;
     if( XAllocColor(display, cmap, colors+l) == 0 ) {
        break;
     }
     pixels[l] = colors[l].pixel;
     ++l;
     free(pixArgv);
   } 
   char stringresult[64];
   sprintf(stringresult,"%d",i);
   Tcl_SetResult(interp,stringresult,TCL_VOLATILE);
   fp->change_work(&pixels[off_color], l); 
   free (listArgv);
   delete []pixels;
   return 1;
}

// ***************************************************************
// Frees the Colormapcells, which are allocated by TkPC_alloc_work 
int TkPC_free_work(Tcl_Interp *interp, char *CmapName)
{
   TkPC_object *fp;
   fp = TkPC_Find(CmapName);
   if ( fp == 0 ) return 0;
   Colormap cmap = fp->cmap();
   Display* display = tkc->display;       
   int screen = tkc->screen;
   XColor colors[256]; // This restricts the compatabilty of this feature on 8-Bit PseudoColortables

   int off_color = fp->offcolor();
   int max_color = fp->maxcolor(); 
   if ( max_color > off_color ) {
      XFreeColors( display, cmap, fp->pixels()+off_color, (unsigned int) max_color-off_color, (unsigned long)NULL);
   }
   max_color = off_color; 
   unsigned long *pixels = new unsigned long[off_color+1];
   fp->change_work(&pixels[off_color], off_color); 

   delete []pixels;

   return 1;
}

// ***************************************************************
// Set colors between index i ( 0 <= i < off_color )
// this is only allowed for private Colormaps:
// Caution: Programm terminates,
// if You try this with a common, direct or true Colormap
int TkPC_store_base(Tcl_Interp *interp, char *CmapName, char *VarName)
{

   TkPC_object *fp;
   fp = TkPC_Find(CmapName);
   if ( fp == 0 ) return 0;
   Colormap cmap = fp->cmap();
   Display* display = tkc->display;       
   int screen = tkc->screen;
   XColor colors[256]; // This restricts the compatabilty of this feature on 8-Bit PseudoColortables

   if ( strcmp(fp->type(), "private") != 0 ) {
       return 0;
   }

   Colormap cmap_default = tkc->cmap;
   int listArgc;
   char **listArgv;
   int pixArgc;
   char **pixArgv;
   char *var;
   
   var = Tcl_GetVar(interp,VarName,TCL_LEAVE_ERR_MSG);
   if ( Tcl_SplitList(interp, var, &listArgc, &listArgv) != TCL_OK) return 0;
   int i;
   unsigned long p;
   unsigned short r, g, b;
   int off_color = fp->offcolor();
   // Free the old base_part of the colormap
   if ( fp->offcolor() > 0 ) {
      XFreeColors( display, fp->cmap(), fp->pixels(), (unsigned int) fp->offcolor(), 0);
   }

   // allocate the rest of the private map, which should be now everything except
   // the work_array part
   unsigned long *rest;
   int argcRest;
   TkPC_get_the_rest(interp, fp, &argcRest, &rest);

   unsigned long *pixels = new unsigned long[listArgc];
   for ( i = 0 ; i < listArgc; i++ ) {
     if ( Tcl_SplitList(interp, listArgv[i], &pixArgc, &pixArgv) != TCL_OK) return 0;
     if( pixArgc = 0 ) { return 0; }
     p = strtoul(pixArgv[0], (char **) NULL, 0);
     r = strtoul(pixArgv[1], (char **) NULL, 0);
     g = strtoul(pixArgv[2], (char **) NULL, 0);
     b = strtoul(pixArgv[3], (char **) NULL, 0);
     colors[i].flags = DoRed | DoGreen | DoBlue;
     colors[i].red = r; colors[i].green = g; colors[i].blue = b;
     pixels[i] = colors[i].pixel = p;
     free(pixArgv);
   } 
   int length = i;

   fp->change_base(pixels, listArgc); 

   // unfortunatly there is a strong possibilty 
   // that the base_color part uses some pixels of the 
   // work_color part of the table
   TkPC_repair_pixel_order(fp, display, argcRest, rest) ;

   XStoreColors( display, cmap, colors, listArgc);

   free (listArgv);
   delete []pixels;

   char stringresult[64];
   sprintf(stringresult,"%d",i);
   Tcl_SetResult(interp,stringresult,TCL_VOLATILE);
   return 1;

}

// query and alloc the remaining part of the colormap
// The calling Funktion is resposible for freeing the allocated array "restExt"
void TkPC_get_the_rest(Tcl_Interp *interp, TkPC_object *fp, int *argcRest, unsigned long **restExt)
{
   // Theorie:
   // At this point off_color and max_color part are allocated or not
   // The aim is the allocation off all not allocated Maps
   // Never use this function for the TrueColor-mode 
   int rest = 256; // This restricts the compatabilty of this feature on 8-Bit PseudoColortables
   unsigned long *pixels = new unsigned long[rest];
   int i;
   for ( i = 0; i < rest; i++) {
         if( XAllocColorCells( tkc->display, fp->cmap(), (Bool) True, fp->planemask(), 0, &pixels[i], 1) == 0 ) {
             rest = i;
             break;
         }
   }
   *argcRest = rest;
   *restExt = pixels;
} // end of get_the_rest


// The base-color-feature is in conflict with linear private work_maps,
// so I try to give a solution here.
// Attention: there is a price too pay !!!
// Every time you change the base_part of the colortable
// you have to redraw all images wich are using
// the work_array feature off the TkPC_package,
// because this repair_function changes the connection between 
// pixel-values <----> r, g, b triplet in the private Colormap
void TkPC_repair_pixel_order(TkPC_object *fp, Display* display, int argc, unsigned long *freepart) 
{
   // The problem is, that there may be pixel-values in 
   // fp->pixel([0 - (offcolor-1)]) 
   // which are also in fp->pixel([offcolor-maxcolor])
   // this must be changed!!!
   XColor color;
   int off = fp->offcolor();
   int max = fp->maxcolor();
   int freecounter = 0; // must be less than argc at any time !!!
   if ( argc == 0 ) return; // No more free Colorcells 
   int i, j;
   int k=0;
   int p;
   // LookUp List for base_array
   for (i = off; i<max; i++) {
     p = fp->pixels(i);
     for( j = 0; j < off; j++ ) {
       if( p == fp->pixels(j) ) { // this pixel must be changed
          color.pixel = p;
          XQueryColor(display, fp->cmap(), &color);
          color.pixel = freepart[freecounter++];
          if( freecounter >= argc ) {
             return;
          }
          XStoreColor(display, fp->cmap(), &color);
          fp->pixel(i,color.pixel);
          break;
       }
     } 
   }

   // Free All Colors from the remaining rest, except those which are in base_colors
   int flag;
   for ( i = freecounter; i < argc ; i++ ) {
     flag = 1;
     for ( j = 0 ; j < off;  j ++ ) 
        if( fp->pixels(j) == freepart[i] ) flag = 0;
     if ( flag == 1 ) 
        XFreeColors( display, fp->cmap(), &freepart[i], (unsigned int) 1, 0);
   }
}


// ***************************************************************
// Set colors between index i ( 0 <= i < off_color )
// this is only allowed for private Colormaps:
// Caution: Programm terminates,
// if You try this with a common, direct or true Colormap
int TkPC_store_work(Tcl_Interp *interp, char *CmapName, char *VarName)
{

   TkPC_object *fp;
   fp = TkPC_Find(CmapName);
   if ( fp == 0 ) return 0;
   Colormap cmap = fp->cmap();
   Display* display = tkc->display;       
   int screen = tkc->screen;

   if ( strcmp(fp->type(), "private") != 0 ) {
       return 0;
   }

   int listArgc;
   char **listArgv;
   int pixArgc;
   char **pixArgv;
   char *var;
   
   var = Tcl_GetVar(interp,VarName,TCL_LEAVE_ERR_MSG);
   if ( Tcl_SplitList(interp, var, &listArgc, &listArgv) != TCL_OK) return 0;

   XColor *colors = new  XColor[listArgc+fp->offcolor()+1];
   int i;
   unsigned long p;
   unsigned short r, g, b;
   int off_color = fp->offcolor();
   int max_color = fp->maxcolor();  // The values  between 0 - off_color are common 
   int delta = max_color - off_color;
   // If workspace is allready allocated by TkPC, give it free
   unsigned long plane_mask[24];
   unsigned long *pixels = new unsigned long[listArgc+fp->offcolor()];
   if( delta < listArgc ) { // This means more colorcells 
      int off = listArgc - delta;
      for ( i = 0; i < off; i++ ) {
         if( XAllocColorCells( tkc->display, cmap, (Bool) True, plane_mask, 0, &pixels[i+max_color], 1) == 0 ) {
             return( 0 );
         }
      }
      for ( i = off_color; i < max_color; i++ ) pixels[i] = fp->pixels(i);
      fp->change_work(&pixels[off_color], listArgc+off_color);
   } 
   int l = off_color;
   for ( i = 0 ; i < listArgc; i++ ) {
     if ( Tcl_SplitList(interp, listArgv[i], &pixArgc, &pixArgv) != TCL_OK) return 0;
     if( pixArgc = 0 ) { return 0; }
   //  p = strtoul(pixArgv[0], (char **) NULL, 0);
     r = strtoul(pixArgv[1], (char **) NULL, 0);
     g = strtoul(pixArgv[2], (char **) NULL, 0);
     b = strtoul(pixArgv[3], (char **) NULL, 0);
     colors[l].flags = DoRed | DoGreen | DoBlue;
     colors[l].red = r; colors[l].green = g; colors[l].blue = b;
     colors[l].pixel = pixels[l] = fp->pixels(l);
     ++l;
     free(pixArgv);
   } 
   XStoreColors( display, cmap, &colors[off_color], listArgc);

   char stringresult[64];
   sprintf(stringresult,"%d",i);
   Tcl_SetResult(interp,stringresult,TCL_VOLATILE);
   free (listArgv);
   delete []pixels;
   delete []colors;
   return 1;
}


// This function is a replacement for the original XAllocColor
// In reality it is only a further filter,
// to determine, if the requested color
// is all ready allocated in the base_part of
// a private Colormap !
TkPC_XAllocColor(Display *d, Colormap cmap, XColor *x)
{
  Tcl_HashEntry *entry;
  Tcl_HashSearch search;

  TkPC_object *p;
  int i;
  XColor req;
  XColor aprox, exact;
  char farbe[256];
  for( entry = Tcl_FirstHashEntry(&CHashTable, &search); entry != NULL; entry = Tcl_NextHashEntry(&search)) {
       p = (TkPC_object *) Tcl_GetHashValue(entry);
    // Is this the right colormap ?
       if( p->cmap() == cmap ) {
          if( strcmp(p->type(), "default") != 0 ) {
              for ( i = 0; i < p->offcolor(); i++ ) {
                 req.pixel = p->pixels(i);
                 XQueryColor(tkc->display, p->cmap(), &req);
                 XAllocColor(tkc->display, p->cmap(), x);
                 XFreeColors(tkc->display, p->cmap(), &(x->pixel), 1, 0);
         //        sprintf(farbe,"rgb:%x/%x/%x", (int) x->red, (int) x->green, (int) x->blue );
                 if( req.red == x->red && req.green == x->green && req.blue == x->blue ) {
                     x->pixel = req.pixel;
                     x->flags = req.flags;
                     x->pad = req.pad;
                     return(1);
                 } 
              }       
          }
       }
  }
  return XAllocColor(d, cmap, x);
}

// This function is a replacement for the original XAllocNamedColor
// In reality it is only a further filter,
// to determine, if the requested color
// is all ready allocated in the base_part of
// a private Colormap !
TkPC_XAllocNamedColor(Display *d, Colormap cmap, char *n, XColor *exact, XColor *color) 
{
  Tcl_HashEntry *entry;
  Tcl_HashSearch search;

  TkPC_object *p;
  int i;
  XColor req;
  XColor *x;
  char farbe[256];
  for( entry = Tcl_FirstHashEntry(&CHashTable, &search); entry != NULL; entry = Tcl_NextHashEntry(&search)) {
       p = (TkPC_object *) Tcl_GetHashValue(entry);
    // Is this the right colormap ?
       if( p->cmap() == cmap ) {
          if( strcmp(p->type(), "default") != 0 ) {
              for ( i = 0; i < p->offcolor(); i++ ) {
                 req.pixel = p->pixels(i);
                 XLookupColor(tkc->display, p->cmap(), n, exact, color);
                 x = color;
                 XQueryColor(tkc->display, p->cmap(), &req);
                 XAllocColor(tkc->display, p->cmap(), x);
                 XFreeColors(tkc->display, p->cmap(), &(x->pixel), 1, 0);
                 if( req.red == x->red && req.green == x->green && req.blue == x->blue ) {
                     x->pixel = req.pixel;
                     x->flags = req.flags;
                     x->pad = req.pad;
                     return(1);
                 }
              }       
          }
       }
  }

  return XAllocNamedColor(d, cmap, n, exact, color);
}

Status TkPC_XFreeColors( Display *display, Colormap cmap, unsigned long *pixels, int numbers, unsigned long planes)
{
  Tcl_HashEntry *entry;
  Tcl_HashSearch search;

  TkPC_object *p;
  int i, j;
  XColor req;
  XColor *x;
  char farbe[256];
  for( entry = Tcl_FirstHashEntry(&CHashTable, &search); entry != NULL; entry = Tcl_NextHashEntry(&search)) {
       p = (TkPC_object *) Tcl_GetHashValue(entry);
       if( p->cmap() == cmap ) {
          if( strcmp(p->type(), "default") != 0 ) {
// ***********************************************************
// ***********************************************************
// *****  This is the critical part,                     *****
// *****  in all other cases we are just calling         *****
// *****  the original Funktion                          *****
// *****                                                 *****
// The aim is: Do not free Colors. which are in the base
// part of a private colormap !!
// free only those colors, which are not defined by Cmap store_base
              Status status;
              for( j = 0; j < numbers; j++ ) {
                 status = 0;
                 for ( i = 0; i < p->offcolor(); i++ ) {
                   if ( p->pixels(i) == pixels[j] ) {
                     status = 1;
                     i = p->offcolor();
                   }
                 } // end of for i
                 if ( status == 0 ) {
                    XFreeColors(display, cmap, &pixels[j], 1, planes);
                 }
              } // end of for j     
              return 1;
// *****                                                 *****
// *****                                                 *****
// *****                                                 *****
// ***********************************************************
// ***********************************************************
// ***********************************************************
          } else {
            return XFreeColors(display, cmap, pixels, numbers, planes);
          } // end of if strcmp
          break;
       } // end of if ( p->cmap() == cmap )
  }
  return XFreeColors(display, cmap, pixels, numbers, planes);
}

