#----------------------------------------------------------------------
#
#                   L A B E L   F R A M E
#
# Release Note:
#    o Due to unknown bugs in the packer, the things that you want to put
#      inside of the label frame MUST be children of the inner frame
#      returned by tixLabelFrame. i.e.
#          set w [tixLabelFrame .dialog.lb]
#          button $w.btn
#          pack append $w $w.btn {left}
#
# Introduction:
#
#
# Commands:
#
# Configuration Spec:
#
# Data structure:
#----------------------------------------------------------------------
proc tixLabelFrame {w args} {
    set var $w
    upvar #0 $var data

    # Create the widget
    #------------------
    LFRM_InitData $var $w
    LFRM_CreateWidget $var
    LFRM_MkWidgetCommand $var

    # Default bindings
    #-----------------
    bind $w <Destroy>     "LFRM_Destroy $var"

    # Configurations
    #---------------
    if {$args != {}} {
	set other_options [eval LFRM_ConfigWidget $var $args]
	if {$other_options != {}} {
	    eval $w.root config $other_options
	}
    }
    return $data(inframe)
}

#--------------------------
# InitData
#--------------------------
proc LFRM_InitData {var w} {
    upvar #0 $var data
    set data(root)   $w
}

#--------------------------
# Create Widget
#--------------------------
proc LFRM_CreateWidget {var} {
    upvar #0 $var data
    set w $data(root)
    
    frame $w    -borderwidth 3
    frame $w.f0
    frame $w.f1 -borderwidth 1 -relief sunken
    frame $w.f2 -borderwidth 1 -relief raised
    frame $w.f3 -borderwidth 3
    
    label $w.lab -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-* \
	-text "Hello" -anchor w
    
    pack $w.lab -in $w.f0
    
    pack $w.f3  -in $w.f2 -expand yes -fill both
    pack $w.f2  -in $w.f1 -expand yes -fill both
    
    pack $w.f0 -side top -fill x
    pack $w.f1 -side top -fill both -expand yes

    set data(inframe) $w.f3
    set data(label)   $w.lab
}

#--------------------------
# ConfigWidget
#--------------------------
proc LFRM_ConfigWidget {var args} {
    upvar #0 $var data

    set len  [llength $args]
    set len2 [expr {$len - 2}]
    set i 0
    set other_options {}

    while {$i <= $len2} {
	set flag [lindex $args $i]
	incr i
	set optn [lindex $args $i]
	incr i

	case $flag in {
	    -label {
		$data(label) config -text $optn
	    }
	    -innerborder {
		$data(inframe) config -border $optn
	    }
	    default {
		lappend other_options $flag
		lappend other_options $optn 
	    }
	}
    }

    if {$i != $len} {
	error "Odd number of config parameters applied to $data(root)"
    }

    return $other_options
}

proc LFRM_ConfigOptions {} {
    return {{-label label Label "" hello}}
}

#----------------------
# The Widget Command 
#----------------------
proc LFRM_MkWidgetCommand {var} {
    upvar #0 $var data
    set w $data(root)
    tixRenameWidgetCmd $w $w.root
    proc $w {option args} {
	# the name of the data structure is the same as the procedure
	#------------------------------------------------------------
	set var [lindex [info level 0] 0]
	upvar #0 $var data

	set w $data(root)

	case $option in {
	    {config configure} {
		if {$args == {}} {
		    return [LFRM_ConfigOptions]
		}
		set other_options [eval LFRM_ConfigWidget $var $args]
		if {$other_options != {}} {
		    if [catch {eval $w.root config $other_options}] {
			LFRM_ConfigOptions
		    }
		}
		return
	    }
	    default {
		$w.root $option $args
	    }
	}
    }
}


#----------------------
# Destructor
#----------------------
proc LFRM_Destroy {var} {
    upvar #0 $var data
    set w $data(root)
    tixDeleteWidgetCmd $data(root).root
    unset data
}



