// ---------------------------- -*- Mode: C++ -*- ----------------------------
// PQTclmain.cc - Shell to demo Postgres access from Tcl.
// 
// %W%
// 
// Written by
// Robin J. Maxwell
// Open Systems Solutions, Inc
// Collaboration Software Group.
// 
// Copyright (c) 1992 Open Systems Solutions, Inc
// 
// Permission to use, copy, modify, and distribute this software and its
// documentation for any purpose and without fee is hereby granted, provided
// that the above copyright notice appear in all copies.  
// Open Systems Solutions, Inc. and Robin J. Maxwell make no representations
// about the suitability of this software for any purpose.
// It is provided "as is" without express or implied warranty.
// 
// Author          : Robin J. Maxwell
// Created On      : Wed Oct 28 13:55:08 1992
// Last Modified By: Robin J. Maxwell
// Last Modified On: Wed Oct 28 14:17:21 1992
// Update Count    : 3
// Status          : Unknown, Use with caution!
// ---------------------------------------------------------------------------


#include <iostream.h>
#include <strings.h>
#include "tcl++.hpp"
#include "PQTcl.hpp"

#define PQTCLVERSION "1.0"
#define PQTCLSTARTUP "tcldefault6.4c"

extern errno;

//
// If set to be a pointer to the procedure Tcl_RecordAndEval, will link in
// history
extern int (*tclShellCmdEvalProc) ();

extern void testpqobjects();

int
main (int argc, char **argv)
{
    char         *defaultFile = PQTCLSTARTUP;
    TclInterp_cl Interp;      // Basic Tcl Interpreter.
    PQTcl postgres(Interp);   // PQ lib extensions.

    //
    // Set application specific values to return from the infox command.
    tclAppName = "PQTcl";
    tclAppLongname = "PQTcl";
    tclAppVersion = PQTCLVERSION;
   
    //
    // If history is to be used, then set the eval procedure pointer that
    // Tcl_CommandLoop so that history will be recorded.  This reference
    // also brings in history from Tcl.a.
#ifndef TCL_NOHISTORY
     tclShellCmdEvalProc = (int (*)())Tcl_RecordAndEval;
#endif

    //
    // Load the tcl startup code, this should pull in all of the tcl
    // procs, paths, command line processing, autoloads, packages, etc.
    // If Tcl was invoked interactively, Tcl_Startup will give it
    // a command loop .
//    Interp.Startup (argc, argv, defaultFile, 0);
    Interp.Startup (argc, argv, NULL, 0);
}
