# Program: xf
# Description: procedures that implement the top level functionality
#
# $Header: xfprocMain.tcl[2.4] Wed Mar 10 12:07:55 1993 garfield@garfield frozen $

proc XFProcMain {} {
##########
# Procedure: XFProcMain
# Description: show the main edit window
# Arguments: none
# Returns: none
# Sideeffects: none
##########
  global xfConf
  global xfStatus

  # set toplevel wm maxsize
  if {"[lindex [wm maxsize .] 0]" == "" && \
      "[lindex [wm maxsize .] 1]" == ""} {
    wm maxsize . [winfo screenwidth .] [winfo screenheight .]
  }
  if {$xfConf(autoRootPos)} {
    wm geometry . +0+0
  }

  # new global bindings
  XFMiscBindWidgetTree .

  # wrapper around exit
  rename exit XFExit
  catch "proc exit args {
           global xfAlertBox
           if {\"\[info commands .xfEdit\]\" != \"\"} {
             if {\[llength \$args\] > 0} {
               set xfAlertBox(toplevelName) .exit
               XFProcMessage \"Exit the program with: \[lindex \$args 0\]\" 250x100 \"Exit\" center {}
               set xfAlertBox(toplevelName) .xfAlertBox
             } {
               set xfAlertBox(toplevelName) .exit
               XFProcMessage \"Exit the program\" 250x100 \"Exit\" center {}
               set xfAlertBox(toplevelName) .xfAlertBox
             }
           } {
             XFExit \$args
           }
         }"

  # wrapper around destroy
  rename destroy XFDestroy
  catch "proc destroy xfArgs {
           if {\"\[info commands .xfEdit\]\" != \"\"} {
             if {\[string match \".xf*\" \$xfArgs\]} {
               XFDestroy \$xfArgs
             } {
               if {\[XFProcYesNo \"Destroy widget:\$xfArgs
really destroy ???\"\]} {
                 XFDestroy \$xfArgs
               }
             }
           } {
             XFDestroy \$xfArgs
           }
         }"

  # show main edit window
  XFEdit

  # start autosaving
  if {$xfConf(saveInterval) > 0} {
    after [expr $xfConf(saveInterval)*60000] XFMiscAutoSave $xfConf(saveInterval)
  }
}

# eof

