# itcl_widget
# ----------------------------------------------------------------------
# Implements an [incr tcl] wrapper for a Tk widget.
#
#   PUBLIC ATTRIBUTES: 
#
#     None
#
#   METHODS: 
#
#     configure ..... used to change public attributes
#     config ........ used to change public attributes
#
# ----------------------------------------------------------------------
#   AUTHOR:         Jim Wight <j.k.wight@newcastle.ac.uk>
#            Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1994 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================

itcl_class itcl_widget {
    # ------------------------------------------------------------------
    #  CONSTRUCTOR - create new widget
    # ------------------------------------------------------------------
    constructor {args} {
	set heritage [virtual info heritage]
	set class [virtual info class]
	
	if {[set cp [lsearch $args -class]] != -1} {
            set class "-class [lindex $args [expr $cp + 1]]"
        } elseif {[lsearch $heritage itcl_frame] != -1 ||
		                     [lsearch $heritage itcl_toplevel] != -1} {
	    set class "-class $class"
	} else {
	    set class {}
	}

        set screen {}
        if {[set sp [lsearch $args -screen]] != -1} {
            set screen "-screen [lindex $args [expr $sp + 1]]"
        }

        #
        #  Create a widget with the same name as this object
        #
	set tk_widget $this-win-
	::rename $this $this-tmp-
        #
        # Assumes inheritance from itcl_<widget> and that itcl_<widget> is
	# one earlier in heritage list than itcl_widget.
	# Generates ::widget $this [-class class] [-screen screen] command.
        #
        set index [expr [lsearch $heritage itcl_widget] - 1]
	eval ::[string range [lindex $heritage $index] 5 end] \
	                                                  $this $class $screen
	::rename $this $tk_widget
	::rename $this-tmp- $this
	::bind $this <Destroy> "catch {rename $tk_widget {}}"

        eval configure $args
    }

    # ------------------------------------------------------------------
    #  METHOD:  configure - used to return or change public attributes
    # ------------------------------------------------------------------
    method configure {args} {
	if {[llength $args] == 0} {
	    set class [$this info class]
	    set options [$tk_widget configure]
	    foreach public [$this info public] {
		set option [split $public :]
		if {[lindex $option 0] != $class} {
		    break
		}
		set opt [lindex $option 2]
		lappend options [list -$opt {} {} \
				 [$this info public $opt -init] \
				 [$this info public $opt -value]]
	    }
	    return $options
	} elseif {[llength $args] == 1} {
 	    if {[catch {set info [$tk_widget configure $args]}]} {
 		if {[set opt \
		        [$this info public [string trimleft $args -]]] != ""} {
		    return [list $args {} {} [lindex $opt 1] [lindex $opt 2]]
		} else {
		    return {}
		}
	    } else {
		return $info
	    }
	} else {
	    eval wigwam_configure $args
	}
    }

    method wigwam_configure {config} {}

    # ------------------------------------------------------------------
    #  METHOD:  config - same as configure; only really needed because tk
    #                    uses it in its  .../lib/tk/*tcl files.
    # ------------------------------------------------------------------
    method config {args} {
        eval $tk_widget configure $args
    }

    # ------------------------------------------------------------------
    #  PROC: initializeItclWidget  - generate a string, which, when
    #  evaluated in the wrapper class, will create its methods and public
    #  variables.
    # ------------------------------------------------------------------
    proc initializeItclWidget {type} {
	set out ""

	$type ._foo_

	catch {._foo_ dummy} msg
	if {[regsub {bad option.* be (.*)} $msg {\1} methods] == 0} {
	    puts {initializeItclWidget: Format of "bad option" error message has changed}
	    puts {Expected: bad option "dummy":  must/should be ...}
	    puts "     Got: $msg"
	    puts "\nPlease report this to your system administrator."
	    exit
	}      

        #
        # Create a method corresponding to each Tk widget command
        #
	regsub {(.*) or (.*)} $methods {\1 \2} methods
	regsub -all "," $methods "" methods
	foreach method $methods {
	    if {[string compare $method configure] != 0} {
		if {[string compare $method delete] == 0} {
		    append out [list method tk_delete {args} \
                                            {eval $tk_widget delete $args}] {;}
		} else {
		    append out [list method $method {args} \
                                         "eval \$tk_widget $method \$args"] {;}
		}
	    }
	}

        #
        # Create a public variable corresponding to each Tk widget option
        #
	catch {._foo_ configure} vars
	foreach option $vars {
	    set var [string range [lindex $option 0] 1 end]
	    append out [list public $var {} \
                                 "eval \$tk_widget configure -$var \\\"\$$var\\\""] {;}
	}

	#
	# Define public variables for specials -class and -screen so
	# that they don't cause any harm during configuration. The
	# real notice of these is taken in the itcl_widget constructor.
	#
        if {[lsearch {frame toplevel} $type] != -1} {
            append out [list public class {}] {;}
            if {$type == "toplevel"} {
               append out [list public screen {}] {;}
            }
        }

	destroy ._foo_

	return $out
    }

    # ------------------------------------------------------------------
    #  DESTRUCTOR - destroy window containing widget
    # ------------------------------------------------------------------
    destructor {
	::rename $tk_widget {}
	tk_destroy $this
    }

    # ------------------------------------------------------------------
    #  PROTECTED
    #    tk_widget ..... the real widget
    # ------------------------------------------------------------------
    protected tk_widget
}

proc ItclClassFromWidget {type} {
    if {[itcl_info classes itcl_$type] == ""} {
	eval \
	    "itcl_class itcl_$type {
                 inherit itcl_widget
  
                 constructor {args} {
                     eval itcl_widget::constructor \$args
                 }

                eval \[initializeItclWidget $type\]
           }"
       } 
}

auto_load destroy
