#include "tcl.h"

/* -------------------------------------------------------------------- */
procArgsCmd(clientData, interp, argc, argv)
	ClientData      clientData;
	Tcl_Interp     *interp;
	int             argc;
	char          **argv;
{
	int             result, argCount, i;
	char          **argArray = NULL, *str;



	Tcl_ResetResult(interp);

	/*
	 * Break up the argument list into argument specifiers, then process
	 * each argument specifier.
	 */

	result = Tcl_SplitList(interp, argv[3], &argCount, &argArray);
	if (result != TCL_OK) {
		goto procError;
	}
	for (i = 0; i < argCount; i++) {
		int             fieldCount, nameLength, valueLength;
		char          **fieldValues;

		/*
		 * Now divide the specifier up into name and default.
		 */

		result = Tcl_SplitList(interp, argArray[i], &fieldCount,
				       &fieldValues);
		if (result != TCL_OK) {
			goto procError;
		}
		/* a specifier can have a max of 2 fields */
		if (fieldCount > 2) {
			ckfree((char *) fieldValues);
			Tcl_AppendResult(interp,
				 "too many fields in argument specifier \"",
					 argArray[i], "\"", (char *) NULL);
			result = TCL_ERROR;
			goto procError;
		}
		/* another type of error */
		if ((fieldCount == 0) || (*fieldValues[0] == 0)) {
			ckfree((char *) fieldValues);
			Tcl_AppendResult(interp, "procedure \"", argv[1],
			     "\" has argument with no name", (char *) NULL);
			result = TCL_ERROR;
			goto procError;
		}
		/*
		 * if fieldcount is two then return a 2-tuple of the variable
		 * name
		 */
		/* and the default value for that field */

		/* the variable name is fieldValues[0]           */
		/* the variable default value is fieldValues[1]  */



		if (fieldCount == 2) {
			str = Tcl_Merge(2, fieldValues);
			Tcl_AppendElement(interp, str, 0);
		} else {
			Tcl_AppendElement(interp, fieldValues[0], 0);
		}
	}
	return TCL_OK;
procError:
	printf("error in procArgs()");

}

create_Local_Proc_Args(clientData, interp, argc, argv)
	ClientData      clientData;
	Tcl_Interp     *interp;
	int             argc;
	char          **argv;
{
	int             result, argCount, i;
	char          **argArray = NULL, *str;



	Tcl_ResetResult(interp);

	/*
	 * Break up the argument list into argument specifiers, then process
	 * each argument specifier.
	 */

	result = Tcl_SplitList(interp, argv[2], &argCount, &argArray);
	if (result != TCL_OK) {
		goto procError;
	}
	for (i = 0; i < argCount; i++) {
		int             fieldCount, nameLength, valueLength;
		char          **fieldValues;

		/*
		 * Now divide the specifier up into name and default.
		 */

		result = Tcl_SplitList(interp, argArray[i], &fieldCount,
				       &fieldValues);
		if (result != TCL_OK) {
			goto procError;
		}
		/* a specifier can have a max of 2 fields */
		if (fieldCount > 2) {
			ckfree((char *) fieldValues);
			Tcl_AppendResult(interp,
				 "too many fields in argument specifier \"",
					 argArray[i], "\"", (char *) NULL);
			result = TCL_ERROR;
			goto procError;
		}
		/* another type of error */
		if ((fieldCount == 0) || (*fieldValues[0] == 0)) {
			ckfree((char *) fieldValues);
			Tcl_AppendResult(interp, "procedure \"", argv[1],
			     "\" has argument with no name", (char *) NULL);
			result = TCL_ERROR;
			goto procError;
		}
		/*
		 * if fieldcount is two then return a 2-tuple of the variable
		 * name
		 */
		/* and the default value for that field */

		/* the variable name is fieldValues[0]           */
		/* the variable default value is fieldValues[1]  */



		if (fieldCount == 2) {
			str = Tcl_Merge(2, fieldValues);
			Tcl_AppendElement(interp, str, 0);
		} else {
			Tcl_AppendElement(interp, fieldValues[0], 0);
		}
	}
	return TCL_OK;
procError:
	printf("error in procArgs()");

}
