##############################################################################
#
# This file contains several procedures for general use
#
# Ask {Question}
#       Ask a question, and wait for the answer. Return the answer
#
# Browse {Dir}
#       Start browsing in the $Dir directory, Change dir on a click, return 
#       the filename when it is clicked. Also add an entry box, so a filename
#       can be typed. Check if it exists then.
#
# Browse:Fill {list}
#       Belongs to Browse. Fill listbox $list with the files of the current
#       directory.
#
# Change {Operation Label Entry Default length}
#       Popup a window that with four 6 widgets. Three labels, Operation,
#       Label, and Entry, describing what to do, to what, what to enter.
#       one entry field, contents are returned after ok or <return>
#       two buttons, ok and cancel. length is the length of the entry field
#
# Confirm {Msg}
#       Popup a confirmation box with a message. Display an Ok and a 
#       cancel button. Return 1 on ok and 0 on cancel
#
# MsgWindow {message}
#       This procedure brings up a box with a message
#
##############################################################################

proc Ask {{Question "What?"}} {
    global Result
    global FONT

    toplevel .ask
    wm title .ask Question
    frame .ask.e -relief raised -borderwidth 2
    message .ask.e.msg -font $FONT(ProB) -text "  $Question" -anchor w -width 300
    entry .ask.e.e -width 40
    frame .ask.b
    button .ask.b.ok -text "OK" -command \
      {set Result [.ask.e.e get]; destroy .ask}
    button .ask.b.cancel -text "Cancel" -command {set Result {}; destroy .ask}

    pack append .ask.e \
      .ask.e.msg {top  fillx pady 10} \
      .ask.e.e {top pady 20 padx 30}
    pack append .ask.b \
      .ask.b.ok {top expand fill} \
      .ask.b.cancel {top expand fill}
    pack append .ask \
      .ask.e {left filly} \
      .ask.b {left filly}

    focus .ask.e.e
    bind .ask.e.e <Return> {.ask.b.ok invoke}
    bind .ask.e.e <Space> {}
    grab .ask
    tkwait window .ask
    return $Result
}

proc Browse {{Dir .}} {
    global Result FONT env
    
    set OldDir [pwd]
    cd $Dir
    set w .browse
    catch {destroy .browse}
    toplevel $w
    wm title $w "Browse"
    
    label $w.l -text [pwd] -relief raised \
      -font $FONT(ProB) -anchor w

    frame $w.c
    frame $w.c.b -relief raised -borderwidth 2
    button $w.c.b.home -text Home -height 2 -width 8 -command \
      "cd $env(HOME); $w.l configure -text \[pwd\]; Browse:Fill $w.c.dir"
    button $w.c.b.ok -text OK -height 2 -width 8 -command \
     "set f \[$w.e.e get\]
      if {\[file isdirectory \[string trimright \$f {/}\]\] && \$f != {}} {
        cd \$f; set Dir \$f; Browse:Fill $w.c.dir; 
        $w.e.e delete 0 end; $w.l configure -text \[pwd]\
      } else {
        set Result \[pwd\]/\$f; destroy $w 
      }"
    button $w.c.b.cancel -text Cancel -height 2 -width 8 -command \
      "set Result {}; destroy $w"
    checkbutton $w.c.b.dotstar -text .* -variable BROW(DOTSTAR) \
      -onvalue .* -offvalue {} -width 4 -command \
      "Browse:Fill $w.c.dir \"* \$BROW(DOTSTAR)\""

    listbox $w.c.dir -yscroll "$w.c.s set" -font $FONT(ProB) -geometry 20x15
    scrollbar $w.c.s -command "$w.c.dir yview"

    frame $w.e -relief raised -borderwidth 2
    label $w.e.l -text "File:" -font $FONT(ProB)
    entry $w.e.e -font $FONT(ProR) -width 28

    pack append $w.c.b \
      $w.c.b.home {top pady 10 padx 10} \
      $w.c.b.ok {top pady 10} \
      $w.c.b.cancel {top pady 10} \
      $w.c.b.dotstar {bottom pady 10}
    pack append $w.c \
      $w.c.dir {left expand fill} \
      $w.c.s {left filly} \
      $w.c.b {left filly}
    pack append $w.e \
      $w.e.l {left} \
      $w.e.e {left padx 10 pady 10}
    pack append $w \
      $w.l {top fillx} \
      $w.c {top expand fillx} \
      $w.e {top fillx}
    
    bind $w.e.e <Key-Return> "$w.c.b.ok invoke"
    bind $w.c.dir <1> "
      %W select from \[%W nearest %y\]
      $w.e.e delete 0 end
      $w.e.e insert end \[selection get\]"
    bind $w.c.dir <Double-1> "$w.c.b.ok invoke"

    tk_listboxSingleSelect $w.c.dir
    focus $w.e.e
    Browse:Fill $w.c.dir
    grab $w
    tkwait window $w
    ClearMem {Browse Browse:Fill} {BROW(DOTSTAR)}
    cd $OldDir
    if [file isdir $Result] {
      return {}
    } else {
      return $Result
    }
}

proc Browse:Fill {list {spec {*}}} {
    $list delete 0 end
    $list insert end ".."
    foreach i [lsort [eval glob -nocomplain $spec]] {
        if {$i == "." || $i == ".."} continue
        if [file isdirectory $i] {
            $list insert end "$i/"
        } else {
            $list insert end $i
        }
    }
}

proc Change {Operation Label Entry Default {length 40}} {
    global Result
    global FONT

    toplevel .ea
    wm title .ea "$Operation"

    frame .ea.b
    button .ea.b.cancel -text "Cancel" \
      -command "set Result {}; destroy .ea"
    button .ea.b.ok -text "OK" \
      -command {set Result [.ea.e.f2.e1 get]; destroy .ea}
    frame .ea.e -relief raised -borderwidth 2
    frame .ea.e.f1 
    label .ea.e.f1.l1 -text "$Operation:" -anchor e -font $FONT(ProB)
    label .ea.e.f1.l2 -text "$Entry:" -anchor e -font $FONT(ProB)
    frame .ea.e.f2 
    label .ea.e.f2.l1 -text $Label -font $FONT(ProB)
    entry .ea.e.f2.e1 -width $length -font $FONT(ProR)

    pack append .ea.e.f1 \
      .ea.e.f1.l1 {top fill} \
      .ea.e.f1.l2 {top fillx pady 10}
    pack append .ea.e.f2 \
      .ea.e.f2.l1 {top fill} \
      .ea.e.f2.e1 {top fillx pady 10}
    pack append .ea.e \
      .ea.e.f1 {left padx 10 pady 20} \
      .ea.e.f2 {left padx 20 pady 20}
    pack append .ea.b \
      .ea.b.ok {top expand fill} \
      .ea.b.cancel {top expand fill}
    pack append .ea \
      .ea.e {left expand fill} \
      .ea.b {left expand fill}
     
    bind .ea.e.f2.e1 <Return> {.ea.b.ok invoke}
    .ea.e.f2.e1 insert end $Default
    grab .ea
    focus .ea.e.f2.e1
    tkwait window .ea
    return $Result 
}

proc Confirm {{Msg "Sure about that?"}} {
    global Result
    global FONT

    toplevel .confirm
    wm title .confirm Confirm
    frame .confirm.m -relief raised -borderwidth 2
    message .confirm.m.m -font $FONT(ProB) -text $Msg -width 200 -anchor w
    frame .confirm.b
    button .confirm.b.yes -text "Yes" -width 8 \
      -command {set Result 1; destroy .confirm}
    button .confirm.b.no -text "No" -width 8 \
      -command {set Result 0; destroy .confirm}

    pack append .confirm.m \
      .confirm.m.m {top padx 20 pady 20}
    pack append .confirm.b \
      .confirm.b.yes {top expand fill} \
      .confirm.b.no {top expand fill}
    pack append .confirm \
      .confirm.m {left expand fill} \
      .confirm.b {left expand fill}

    focus .confirm
    bind .confirm <Return> {.confirm.b.ok invoke}
    grab .confirm
    tkwait window .confirm
    return $Result
}

proc MsgWindow {Msg {width 200}} {
    global FONT

    set w .msg
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title  $w "Message"

    frame $w.m -relief raised -borderwidth 2
    message $w.m.m -font $FONT(ProB) -text "$Msg" -width $width -justify left
    button $w.ok -text "OK" -command "destroy $w" -width 4

    pack append $w.m \
      $w.m.m {padx 20 pady 20 top}
    pack append $w \
      $w.m {left expand fill} \
      $w.ok {left expand fill}

    bind $w <Return> "$w.ok invoke"
    focus $w
    update
    grab $w
    tkwait window $w
}
