# configure.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script reads the file .tkmailto and set the variables ftpdomains,
# ftpdirectories, content-type, transfermode, mailserver and the alias. 
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc configurevariables ####
# Open the tkmailtorc-files if they exists
#----------------------------------------------------------------------------

proc configurevariables {} {
global type
global numberoftype
global transfer
global numberoftransfer
global domainarray
global numberofdomains
global ftpdirectory
global numberofftpdir
global mailserver
global numberofmailserver
global alias
global address
global numberofalias
global HOME
global headers
global numberofheaders
global headervar
global cutmessage
global tkmailto
global bg1 bg2 actbg bheight

set cutmessage(cut) "false"

set numberofalias 0
set numberofdomains 0
set numberofftpdir 0
set numberofmailserver 0
set numberoftype 0
set numberoftransfer 0

set headers(4) "reply-to"
set headers(5) "bcc"

set numberofheaders 5

set bg1 #CACACA
set bg2 #BBBBBB
set actbg #909090
set bheight 5


if [file exists "$tkmailto(library)/tkmailtorc"] {
  set f [open $tkmailto(library)/tkmailtorc]
  set filename $tkmailto(library)/tkmailtorc
  readconfig $f $filename
  close $f
  }
if [file exists "$HOME/.tkmailtorc"] {
  set f [open "$HOME/.tkmailtorc"]
  set filename $HOME/.tkmailtorc
  readconfig $f $filename
  close $f
  }
}
#----------------------------------------------------------------------------
#### readconfig ####
# Reads the file f and updates the differents arrays you reach from
# menubuttons in the program
#----------------------------------------------------------------------------
proc readconfig {f filename} {
global type
global numberoftype
global transfer
global numberoftransfer
global domainarray
global numberofdomains
global ftpdirectory
global numberofftpdir
global mailserver
global numberofmailserver
global alias
global address
global numberofalias
global numberofheaders
global headers
global HOME
global bg1 bg2 actbg bheight

  while {![eof $f]} {
    set textline [gets $f]
    set list [split $textline " "]
    # removes all of the extra spaces from .tkmailtorc
    while {[lsearch $list ""]==1} {
      set list [lreplace $list [lsearch $list ""] [lsearch $list ""]]
    }
##Checks if -,!####
    if {[string index [string tolower [lindex $list 0]] 0]=="!"|| \
    [string index [string tolower [lindex $list 0]] 0]=="-"} {
      set tmp [string tolower [lindex $list 0]] 
      if {[string first "content-type" $tmp]==1} {
      ##Content-type##
        set tmp2 [string tolower [lindex $list 1]]
        for {set i 1} {$i <=$numberoftype} {incr i 1} {
          if {$tmp2==$type($i)} {
            for {set j $i} {$j <$numberoftype} {incr j 1} {
              set type($j) $type([expr $j+1]) 
            }
            set numberoftype [expr $numberoftype -1]
          }
        }
      } elseif {[string first "ftpdomain" $tmp]==1} {
      ##ftpdomain##
        set tmp2 [string tolower [lindex $list 1]]
        for {set i 1} {$i <=$numberofdomains} {incr i 1} {
          if {$tmp2==$domainarray($i)} {
            for {set j $i} {$j <$numberofdomains} {incr j 1} {
              set domainarray($j) $domainarray([expr $j+1])
            }
            set numberofdomains [expr $numberofdomains -1]
          }
        }
      } elseif {[string first "alias" $tmp]==1} {
      ##alias##
        set tmp2 [string tolower [lindex $list 1]]
        for {set i 1} {$i <=$numberofalias} {incr i 1} {
          if {$tmp2==$alias($i)} {
            for {set j $i} {$j <$numberofalias} {incr j 1} {
              set alias($j) $alias([expr $j+1])
              set address($j) $address([expr $j+1])
            }
            set numberofalias [expr $numberofalias -1]
         }
        }
      } elseif {[string first "ftpdir" $tmp]==1} {
      ##ftpdir##
        set tmp2 [lindex $list 1]
        for {set i 1} {$i <=$numberofftpdir} {incr i 1} {
          if {$tmp2==$ftpdirectory($i)} {
            for {set j $i} {$j <$numberofftpdir} {incr j 1} {
              set ftpdirectory($j) $ftpdirectory([expr $j+1])
            }
            set numberofftpdir [expr $numberofftpdir -1]
         }
        }
      } elseif {[string first "mailserver" $tmp]==1} {
      ##mailserver##
        set tmp2 [string tolower [lindex $list 1]]
        for {set i 1} {$i <=$numberofmailserver} {incr i 1} {
          if {$tmp2==$mailserver($i)} {
            for {set j $i} {$j <$numberofmailserver} {incr j 1} {
              set mailserver($j) $mailserver([expr $j+1])
            }
            set numberofmailserver [expr $numberofmailserver -1]
         }
        }
      } elseif {[string first "transfermode" $tmp]==1} {
      ##transfermode##
        set tmp2 [string tolower [lindex $list 1]]
        for {set i 1} {$i <=$numberoftransfer} {incr i 1} {
          if {$tmp2==$transfer($i)} {
            for {set j $i} {$j <$numberoftransfer} {incr j 1} {
              set transfer($j) $transfer([expr $j+1])
            }
            set numberoftransfer [expr $numberoftransfer -1]
         }
        }
      }
##alias
    } elseif { [lindex $list 0]=="alias"} {
      set insert 1
      for {set i $numberofalias} {$i >0} {incr i -1} {
        if {[lindex $list 1]==$alias($i)} {
          set insert 0
        }
      } 
      if {$insert==1} {
        set numberofalias [expr $numberofalias +1]
        set alias($numberofalias) [lindex $list 1]
        set address($numberofalias) [lrange $list 2 [llength $list]]
      }
##ftpdomain
    } elseif {[string tolower [lindex $list 0]]=="ftpdomain"} {
      set insert 1
      for {set i $numberofdomains} {$i >0} {incr i -1} {
        if {[string tolower [lindex $list 1]]==$domainarray($i)} {
          set insert 0
        }
      }
      if {$insert==1} {
        set numberofdomains [expr $numberofdomains +1]
        set domainarray($numberofdomains) [string tolower [lindex $list 1]]
      }
##ftpdir
    } elseif {[string tolower [lindex $list 0]]=="ftpdir"} {
      set insert 1
      for {set i $numberofftpdir} {$i >0} {incr i -1} {
        if {[lindex $list 1]==$ftpdirectory($i)} {
          set insert 0
        }
      }
      if {$insert==1} {
        set numberofftpdir [expr $numberofftpdir +1]
        set ftpdirectory($numberofftpdir) [lindex $list 1]
      }
##mailserver
    } elseif {[string tolower [lindex $list 0]]=="mailserver"} {
      set insert 1
      for {set i $numberofmailserver} {$i >0} {incr i -1} {
        if {[string tolower [lindex $list 1]]==$mailserver($i)} {
          set insert 0
        }
      }
      if {$insert==1} {
        set numberofmailserver [expr $numberofmailserver +1]
        set mailserver($numberofmailserver) [string tolower [lindex $list 1]]
      }
##content-type
    } elseif {[string tolower [lindex $list 0]]=="content-type"} {
      set insert 1
      for {set i $numberoftype} {$i >0} {incr i -1} {
        if {[string tolower [lindex $list 1]]==$type($i)|| \
        ([string index [string tolower [lindex $list 1]] 0]!="x" && \
        $filename=="$HOME/.tkmailtorc")} {
          set insert 0
        }
      }
      if {$insert==1} {
        set numberoftype [expr $numberoftype +1]
        set type($numberoftype) [string tolower [lindex $list 1]]
      }
##transfermode
    } elseif {[string tolower [lindex $list 0]]=="transfermode"} {
      set insert 1
      for {set i $numberoftransfer} {$i >0} {incr i -1} {
        if {[string tolower [lindex $list 1]]==$transfer($i)} {
          set insert 0
        }
      }
      if {$insert==1} {
        set numberoftransfer [expr $numberoftransfer +1]
        set transfer($numberoftransfer) [string tolower [lindex $list 1]]
      }
##mailheaders
    } elseif {[string tolower [lindex $list 0]]=="mailheader"} {
      set insert 1
      for {set i $numberofheaders} {$i >3} {incr i -1} {
        if {[string tolower [lindex $list 1]]==$headers($i)} {
          set insert 0
        }
      }
      if {$insert==1} {
        set numberofheaders [expr $numberofheaders +1]
        set headers($numberofheaders) [lindex $list 1]
      }
    } elseif {[string tolower [lindex $list 0]]=="background1"} {
      set bg1 [lindex $list 1]
    } elseif {[string tolower [lindex $list 0]]=="background2"} {
      set bg2 [lindex $list 1]
    } elseif {[string tolower [lindex $list 0]]=="activebackground"} {
      set actbg [lindex $list 1]
    } elseif {[string tolower [lindex $list 0]]=="bodyheight"} {
      set bheight [lindex $list 1]
    }

  } 
}

