# giffile.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the possibility to include a giffile.

#---------------------------------------------------------------------------
#### wrapgiffile ####
#---------------------------------------------------------------------------
proc wrapgiffile {} {
destroy .giffile
}

#---------------------------------------------------------------------------
#### proc includegif ####
#---------------------------------------------------------------------------
proc includegif {gifname} {
global breakpoint
global currenttext
global winnumber
global includenum
global sumofwin
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set sumofwin [expr $sumofwin+1]
set includenum [expr $includenum+1]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, then the input will be first
if {$part2 !="text"} {
   set currenttext $widgetname(1)
   set currentframe [split $currenttext .]
   set currentframe .[lindex $currentframe 1]
   set breakpoint 1.0
   }
frame .f$includenum -background $bg1

#### if first position in the current textwidget
if {$breakpoint=="1.0"} {
   pack .f$includenum -fill both -side top -before $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x
   updatesendlist $currentwidgetnumber($currenttext) $sumofwin
   set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)-1]
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) .f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"image/gif\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "\[exec mimencode -b $gifname\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "Giffile : $gifname"
   # # # # #
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll  -relief flat  -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
        "\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x

   set currentwidgetnumber(.f$includenum.canvas) [expr \
        $currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        "\[SafeTcl_makebody \"image/gif\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
        "\[exec mimencode -b $gifname\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "Giffile : $gifname"
   }
.f$includenum.canvas create text 1 10 -text "Giffile : $gifname" -anchor w
destroy .giffile

.butt.label configure -text "Including a giffile... done" -foreground #000000
}

#---------------------------------------------------------------------------
#### proc gifmenu ####
#---------------------------------------------------------------------------
proc gifmenu {} {
global gifname
global bg1 bg2 actbg
toplevel .giffile
wm title .giffile "A giffile "
wm iconname .giffile "giffile"

label .giffile.header1 -text "Include a gif-file" -background $bg1 \
	-font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -foreground red
label .giffile.header2 -text "Do you want to include the following as a gif" \
	-background $bg1
pack .giffile.header1 -side top -fill x
pack .giffile.header2 -side top -fill x

frame .giffile.f1 -relief ridge -borderwidth 2 -background $bg2
pack .giffile.f1 -fill both
label .giffile.f1.directory -text "File :" -background $bg2 
label .giffile.f1.directoryname -width 60 \
	-background $bg2 -text $gifname -anchor w
set directoryname [exec pwd]
pack .giffile.f1.directory -side left -anchor w
pack .giffile.f1.directoryname -side left 

#---------------------------------------------------------------------------
# Button actions
#---------------------------------------------------------------------------
frame .giffile.f2 -background $bg1
pack .giffile.f2 -fill both
button .giffile.f2.include -text Include -activebackground $actbg\
	-command {includegif $gifname}  -background $bg1
button .giffile.f2.quit -text Cancel -command "wrapgiffile; .butt.label \
	configure -text \"Including a giffile...Cancelled\" -foreground \
	#000000" -activebackground $actbg -background $bg1
button .giffile.f2.listdir -text "New FSBox" -background $bg1 -command \
	{wrapgiffile; giffile} -activebackground $actbg 

pack .giffile.f2.include .giffile.f2.quit .giffile.f2.listdir -side left \
	-expand yes -pady 5
grab .giffile

#---------------------------------------------------------------------------
# bind 
#---------------------------------------------------------------------------
bind . <Control-c> {destroy .giffile}
bind . <Control-d> {destroy .giffile}
}

#---------------------------------------------------------------------------
#### proc giffile ####
# Creates a FSBox with the label Select a giffile
#---------------------------------------------------------------------------
proc giffile {} {
global fsBoxMessage
global gifname

.butt.label configure -text "Including a giffile..." -foreground #3d55ff
set fsBoxMessage "Select a giffile"
set gifname [FSBox]
if [file isfile $gifname] {
   gifmenu
   }
}
