#!/usr/bin/wish -f
#
# $Id: TdChoose.tcl,v 3.1 1993/12/06 01:40:43 schmid Exp schmid $
#
# TdChoose.tcl - A simple debugger for tcl scripts
# Version 0.3
#
# Copyright (C) 1993 Gregor Schmid 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software

# Please send bug-reports, suggestions etc. to
#
# 		schmid@fb3-s7.math.tu-berlin.de
#

# This file was written with emacs using Jamie Lokier's folding mode
# That's what the funny # {{{ marks are there for

# IMPORTANT
# Either set the following variable to the full pathname of the
# directory containing TdDebug.tcl or put TdDebug.tcl somwhere in your
# auto_path and make sure that it's procs are added to tclIndex.
# Better yet: set td_priv(debugdir) in your .tdebugrc

# set td_priv(debugdir) ~/tcl/lib

if {[file exists "~/.tdebugrc"]} {source "~/.tdebugrc"}

# {{{ global variables

set td_priv(choose) debug

if {! [info exists td_priv(send)]} {
    set td_priv(send) 1
}
if {$td_priv(send)} {
    set td_ips [winfo interps]
    if {[llength $td_ips] > 1} {
	foreach i $td_ips {
	    if {$i != [winfo name .]} {
		set td_priv(interp) $i
		break
    }   }   } else {
	set td_priv(interp) <none>
	unset td_ips
}   } else {
    set td_priv(interp) [winfo name .]
}

if {! [info exists td_priv(scrollbarside)] || $td_priv(scrollbarside) != "left"} {
    set td_priv(scrollbarside) right
}

if {![info exists td_priv(constrainscroll)]} {
    set td_priv(constrainscroll) 1
}

# }}}
# {{{ procs

# {{{ td_rescanProcs

# Rescan the procs for the currently selected interpreter
# `td_priv(interp)'.
# `td_priv(choose)' should either be set to `debug' to display all procs
# or to `undebug' to display only those procs that have been prepared
# for debugging.

proc td_rescanProcs {} {
    global td_priv td_ChooseBox td_ChooseName

    $td_ChooseBox delete 0 end
    if {$td_priv(send)} {
	if {! [td_loadDebugger $td_priv(interp)]} {return}
	if {[catch {send $td_priv(interp) {info procs *}} names]} {
	    error "$names\nThis should never have happened ! Please report\
		    this error and include the backtrace info."
	}
	if {[catch {send $td_priv(interp) td_preparedProcs} procs]} {
	    error "$procs\nThis should never have happened ! Please report\
		    this error and include the backtrace info."
    }   } else {
	set names [info procs *]
	set procs [td_preparedProcs]
    }
    set names [lsort $names]
    if {$td_priv(choose) == "debug"} {
	# remove all procs belonging to TdDebug.tcl from the list to
	# avoid confusion
	set i1 [lsearch -exact $names td_AAA]
	set i2 [lsearch -exact $names td_zzz]
	if {$i1 != -1 && $i2 != -1} {
	    set names [lreplace $names $i1 $i2]
	}
	foreach i $names {
	    if {[lsearch -exact $procs $i] == -1} {
		$td_ChooseBox insert end " $i"
	    } else {
		$td_ChooseBox insert end "*$i"
    }   }   } else {
	eval "$td_ChooseBox insert 0 $procs"
    }   
}

# }}}
# {{{ td_chooseOK

# Prepare or restore the proc that has been selected via double-click
# according to the value of `td_priv(choose)'.
# Args:
# y		y-position of mouse cursor

proc td_chooseOK y {
    global td_priv td_ChooseBox

    set sel [$td_ChooseBox nearest $y]
    
    if {$sel != ""} {
	set name [$td_ChooseBox get $sel]
    }
    if {$name != ""} {
	if {$td_priv(send)} {
	    if {! [td_loadDebugger $td_priv(interp)]} {return}
	}
	if {$td_priv(choose) == "debug"} {
	    set name [string range $name 1 end]
	    # give some visible response
	    $td_ChooseBox select clear
	    update
	    if {$td_priv(send)} {
		if {[catch {send $td_priv(interp) \
			"td_prepareProc $name"} err]} {
		    error "$err\nThis should never have happened ! Please report\
			    this error and include the backtrace info."
	    }   } else {
		td_prepareProc $name
	    }
	    $td_ChooseBox select from $sel
	    $td_ChooseBox delete $sel
	    $td_ChooseBox insert $sel "*$name"
	} else {
	    if {$td_priv(send)} {
		if {[catch {send $td_priv(interp) \
			"td_restoreProc $name"} err]} {
		    error "$err\nThis should never have happened ! Please report\
			    this error and include the backtrace info."
	    }   } else {
		td_restoreProc $name
	    }
	    set view [$td_ChooseBox nearest 0]
	    td_rescanProcs
	    $td_ChooseBox yview $view
}   }   }

# }}}
# {{{ td_makeInterpMenu

# Setup the menu to change the selected interpreter. Don't diplay the
# interpreter of the Chooser

proc td_makeInterpMenu {} {
    global td_ChooseMenu td_ChooseMB

    $td_ChooseMenu delete 0 last
    set interps [winfo interps]
    set myind [lsearch -exact $interps [winfo name .]]
    set interps [lreplace $interps $myind $myind]
    if {$interps != ""} {
	foreach i $interps {
	    $td_ChooseMenu add command -label $i -command "td_doChange $i"
    }   } else {
	$td_ChooseMenu add command -label " <none> " 
	$td_ChooseMenu disable 0
    }
}

# }}}
# {{{ td_doChange

# Change `td_priv(interp)' to the interpreter chosen and
# call `td_rescan' to update the display.

proc td_doChange {args} {
    global td_priv
    set td_priv(interp) $args
    td_rescanProcs
}
    

# }}}
# {{{ td_popDebugger

# Make sure selected interpreter has sourced TdDebug.tcl  and popup
# Debugger window

proc td_popDebugger {} {
    global td_priv
    if {$td_priv(send)} {
	if {! [td_loadDebugger $td_priv(interp)]} {return}
	if {[catch {send $td_priv(interp) {wm deiconify $td_Top}} err]} {
	    error "$err\nThis should never have happened ! Please report\
		    this error and include the backtrace info."
    }   } else {
	global td_Top
	wm deiconify $td_Top
}   }

# }}}
# {{{ td_loadDebugger

# Check if TdDebug has been sourced. If not, try to do it.
# Catch fails of send to avoid exiting when hitting an inactive
# interpreter
# Args:
# interp	Interpreter to check
# Return value:
#		1	successfull
#		0	not successfull

proc td_loadDebugger interp {
    global td_priv

    if {[catch {send $interp "info procs td_eval"} procs]} {
	if {[string match "X server insecure*" $procs]} {
	    tkerror "$procs\nSee Installation section of README !"
	} else {
	    tkerror $procs
	}
	return 0
    }
    if {$procs == ""} {
	if {[info exists td_priv(debugdir)]} {
	    if {[catch {send $interp "source $td_priv(debugdir)/TdDebug.tcl"} err]} {
		tkerror $err
		return 0
	}   } else {
	    if {[catch {send $interp "td_forceLoad"} err]} {
		tkerror $err
		return 0
    }   }   }
    return 1
}

# }}}
# {{{ td_catchChooseScroll

proc td_catchChooseScroll {a b c d} {
    global td_ChooseScroll td_ChooseBox
    if {$a < $b && $c > 0} {
	$td_ChooseBox yview 0
	$td_ChooseScroll set $a $b 0 [expr $b - 1]
    } elseif {$a -$c < $b} {
	$td_ChooseBox yview [expr $a - $b]
	$td_ChooseScroll set $a $b [expr $a - $b] [expr $a - 1]
    } else {
	$td_ChooseScroll set $a $b $c $d
    }
}

# }}}
    
# }}}
# {{{ interface

# {{{ setup symbolic widget names for Chooser

if {$td_priv(send)} {
    set td_Choose 	""
} else {
    set td_Choose	.td_Choose
}
set td_ChooseNameFrame	$td_Choose.chooseNameFrame
set td_ChooseLabel	$td_ChooseNameFrame.chooseLabel
set td_ChooseButton	$td_ChooseNameFrame.chooseButton
set td_ChooseMenu	$td_ChooseButton.menu
set td_ChooseName	$td_ChooseNameFrame.chooseName

set td_ChoosePop	$td_Choose.pop

set td_ChooseFrame	$td_Choose.chooseFrame
set td_ChooseBox	$td_ChooseFrame.chooseBox
set td_ChooseScroll	$td_ChooseFrame.chooseScroll

set td_ChooseBFrame	$td_Choose.chooseBFrame
set td_ChooseButtons1	$td_ChooseBFrame.chooseButtons1
set td_ChooseBDebug 	$td_ChooseButtons1.chooseDebug
set td_ChooseBUndebug 	$td_ChooseButtons1.chooseUndebug

set td_ChooseBExit	$td_ChooseBFrame.chooseBExit

# }}}
# {{{ Chooser Toplevel

if {$td_priv(send)} {
    wm title . TDebug-Choose
    . configure -borderwidth 2
} else {
    toplevel $td_Choose -class TDebug-Choose
    wm title $td_Choose TDebug-Choose
}

# }}}
# {{{ the name

frame $td_ChooseNameFrame -borderwidth 2 -relief raised 
pack $td_ChooseNameFrame -side top -fill x -padx 2 -pady 2
label $td_ChooseLabel -text Interp: -width 8
pack $td_ChooseLabel -side left
if {$td_priv(send)} {
    menubutton $td_ChooseButton -relief raised -text "+" -width 1 \
	    -menu $td_ChooseMenu
    pack $td_ChooseButton -side left 
    menu $td_ChooseMenu -postcommand td_makeInterpMenu
}
entry $td_ChooseName -relief groove -textvariable td_priv(interp) -state disabled \
	-width 8
pack $td_ChooseName -side left -expand 1 -fill both

# }}}
# {{{ pop

button $td_ChoosePop -text "Popup Debugger" -command td_popDebugger
pack $td_ChoosePop -side top -fill x -padx 2 -pady 2

# }}}
# {{{ the listbox

frame $td_ChooseFrame -borderwidth 2 -relief raised
pack $td_ChooseFrame -side top -expand 1 -fill both -padx 2 -pady 2

scrollbar $td_ChooseScroll -command "$td_ChooseBox yview"
pack $td_ChooseScroll -side $td_priv(scrollbarside) -fill y

listbox $td_ChooseBox -relief sunken -setgrid 1 -geometry 17x3
if {$td_priv(constrainscroll)} {
    $td_ChooseBox configure -yscrollcommand td_catchChooseScroll
} else {
    $td_ChooseBox configure -yscrollcommand "$td_ChooseScroll set"
}
pack $td_ChooseBox -side $td_priv(scrollbarside) -expand 1 -fill both

# }}}
# {{{ the buttons

frame $td_ChooseBFrame
pack $td_ChooseBFrame -side top -fill x -padx 2 -pady 2
frame $td_ChooseButtons1
pack $td_ChooseButtons1 -side left -fill x -expand 1

radiobutton $td_ChooseBDebug -relief raised -text "Prepare" -width 4 \
	-variable td_priv(choose) -value debug \
	-command td_rescanProcs
pack $td_ChooseBDebug -side top -fill x

radiobutton $td_ChooseBUndebug -relief raised -text "Restore" -width 4 \
	-variable td_priv(choose) -value undebug \
	-command td_rescanProcs
pack $td_ChooseBUndebug -side top -fill x

button $td_ChooseBExit -relief raised -text "Exit" -width 4 -height 2 -command {
    if {$td_priv(send)} {destroy .} else {destroy $td_Choose}
}
pack $td_ChooseBExit -side left -fill both -expand 1

# }}}

if {$td_priv(send)} {
    wm geometry . 20x10
} else {
    wm geometry $td_Choose 20x10
}
$td_ChooseBox configure -exportselection no  -selectbackground \
        [lindex [$td_ChooseBDebug configure -activebackground] 3]
bind $td_ChooseBox <Enter> {%W select from [%W nearest %y]}
bind $td_ChooseBox <Leave> {%W select clear}
bind $td_ChooseBox <Any-Motion> {%W select from [%W nearest %y]}
bind $td_ChooseBox <Any-Motion> {%W select from [%W nearest %y]}
bind $td_ChooseBox <Button-2> {+ %W select clear}
bind $td_ChooseBox <B2-Motion> {%W scan dragto %x %y}
bind $td_ChooseBox <ButtonRelease-2> {%W select from [%W nearest %y]}
bind $td_ChooseBox <1> "td_chooseOK %y"

set td_priv(choose) debug

# }}}

if {! $td_priv(send)} {
    if {[info exists td_priv(debugdir)]} {
	source $td_priv(debugdir)/TdDebug.tcl
    } else {
	td_forceLoad
    }   
    td_rescanProcs
} elseif {$td_priv(interp) != "<none>"} {
    td_rescanProcs
}   

# {{{ Emacs Local Variables


# Local Variables:
# folded-file: t
# End:

# }}}
