'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /rel/cvsfiles/unsupported/latest/tk/doc/entry.n,v 1.1 1993/01/24 04:59:30 zoo Exp $ SPRITE (Berkeley)
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS entry cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
entry \- Create and manipulate entry widgets
.SH SYNOPSIS
\fBentry\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBbackground\fR	\fBforeground\fR	\fBinsertWidth\fR	\fBselectForeground\fR
\fBborderWidth\fR	\fBinsertBackground\fR	\fBrelief\fR	\fBtextVariable\fR
\fBcursor\fR	\fBinsertBorderWidth\fR	\fBscrollCommand\fR
\fBexportSelection\fR	\fBinsertOffTime\fR	\fBselectBackground\fR
\fBfont\fR	\fBinsertOnTime\fR	\fBselectBorderWidth\fR
.VE
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
.VS
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of two states for the entry:  \fBnormal\fR or \fBdisabled\fR.
If the entry is disabled then the value may not be changed using widget
commands and no insertion cursor will be displayed, even if the input focus is
in the widget.
.VE
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies an integer value indicating the desired width of the entry window,
in average-size characters of the widget's font.
.BE

.SH DESCRIPTION
.PP
The \fBentry\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into an entry widget.
Additional options, described above, may be specified on the
command line or in the option database
to configure aspects of the entry such as its colors, font,
and relief.  The \fBentry\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
An entry is a widget that displays a one-line text string and
allows that string to be edited using widget commands described below, which
are typically bound to keystrokes and mouse actions.
When first created, an entry's string is empty.
A portion of the entry may be selected as described below.
.VS
If an entry is exporting its selection (see the \fBexportSelection\fR
option), then it will observe the standard X11 protocols for handling the
.VE
selection;  entry selections are available as type \fBSTRING\fR.
Entries also observe the standard Tk rules for dealing with the
input focus.  When an entry has the input focus it displays an
\fIinsertion cursor\fR to indicate where new characters will be
inserted.
.PP
Entries are capable of displaying strings that are too long to
fit entirely within the widget's window.  In this case, only a
portion of the string will be displayed;  commands described below
may be used to change the view in the window.  Entries use
the standard \fBscrollCommand\fR mechanism for interacting with
scrollbars (see the description of the \fBscrollCommand\fR option
for details).  They also support scanning, as described below.

.SH "WIDGET COMMAND"
.PP
The \fBentry\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
.PP
Many of the widget commands for entries take one or more indices as
arguments.  An index specifies a particular character in the entry's
string, in any of the following ways:
.TP 12
\fInumber\fR
Specifies the character as a numerical index, where 0 corresponds
to the first character in the string.
.TP 12
\fBend\fR
Indicates the character just after the last one in the entry's string.
This is equivalent to specifying a numerical index equal to the length
of the entry's string.
.TP 12
\fBinsert\fR
.VS
.VE
Indicates the character adjacent to and immediately following the
insertion cursor.
.TP 12
\fBsel.first\fR
Indicates the first character in the selection.  It is an error to
use this form if the selection isn't in the entry window.
.TP 12
\fBsel.last\fR
Indicates the last character in the selection.  It is an error to
use this form if the selection isn't in the entry window.
.TP 12
\fB@\fInumber\fR
In this form, \fInumber\fR is treated as an x-coordinate in the
entry's window;  the character spanning that x-coordinate is used.
For example, ``\fB@0\fR'' indicates the left-most character in the
window.
.LP
Abbreviations may be used for any of the forms above, e.g. ``\fBe\fR''
or ``\fBsel.f\fR''.  In general, out-of-range indices are automatically
rounded to the nearest legal value.
.PP
The following commands are possible for entry widgets:
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBentry\fR
command.
.TP
\fIpathName \fBdelete \fIfirst \fR?\fIlast\fR?
Delete one or more elements of the entry.  \fIFirst\fR and \fIlast\fR
are indices of of the first and last characters in the range to
be deleted.   If \fIlast\fR isn't specified it defaults to
\fIfirst\fR, i.e. a single character is deleted.  This command
returns an empty string.
.TP
\fIpathName \fBget\fR
Returns the entry's string.
.TP
\fIpathName \fBicursor \fIindex\fR
.VS
Arrange for the insertion cursor to be displayed just before the character
given by \fIindex\fR.  Returns an empty string.
.VE
.TP
\fIpathName \fBindex\fI index\fR
Returns the numerical index corresponding to \fIindex\fR.
.TP
\fIpathName \fBinsert \fIindex string\fR
Insert the characters of \fIstring\fR just before the character
indicated by \fIindex\fR.  Returns an empty string.
.TP
\fIpathName \fBscan\fR \fIoption args\fR
This command is used to implement scanning on entries.  It has
two forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBscan mark \fIx\fR
Records \fIx\fR and the current view in the entry window;  used in
conjunction with later \fBscan dragto\fR commands.  Typically this
command is associated with a mouse button press in the widget.  It
returns an empty string.
.TP
\fIpathName \fBscan dragto \fIx\fR
This command computes the difference between its \fIx\fR argument
and the \fIx\fR argument to the last \fBscan mark\fR command for
the widget.  It then adjusts the view left or right by 10 times the
difference in x-coordinates.  This command is typically associated
with mouse motion events in the widget, to produce the effect of
dragging the entry at high speed through the window.  The return
value is an empty string.
.RE
.TP
\fIpathName \fBselect \fIoption arg\fR
This command is used to adjust the selection within an entry.  It
has several forms, depending on \fIoption\fR:
.RS
.TP
\fIpathName \fBselect adjust \fIindex\fR
Locate the end of the selection nearest to the character given by
\fIindex\fR, and adjust that end of the selection to be at \fIindex\fR
(i.e including but not going beyond \fIindex\fR).  The other
end of the selection is made the anchor point for future
\fBselect to\fR commands.  If the selection
isn't currently in the entry, then a new selection is created to
include the characters between \fIindex\fR and the most recent
selection anchor point, inclusive.
Returns an empty string.
.TP
\fIpathName \fBselect clear\fR
Clear the selection if it is currently in this widget.  If the
selection isn't in this widget then the command has no effect.
Returns an empty string.
.TP
\fIpathName \fBselect from \fIindex\fR
Set the selection anchor point to just before the character
given by \fIindex\fR.  Doesn't change the selection.
Returns an empty string.
.TP
\fIpathName \fBselect to \fIindex\fR
Set the selection to consist of the elements from the anchor
point to element \fIindex\fR, inclusive.  The anchor point is
determined by the most recent \fBselect from\fR or \fBselect adjust\fR
command in this widget.  If the selection isn't in this widget
then a new selection is created using the most recent anchor point
specified for the widget.  Returns an empty string.
.RE
.TP
\fIpathName \fBview \fIindex\fR
Adjust the view in the entry so that element \fIindex\fR is
at the left edge of the window.  Returns an empty string.

.SH "DEFAULT BINDINGS"
.PP
.VS
Tk automatically creates class bindings for entries that give them
the following default behavior:
.IP [1]
Clicking mouse button 1 in an entry positions the insertion cursor
just before the character underneath the mouse cursor and sets the
input focus to this widget.
.IP [2]
Dragging with mouse button 1 strokes out a selection between
the insertion cursor and the character under the mouse.
.IP [3]
The ends of the selection can be adjusted by dragging with mouse
button 1 while the shift key is down;  this will adjust the end
of the selection that was nearest to the mouse cursor when button
1 was pressed.
.IP [4]
The view in the entry can be adjusted by dragging with mouse button 2.
.IP [5]
If the input focus is in an entry widget and characters are typed on the
keyboard, the characters are inserted just before the insertion cursor.
.IP [6]
Control-h and the Backspace and Delete keys erase the character just
before the insertion cursor.
.IP [7]
Control-w erases the word just before the insertion cursor.
.IP [8]
Control-u clears the entry to an empty string.
.IP [9]
Control-v inserts the current selection just before the insertion cursor.
.IP [10]
Control-d deletes the selected characters;  an error occurs if the selection
is not in this widget.
.PP
If the entry is disabled using the \fBstate\fR option, then the entry's
view can still be adjusted and text in the entry can still be selected,
but no insertion cursor will be displayed and no text modifications will
take place.
.PP
The behavior of entries can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.VE

.SH KEYWORDS
entry, widget
