
set TCL_CMD 0
set CMD_SUB 1
set VAR_SUB 2

proc test {} {

  puts stdout "((O*U&^^()*&)*&^(*&^(*&(*&^(&*^(&^(*^"

}

# given a function_name globally bound, leave it alone if the
# function_purpose (also globally bound) is CMD_SUB or VAR_SUB. If the
# purpose is TCL_CMD, then make the function_name
# Tcl_${function_name}_Cmd



# -------------------

proc close_function {} {

  global func_name func_purpose c_code TCL_CMD CMD_SUB VAR_SUB

  if {$func_purpose==$TCL_CMD} {append c_code "
    /*
     * Delete the call frame for this procedure invocation (it's
     * important to remove the call frame from the interpreter
     * before deleting it, so that traces invoked during the
     * deletion don't see the partially-deleted frame).
     */

    procDone:
    iPtr->framePtr = frame.callerPtr;
    iPtr->varFramePtr = frame.callerVarPtr;
    TclDeleteVars(iPtr, &frame.varTable);


return TCL_OK ;
<end code>
"
  set c_code "#define ${func_name}_cmd_strlen  [llength [split $c_code ""]]
$c_code"
}

  if {$func_purpose==$CMD_SUB} {\
append c_code "
Tcl_Eval (interp, cmd_str, 0,0) ;
return strdup(interp->result) ;
<end code>
"
set c_code "#define ${func_name}_cmd_strlen  [llength [split $c_code ""]]\n\n
$c_code"
}

  if {$func_purpose==$VAR_SUB} {append c_code "<end code>"}

}

# -------------------

proc create_function_header {} {
  
  global func_name func_purpose c_code TCL_CMD CMD_SUB VAR_SUB


    puts stdout "pouiq243trp87 fy9q4fhupaerhvfdnpjs9p84ef3yht9w2ferhujiwqoncadkp"

  if {$func_purpose==$TCL_CMD} {puts stdout "OPTION *!*" ; 
				set new_func_name "Tcl_${func_name}_Cmd" 
			       set ccfp [open create_cmds.c a]
			       puts $ccfp "Tcl_CreateCommand (interp, \"$func_name\", $new_func_name, (ClientData) NULL, (void (*)()) NULL) ;"
			       puts stdout "Tcl_CreateCommand (interp, \"$func_name\", $new_func_name, (ClientData) NULL, (void (*)()) NULL) ;"
			       close $ccfp
				append c_code "
$new_func_name (clientData, interp, argc, argv)
ClientData clientData ;
Tcl_Interp * interp   ;
int          argc     ;
char     **  argv     ;
<begin code>
char cmd_str\[${func_name}_cmd_strlen\] ;
register Interp *iPtr = (Interp *) interp;
CallFrame frame;
cmd_str\[0\]=0 ;
    Tcl_InitHashTable(&frame.varTable, TCL_STRING_KEYS);
    if (iPtr->varFramePtr != NULL) {
	frame.level = iPtr->varFramePtr->level + 1;
    } else {
	frame.level = 1;
    }
    frame.argc = argc;
    frame.argv = argv;
    frame.callerPtr = iPtr->framePtr;
    frame.callerVarPtr = iPtr->varFramePtr;
    iPtr->framePtr = &frame;
    iPtr->varFramePtr = &frame;
"
			      }
 
  if {$func_purpose==$VAR_SUB} {puts stdout "-- varsub" ; 
				append c_code "
char * $func_name (interp)
Tcl_Interp * interp ;
<begin code>
"
			      }

  if {$func_purpose==$CMD_SUB} {puts stdout "-- cmdsub" ; 
				append c_code "
char * $func_name (interp)
Tcl_Interp * interp   ;
<begin code>
char cmd_str\[${func_name}_cmd_strlen\] ;
cmd_str\[0\]=0 ;
"
			      }
}


# -------------------------------------------------------------------

proc tclProcToCFunc {procName procArgs procBody} {
  puts "procName: $procName"
  puts "procArgs: $procArgs"
  puts "ProcBody: $procBody"
  append sourceCode [codeForCFunctionHeader $procName]
  append sourceCode [codeToCheckArgs $procArgs]
  append sourceCode [codeForArgumentBinding $procArgs]
# now we must have a Tcl interface to AssembleCmd
  append sourceCode "return TCL_OK\n"
  append sourceCode "\}\n"
  set fp [open |cb w]
  puts $fp $sourceCode
  flush $fp
  close $fp
}

# -------------------------------------------------------------------

proc convert {fileName} {
  source $fileName
  set fp [open $fileName]
  # get the list of procs in the file
  set procList ""
  while {[gets $fp line] >= 0} {
    if [regexp {^proc[ ]+([^ ]*)} $line match procName] {
      lappend procList [chopRight $line]
    }
  }
  close $fp

  foreach proc $procList {
    tclProcToCFunc [lsecond $proc] [concat [eval procArgs $proc]] [info body [lsecond $proc]]
  }
}


# -------------------------------------------------------------------


proc codeForCFunctionHeader {procName} {
  append sourceCode "int ${procName}Cmd (dummy , interp , argc , argv) \n"
  append sourceCode "ClientData dummy ;\nTcl_Interp * interp ;\n"
  append sourceCode "int argc ;\nchar ** argv ;\n\{\n"
  return $sourceCode
}


# ----------------------------------------------------------------------

proc codeForArgumentBinding {arguments} {
  # the command name is argv[0] the arguments to the command start at
  # argv[1]. therefore in order to have correct indexing into the
  # argv array for the arguments, we start at 1
  set argc 1

  puts "**\n**\narguments: $arguments" 	

  foreach argument [lindex $arguments 0] {

	  puts "**\n**\nargument: $argument" 	

    set matched [scan $argument "%s %s" name default]

    if {$name=="args"} {
      append sourceCode "Tcl_Merge (argc-([expr 1+$argc]) , &argv[$argc])"
      return "$sourceCode\n"
    }


    if {$matched==2} {\
      append sourceCode "BindOrDefault (interp , \"$name\" , argv\[$argc\] , \"$default\") ; \n"
    } 
    if {$matched==1} {\
      append sourceCode "Tcl_SetVar (interp , \"$name\" , argv\[$argc\] , NULL) ; \n"
    }
    if {($matched==0) || ($matched>2)} {\
      puts "error in argument $argument"
    }

    incr argc
  }
  return "$sourceCode\n"
}


# ---------------------------------------------------------------------


proc codeToCheckArgs {arguments} {

  append sourceCode "if (argc != [expr [llength $arguments]+1]) \{ \n"
  append sourceCode     "Tcl_AppendResult(interp, \"wrong # args: should be \", argv\[0\], \" $arguments\", (char *) NULL) ; \n"
  append sourceCode "return TCL_ERROR ; \n" 
  append sourceCode "\} \n"

  return $sourceCode 
}

# ---------------------------------------------------------------------

proc current_frame {frame_number} {

  global current , frame ;

  set current $frame_number ;

  set frame($current) "" ;

}

proc add_to_current {string} {

  global current , frame ;

  append frame($current) "$string\n" 

}

proc dump_frames {} {
global frame ;

foreach f [bubbleSortOnIndex [array names frame] lessThan 0] {


  append t "frame: $f\n"
  append t $frame($f) 

}

return $t

}	
